/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImpExpAbstract;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONReader;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseImport
extends ODatabaseImpExpAbstract {
    private Map<OPropertyImpl, String> linkedClasses = new HashMap<OPropertyImpl, String>();
    private Map<OClass, String> superClasses = new HashMap<OClass, String>();
    private OJSONReader jsonReader;
    private ORecordInternal<?> record;
    private List<String> recordToDelete = new ArrayList<String>();
    private boolean schemaImported = false;
    private int exporterVersion = -1;

    public ODatabaseImport(ODatabaseDocument database, String iFileName, OCommandOutputListener iListener) throws IOException {
        super(database, iFileName, iListener);
        FilterInputStream inStream;
        BufferedInputStream bf = new BufferedInputStream(new FileInputStream(this.fileName));
        bf.mark(1024);
        try {
            inStream = new GZIPInputStream(bf);
        }
        catch (Exception e) {
            bf.reset();
            inStream = bf;
        }
        this.jsonReader = new OJSONReader(new InputStreamReader(inStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    public ODatabaseImport(ODatabaseDocument database, InputStream iStream, OCommandOutputListener iListener) throws IOException {
        super(database, "streaming", iListener);
        this.jsonReader = new OJSONReader(new InputStreamReader(iStream));
        database.declareIntent(new OIntentMassiveInsert());
    }

    public ODatabaseImport importDatabase() {
        try {
            try {
                this.listener.onMessage("\nStarted import of database '" + this.database.getURL() + "' from " + this.fileName + "...");
                long time = System.currentTimeMillis();
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                this.database.getLevel1Cache().setEnable(false);
                this.database.getLevel2Cache().setEnable(false);
                this.database.setMVCC(false);
                this.database.setValidationEnabled(false);
                this.database.setStatus(ODatabase.STATUS.IMPORTING);
                while (this.jsonReader.hasNext() && this.jsonReader.lastChar() != '}') {
                    String tag = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                    if (tag.equals("info")) {
                        this.importInfo();
                        continue;
                    }
                    if (tag.equals("clusters")) {
                        this.importClusters();
                        continue;
                    }
                    if (tag.equals("schema")) {
                        this.importSchema();
                        continue;
                    }
                    if (tag.equals("records")) {
                        this.importRecords();
                        continue;
                    }
                    if (tag.equals("indexes")) {
                        this.importIndexes();
                        continue;
                    }
                    if (!tag.equals("manualIndexes")) continue;
                    this.importManualIndexes();
                }
                this.deleteHoleRecords();
                this.database.setStatus(ODatabase.STATUS.OPEN);
                this.listener.onMessage("\n\nDatabase import completed in " + (System.currentTimeMillis() - time) + " ms");
            }
            catch (Exception e) {
                System.err.println("Error on database import happened just before line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber());
                e.printStackTrace();
                throw new ODatabaseExportException("Error on importing database '" + this.database.getName() + "' from file: " + this.fileName, e);
            }
            Object var5_4 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            throw throwable;
        }
        return this;
    }

    private void deleteHoleRecords() {
        this.listener.onMessage("\nDelete temporary records...");
        ORecordId rid = new ORecordId();
        ODocument doc = new ODocument(rid);
        for (String recId : this.recordToDelete) {
            doc.reset();
            rid.fromString(recId);
            doc.delete();
        }
        this.listener.onMessage("OK (" + this.recordToDelete.size() + " records)");
    }

    private void importInfo() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database info...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            if (fieldName.equals("exporter-version")) {
                this.exporterVersion = this.jsonReader.readInteger(OJSONReader.NEXT_IN_OBJECT);
                continue;
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.listener.onMessage("OK");
    }

    private void importManualIndexes() throws IOException, ParseException {
        this.listener.onMessage("\nImporting manual index entries...");
        ODocument doc = new ODocument();
        this.database.getMetadata().getIndexManager().reload();
        int n = 0;
        do {
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            if (indexName == null || indexName.length() == 0) {
                return;
            }
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            OIndex<?> index = this.database.getMetadata().getIndexManager().getIndex(indexName);
            long tot = 0L;
            this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
            do {
                String value;
                if ((value = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY).trim()).isEmpty()) continue;
                if (!((Boolean)(doc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, doc)).field("binary")).booleanValue()) {
                    index.put(doc.field("key"), (OIdentifiable)doc.field("rid"));
                } else {
                    ORuntimeKeyIndexDefinition runtimeKeyIndexDefinition = (ORuntimeKeyIndexDefinition)index.getDefinition();
                    OBinarySerializer binarySerializer = runtimeKeyIndexDefinition.getSerializer();
                    index.put(binarySerializer.deserialize((byte[])doc.field("key"), 0), (OIdentifiable)doc.field("rid"));
                }
                ++tot;
            } while (this.jsonReader.lastChar() == ',');
            if (index != null) {
                this.listener.onMessage("OK (" + tot + " entries)");
                ++n;
            } else {
                this.listener.onMessage("ERR, the index wasn't found in configuration");
            }
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        } while (this.jsonReader.lastChar() == ',');
        this.listener.onMessage("\nDone. Imported " + n + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private void importSchema() throws IOException, ParseException {
        this.listener.onMessage("\nImporting database schema...");
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        int schemaVersion = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"version\"").readNumber(OJSONReader.ANY_NUMBER, true);
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR).readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"classes\"").readNext(OJSONReader.BEGIN_COLLECTION);
        long classImported = 0L;
        try {
            do {
                int classDefClusterId;
                this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
                String className = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
                String string = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                if (string.equals("\"id\"")) {
                    String string3 = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
                    string3 = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
                }
                if (this.jsonReader.isContent("\"default-cluster-id\"")) {
                    String string4 = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    classDefClusterId = Integer.parseInt(string4);
                } else {
                    classDefClusterId = this.database.getDefaultClusterId();
                }
                String classClusterIds = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"cluster-ids\"").readString(OJSONReader.NEXT_IN_OBJECT).trim();
                OClassImpl cls = (OClassImpl)this.database.getMetadata().getSchema().getClass(className);
                if (cls != null) {
                    if (cls.getDefaultClusterId() != classDefClusterId) {
                        cls.setDefaultClusterId(classDefClusterId);
                    }
                } else {
                    cls = (OClassImpl)this.database.getMetadata().getSchema().createClass(className, classDefClusterId);
                }
                if (classClusterIds != null) {
                    classClusterIds = classClusterIds.substring(1, classClusterIds.length() - 1);
                    for (int i : OStringSerializerHelper.splitIntArray(classClusterIds)) {
                        cls.addClusterId(i);
                    }
                }
                while (this.jsonReader.lastChar() == ',') {
                    this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
                    String value = this.jsonReader.getValue();
                    if (value.equals("\"strictMode\"")) {
                        String strictMode = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setStrictMode(Boolean.valueOf(strictMode));
                        continue;
                    }
                    if (value.equals("\"oversize\"")) {
                        String oversize = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setOverSize(Float.parseFloat(oversize));
                        continue;
                    }
                    if (value.equals("\"short-name\"")) {
                        String shortName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        cls.setShortName(shortName);
                        continue;
                    }
                    if (value.equals("\"super-class\"")) {
                        String classSuper = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                        this.superClasses.put(cls, classSuper);
                        continue;
                    }
                    if (!value.equals("\"properties\"")) continue;
                    this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
                    while (this.jsonReader.lastChar() != ']') {
                        this.importProperty(cls);
                        if (this.jsonReader.lastChar() != '}') continue;
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    }
                    this.jsonReader.readNext(OJSONReader.END_OBJECT);
                }
                ++classImported;
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            } while (this.jsonReader.lastChar() == ',');
            for (Map.Entry<OClass, String> entry : this.superClasses.entrySet()) {
                entry.getKey().setSuperClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            for (Map.Entry<Comparable<OClass>, String> entry : this.linkedClasses.entrySet()) {
                ((OPropertyImpl)entry.getKey()).setLinkedClass(this.database.getMetadata().getSchema().getClass(entry.getValue()));
            }
            this.database.getMetadata().getSchema().save();
            this.listener.onMessage("OK (" + classImported + " classes)");
            this.schemaImported = true;
            this.jsonReader.readNext(OJSONReader.END_OBJECT);
            this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.listener.onMessage("ERROR (" + classImported + " entries): " + e);
        }
    }

    private void importProperty(OClass iClass) throws IOException, ParseException {
        this.jsonReader.readNext(OJSONReader.NEXT_OBJ_IN_ARRAY);
        if (this.jsonReader.lastChar() == ']') {
            return;
        }
        String propName = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
        String next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        if (next.equals("\"id\"")) {
            next = this.jsonReader.readString(OJSONReader.COMMA_SEPARATOR);
            next = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).getValue();
        }
        next = this.jsonReader.checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
        OType type = OType.valueOf(next);
        String value = null;
        String min = null;
        String max = null;
        String linkedClass = null;
        OType linkedType = null;
        boolean mandatory = false;
        boolean notNull = false;
        Map<String, String> customFields = null;
        while (this.jsonReader.lastChar() == ',') {
            this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
            String attrib = this.jsonReader.getValue();
            if (!attrib.equals("\"customFields\"")) {
                value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            }
            if (attrib.equals("\"min\"")) {
                min = value;
                continue;
            }
            if (attrib.equals("\"max\"")) {
                max = value;
                continue;
            }
            if (attrib.equals("\"linked-class\"")) {
                linkedClass = value;
                continue;
            }
            if (attrib.equals("\"mandatory\"")) {
                mandatory = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"not-null\"")) {
                notNull = Boolean.parseBoolean(value);
                continue;
            }
            if (attrib.equals("\"linked-type\"")) {
                linkedType = OType.valueOf(value);
                continue;
            }
            if (!attrib.equals("\"customFields\"")) continue;
            customFields = this.importCustomFields();
        }
        OPropertyImpl prop = (OPropertyImpl)iClass.getProperty(propName);
        if (prop == null) {
            prop = (OPropertyImpl)iClass.createProperty(propName, type);
        }
        prop.setMandatory(mandatory);
        prop.setNotNull(notNull);
        if (min != null) {
            prop.setMin(min);
        }
        if (max != null) {
            prop.setMax(max);
        }
        if (linkedClass != null) {
            this.linkedClasses.put(prop, linkedClass);
        }
        if (linkedType != null) {
            prop.setLinkedType(linkedType);
        }
        if (customFields != null) {
            for (Map.Entry entry : customFields.entrySet()) {
                prop.setCustom((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private Map<String, String> importCustomFields() throws ParseException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
        while (this.jsonReader.lastChar() != '}') {
            String key = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
            String value = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
            result.put(key, value);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return result;
    }

    private long importClusters() throws ParseException, IOException {
        this.listener.onMessage("\nImporting clusters...");
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        ORecordId rid = null;
        while (this.jsonReader.lastChar() != ']') {
            int clusterId;
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            String name = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"name\"").readString(OJSONReader.COMMA_SEPARATOR);
            if (name.length() == 0) {
                name = null;
            }
            if (name != null) {
                if (this.includeClusters != null) {
                    if (!this.includeClusters.contains(name)) {
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        continue;
                    }
                } else if (this.excludeClusters != null && this.excludeClusters.contains(name)) {
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    continue;
                }
            }
            int id = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"id\"").readInteger(OJSONReader.COMMA_SEPARATOR);
            String type = this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"type\"").readString(OJSONReader.NEXT_IN_OBJECT);
            rid = this.jsonReader.lastChar() == ',' ? new ORecordId(this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT).checkContent("\"rid\"").readString(OJSONReader.NEXT_IN_OBJECT)) : null;
            this.listener.onMessage("\n- Creating cluster " + (name != null ? "'" + name + "'" : "NULL") + "...");
            int n = clusterId = name != null ? this.database.getClusterIdByName(name) : -1;
            if (clusterId == -1) {
                clusterId = this.database.addCluster(type, name, null, null, new Object[0]);
            }
            if (clusterId != id) {
                throw new OConfigurationException("Imported cluster '" + name + "' has id=" + clusterId + " different from the original: " + id);
            }
            this.listener.onMessage("OK, assigned id=" + clusterId);
            ++total;
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        }
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        this.listener.onMessage("\nDone. Imported " + total + " clusters");
        return total;
    }

    private long importRecords() throws Exception {
        long total = 0L;
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        long totalRecords = 0L;
        System.out.print("\nImporting records...");
        int lastClusterId = 0;
        long clusterRecords = 0L;
        while (this.jsonReader.lastChar() != ']') {
            ORID rid = this.importRecord();
            if (rid != null) {
                ++clusterRecords;
                if (rid.getClusterId() != lastClusterId || this.jsonReader.lastChar() == ']') {
                    System.out.print("\n- Imported records into cluster '" + this.database.getClusterNameById(lastClusterId) + "' (id=" + lastClusterId + "): " + clusterRecords + " records");
                    clusterRecords = 0L;
                    lastClusterId = rid.getClusterId();
                }
                ++totalRecords;
            } else {
                lastClusterId = 0;
            }
            this.record = null;
        }
        this.listener.onMessage("\n\nDone. Imported " + totalRecords + " records\n");
        this.jsonReader.readNext(OJSONReader.COMMA_SEPARATOR);
        return total;
    }

    private ORID importRecord() throws Exception {
        block25: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
                            while (!value.isEmpty() && value.charAt(0) != '{') {
                                value = value.substring(1);
                            }
                            this.record = null;
                            this.record = ORecordSerializerJSON.INSTANCE.fromString(value, this.record);
                            if (!this.schemaImported || !this.record.getIdentity().toString().equals(this.database.getStorage().getConfiguration().schemaRecordId)) break block21;
                            ORID oRID = null;
                            Object var10_9 = null;
                            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                            return oRID;
                        }
                        if (this.includeClusters == null) break block22;
                        if (this.includeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) break block23;
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        ORID oRID = null;
                        Object var10_10 = null;
                        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                        return oRID;
                    }
                    if (this.excludeClusters == null || !this.excludeClusters.contains(this.database.getClusterNameById(this.record.getIdentity().getClusterId()))) break block23;
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    ORID oRID = null;
                    Object var10_11 = null;
                    this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                    return oRID;
                }
                if (this.record.getIdentity().getClusterId() != 0 || this.record.getIdentity().getClusterPosition() != 1L) break block24;
                ORID oRID = null;
                Object var10_12 = null;
                this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
                return oRID;
            }
            if (this.exporterVersion < 3) break block25;
            int oridsId = this.database.getClusterIdByName("ORIDs");
            int indexId = this.database.getClusterIdByName("index");
            if (this.record.getIdentity().getClusterId() != indexId && this.record.getIdentity().getClusterId() != oridsId) break block25;
            ORID oRID = null;
            Object var10_13 = null;
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            return oRID;
        }
        try {
            try {
                String rid = this.record.getIdentity().toString();
                long nextAvailablePos = this.database.getStorage().getClusterDataRange(this.record.getIdentity().getClusterId())[1] + 1L;
                if (this.record.getIdentity().getClusterPosition() < nextAvailablePos) {
                    this.record.setVersion(Integer.MIN_VALUE + this.record.getVersion());
                    if (this.record instanceof ODocument) {
                        this.record.save();
                    } else {
                        ((ODatabaseRecord)this.database.getUnderlying()).save(this.record);
                    }
                } else {
                    String clusterName = this.database.getClusterNameById(this.record.getIdentity().getClusterId());
                    if (this.record.getIdentity().getClusterPosition() > nextAvailablePos) {
                        int holes = (int)(this.record.getIdentity().getClusterPosition() - nextAvailablePos);
                        ODocument tempRecord = new ODocument();
                        for (int i = 0; i < holes; ++i) {
                            tempRecord.reset();
                            ((ODatabaseRecord)this.database.getUnderlying()).save(tempRecord, clusterName);
                            this.recordToDelete.add(tempRecord.getIdentity().toString());
                        }
                    }
                    this.record.setIdentity(-1, -1L);
                    if (this.record instanceof ODocument) {
                        this.record.save(clusterName);
                    } else {
                        ((ODatabaseRecord)this.database.getUnderlying()).save(this.record, clusterName);
                    }
                }
                if (!this.record.getIdentity().toString().equals(rid)) {
                    throw new OSchemaException("Imported record '" + this.record.getIdentity() + "' has rid different from the original: " + rid);
                }
                Object var10_14 = null;
            }
            catch (Exception t) {
                if (this.record != null) {
                    System.err.println("Error importing record " + this.record.getIdentity() + ". Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber());
                } else {
                    System.err.println("Error importing record. Source line " + this.jsonReader.getLineNumber() + ", column " + this.jsonReader.getColumnNumber());
                }
                throw t;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            throw throwable;
        }
        this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
        return this.record.getIdentity();
    }

    private void importIndexes() throws IOException, ParseException {
        this.listener.onMessage("\nImporting indexes ...");
        String indexMgrRecordId = this.database.getStorage().getConfiguration().indexMgrRecordId;
        ((ORecordInternal)this.database.load(new ORecordId(indexMgrRecordId))).clear().save();
        OIndexManagerProxy indexManager = this.database.getMetadata().getIndexManager();
        indexManager.reload();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        int n = 0;
        while (this.jsonReader.lastChar() != ']') {
            this.jsonReader.readNext(OJSONReader.BEGIN_OBJECT);
            String indexName = null;
            String indexType = null;
            Set<Object> clustersToIndex = new HashSet();
            OIndexDefinition indexDefinition = null;
            while (this.jsonReader.lastChar() != '}') {
                String fieldName = this.jsonReader.readString(OJSONReader.FIELD_ASSIGNMENT);
                if (fieldName.equals("name")) {
                    indexName = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("type")) {
                    indexType = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
                    continue;
                }
                if (fieldName.equals("clustersToIndex")) {
                    clustersToIndex = this.importClustersToIndex();
                    continue;
                }
                if (!fieldName.equals("definition")) continue;
                indexDefinition = this.importIndexDefinition();
            }
            this.jsonReader.readNext(OJSONReader.NEXT_IN_ARRAY);
            this.listener.onMessage("\n- Index '" + indexName + "'...");
            indexManager.dropIndex(indexName);
            int[] clusterIdsToIndex = new int[clustersToIndex.size()];
            int i = 0;
            for (String string : clustersToIndex) {
                clusterIdsToIndex[i] = this.database.getClusterIdByName(string);
                ++i;
            }
            indexManager.createIndex(indexName, indexType, indexDefinition, clusterIdsToIndex, null);
            ++n;
            this.listener.onMessage("OK");
        }
        this.listener.onMessage("\nDone. Created " + n + " indexes.");
        this.jsonReader.readNext(OJSONReader.NEXT_IN_OBJECT);
    }

    private Set<String> importClustersToIndex() throws IOException, ParseException {
        HashSet<String> clustersToIndex = new HashSet<String>();
        this.jsonReader.readNext(OJSONReader.BEGIN_COLLECTION);
        while (this.jsonReader.lastChar() != ']') {
            String clusterToIndex = this.jsonReader.readString(OJSONReader.NEXT_IN_ARRAY);
            clustersToIndex.add(clusterToIndex);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return clustersToIndex;
    }

    private OIndexDefinition importIndexDefinition() throws IOException, ParseException {
        OIndexDefinition indexDefinition;
        this.jsonReader.readString(OJSONReader.BEGIN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String className = this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        this.jsonReader.readNext(OJSONReader.FIELD_ASSIGNMENT);
        String value = this.jsonReader.readString(OJSONReader.END_OBJECT, true);
        ODocument indexDefinitionDoc = (ODocument)ORecordSerializerJSON.INSTANCE.fromString(value, null);
        try {
            Class<?> indexDefClass = Class.forName(className);
            indexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            indexDefinition.fromStream(indexDefinitionDoc);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Error during deserialization of index definition", e);
        }
        this.jsonReader.readString(OJSONReader.NEXT_IN_OBJECT);
        return indexDefinition;
    }

    public void close() {
        this.database.declareIntent(null);
    }
}

