/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.exception;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;

public class OConcurrentModificationException
extends ONeedRetryException {
    private static final String MESSAGE_RECORD_VERSION = "your=v";
    private static final String MESSAGE_DB_VERSION = "db=v";
    private static final long serialVersionUID = 1L;
    private final ORID rid;
    private final int databaseVersion;
    private final int recordVersion;

    public OConcurrentModificationException(String message) {
        super(message);
        int beginPos = message.indexOf(35);
        int endPos = message.indexOf(32, beginPos);
        this.rid = new ORecordId(message.substring(beginPos, endPos));
        beginPos = message.indexOf(MESSAGE_DB_VERSION, endPos) + MESSAGE_DB_VERSION.length();
        endPos = message.indexOf(32, beginPos);
        this.databaseVersion = Integer.parseInt(message.substring(beginPos, endPos));
        beginPos = message.indexOf(MESSAGE_RECORD_VERSION, endPos) + MESSAGE_RECORD_VERSION.length();
        endPos = message.indexOf(41, beginPos);
        this.recordVersion = Integer.parseInt(message.substring(beginPos, endPos));
    }

    public OConcurrentModificationException(String message, ORID iRID, int iDatabaseVersion, int iRecordVersion) {
        super(message);
        this.rid = iRID;
        this.databaseVersion = iDatabaseVersion;
        this.recordVersion = iRecordVersion;
    }

    public int getDatabaseVersion() {
        return this.databaseVersion;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public ORID getRid() {
        return this.rid;
    }
}

