/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OClassIndexManager
extends ODocumentHookAbstract {
    @Override
    public boolean onRecordBeforeCreate(ODocument iRecord) {
        iRecord = this.checkForLoading(iRecord);
        this.checkIndexedPropertiesOnCreation(iRecord);
        return false;
    }

    @Override
    public void onRecordAfterCreate(ODocument iRecord) {
        ORecord<Object> rid = (iRecord = this.checkForLoading(iRecord)).getIdentity().isPersistent() ? iRecord.placeholder() : iRecord;
        OClass cls = iRecord.getSchemaClass();
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.put(keyItem, rid);
                    }
                    continue;
                }
                if (key == null) continue;
                oIndex.put(key, rid);
            }
        }
    }

    @Override
    public boolean onRecordBeforeUpdate(ODocument iRecord) {
        iRecord = this.checkForLoading(iRecord);
        this.checkIndexedPropertiesOnUpdate(iRecord);
        return false;
    }

    @Override
    public void onRecordAfterUpdate(ODocument iRecord) {
        HashSet<String> dirtyFields;
        OClass cls = (iRecord = this.checkForLoading(iRecord)).getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()))).isEmpty()) {
            for (OIndex oIndex : indexes) {
                if (oIndex.getDefinition() instanceof OCompositeIndexDefinition) {
                    this.processCompositeIndexUpdate(oIndex, dirtyFields, iRecord);
                    continue;
                }
                this.processSingleIndexUpdate(oIndex, dirtyFields, iRecord);
            }
        }
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
    }

    @Override
    public boolean onRecordBeforeDelete(ODocument iDocument) {
        if (iDocument.fields() == 0) {
            iDocument.reload();
        }
        return false;
    }

    @Override
    public void onRecordAfterDelete(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator indexIterator = indexes.iterator();
                while (indexIterator.hasNext()) {
                    OIndex oIndex = (OIndex)indexIterator.next();
                    boolean result = oIndex.getDefinition() instanceof OCompositeIndexDefinition ? this.processCompositeIndexDelete(oIndex, dirtyFields, iRecord) : this.processSingleIndexDelete(oIndex, dirtyFields, iRecord);
                    if (!result) continue;
                    indexIterator.remove();
                }
            }
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.remove(keyItem, iRecord);
                    }
                    continue;
                }
                if (key == null) continue;
                oIndex.remove(key, iRecord);
            }
        }
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
    }

    private void processCompositeIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            Object origValue = indexDefinition.createValue(origValues);
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            if (origValue != null) {
                index.remove(origValue, iRecord);
            }
            if (newValue != null) {
                index.put(newValue, iRecord.placeholder());
            }
            return;
        }
    }

    private void processSingleIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap<Object, Integer> keysToAdd = new HashMap<Object, Integer>();
            HashMap<Object, Integer> keysToRemove = new HashMap<Object, Integer>();
            for (OMultiValueChangeEvent<String, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (OMultiValueChangeEvent<String, Object> keyToRemove : keysToRemove.keySet()) {
                index.remove(keyToRemove, iRecord);
            }
            for (OMultiValueChangeEvent<String, Object> keyToAdd : keysToAdd.keySet()) {
                index.put(keyToAdd, iRecord.placeholder());
            }
        } else {
            Object origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            if (origValue instanceof Collection && newValue instanceof Collection) {
                HashSet valuesToRemove = new HashSet((Collection)origValue);
                HashSet valuesToAdd = new HashSet((Collection)newValue);
                valuesToRemove.removeAll((Collection)newValue);
                valuesToAdd.removeAll((Collection)origValue);
                for (Object valueToRemove : valuesToRemove) {
                    if (valueToRemove == null) continue;
                    index.remove(valueToRemove, iRecord);
                }
                for (Object valueToAdd : valuesToAdd) {
                    if (valueToAdd == null) continue;
                    index.put(valueToAdd, iRecord);
                }
            } else {
                if (origValue instanceof Collection) {
                    for (Object origValueItem : (Collection)origValue) {
                        if (origValueItem == null) continue;
                        index.remove(origValueItem, iRecord);
                    }
                } else if (origValue != null) {
                    index.remove(origValue, iRecord);
                }
                if (newValue instanceof Collection) {
                    for (Object newValueItem : (Collection)newValue) {
                        index.put(newValueItem, iRecord.placeholder());
                    }
                } else if (newValue != null) {
                    index.put(newValue, iRecord.placeholder());
                }
            }
        }
    }

    private boolean processCompositeIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            Object origValue = indexDefinition.createValue(origValues);
            if (origValue != null) {
                index.remove(origValue, iRecord);
            }
            return true;
        }
        return false;
    }

    private boolean processSingleIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(restoredMultiValue);
            } else {
                origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            }
            if (origValue instanceof Collection) {
                for (Object valueItem : (Collection)origValue) {
                    if (valueItem == null) continue;
                    index.remove(valueItem, iRecord);
                }
            } else if (origValue != null) {
                index.remove(origValue, iRecord);
            }
            return true;
        }
        return false;
    }

    private void checkIndexedPropertiesOnCreation(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        for (OIndex oIndex : indexes) {
            Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
            if (key instanceof Collection) {
                for (Object keyItem : (Collection)key) {
                    if (keyItem == null) continue;
                    oIndex.checkEntry(iRecord, keyItem);
                }
                continue;
            }
            if (key == null) continue;
            oIndex.checkEntry(iRecord, key);
        }
    }

    private void checkIndexedPropertiesOnUpdate(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
        if (dirtyFields.isEmpty()) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        block0: for (OIndex oIndex : indexes) {
            OIndexDefinition indexDefinition = oIndex.getDefinition();
            List<String> indexFields = indexDefinition.getFields();
            for (String indexField : indexFields) {
                if (!dirtyFields.contains(indexField)) continue;
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.checkEntry(iRecord, keyItem);
                    }
                    continue block0;
                }
                if (key == null) continue block0;
                oIndex.checkEntry(iRecord, key);
                continue block0;
            }
        }
    }

    private ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OIndexException("Error during loading of record with id : " + iRecord.getIdentity());
            }
        }
        return iRecord;
    }
}

