/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCompositeIndexDefinition
extends ODocumentWrapperNoClass
implements OIndexDefinition {
    private final List<OIndexDefinition> indexDefinitions = new LinkedList<OIndexDefinition>();
    private String className;

    public OCompositeIndexDefinition() {
    }

    public OCompositeIndexDefinition(String iClassName) {
        super(new ODocument());
        this.className = iClassName;
    }

    public OCompositeIndexDefinition(String iClassName, List<? extends OIndexDefinition> iIndexes) {
        super(new ODocument());
        this.indexDefinitions.addAll(iIndexes);
        this.className = iClassName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void addIndex(OIndexDefinition indexDefinition) {
        this.indexDefinitions.add(indexDefinition);
    }

    @Override
    public List<String> getFields() {
        LinkedList<String> fields = new LinkedList<String>();
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            fields.addAll(indexDefinition.getFields());
        }
        return Collections.unmodifiableList(fields);
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        OCompositeKey compositeKey = new OCompositeKey();
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            Comparable result = (Comparable)indexDefinition.getDocumentValueToIndex(iDocument);
            if (result == null) {
                return null;
            }
            compositeKey.addKey(result);
        }
        return compositeKey;
    }

    @Override
    public Comparable<?> createValue(List<?> params) {
        int currentParamIndex = 0;
        OCompositeKey compositeKey = new OCompositeKey();
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            if (currentParamIndex + 1 > params.size()) break;
            int endIndex = currentParamIndex + indexDefinition.getParamCount() > params.size() ? params.size() : currentParamIndex + indexDefinition.getParamCount();
            List<?> indexParams = params.subList(currentParamIndex, endIndex);
            currentParamIndex += indexDefinition.getParamCount();
            Comparable keyValue = (Comparable)indexDefinition.createValue(indexParams);
            if (keyValue == null) {
                return null;
            }
            compositeKey.addKey(keyValue);
        }
        return compositeKey;
    }

    @Override
    public Comparable<?> createValue(Object ... params) {
        return this.createValue((List)Arrays.asList(params));
    }

    @Override
    public int getParamCount() {
        int total = 0;
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            total += indexDefinition.getParamCount();
        }
        return total;
    }

    @Override
    public OType[] getTypes() {
        LinkedList types = new LinkedList();
        for (OIndexDefinition indexDefinition : this.indexDefinitions) {
            Collections.addAll(types, indexDefinition.getTypes());
        }
        return types.toArray(new OType[types.size()]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeIndexDefinition that = (OCompositeIndexDefinition)o;
        if (!this.className.equals(that.className)) {
            return false;
        }
        return this.indexDefinitions.equals(that.indexDefinitions);
    }

    @Override
    public int hashCode() {
        int result = this.indexDefinitions.hashCode();
        result = 31 * result + this.className.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "OCompositeIndexDefinition{indexDefinitions=" + this.indexDefinitions + ", className='" + this.className + '\'' + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        ArrayList<ODocument> inds = new ArrayList<ODocument>(this.indexDefinitions.size());
        ArrayList<String> indClasses = new ArrayList<String>(this.indexDefinitions.size());
        try {
            this.document.field("className", this.className);
            for (OIndexDefinition indexDefinition : this.indexDefinitions) {
                ODocument indexDocument = indexDefinition.toStream();
                inds.add(indexDocument);
                indClasses.add(indexDefinition.getClass().getName());
            }
            this.document.field("indexDefinitions", inds, OType.EMBEDDEDLIST);
            this.document.field("indClasses", indClasses, OType.EMBEDDEDLIST);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        return this.document;
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType) {
        StringBuilder ddl = new StringBuilder("create index ");
        ddl.append(indexName).append(" on ").append(this.className).append(" ( ");
        Iterator<String> fieldIterator = this.getFields().iterator();
        if (fieldIterator.hasNext()) {
            ddl.append(fieldIterator.next());
            while (fieldIterator.hasNext()) {
                ddl.append(", ").append(fieldIterator.next());
            }
        }
        ddl.append(" ) ").append(indexType);
        return ddl.toString();
    }

    @Override
    protected void fromStream() {
        try {
            this.className = (String)this.document.field("className");
            List inds = (List)this.document.field("indexDefinitions");
            List indClasses = (List)this.document.field("indClasses");
            this.indexDefinitions.clear();
            for (int i = 0; i < indClasses.size(); ++i) {
                Class<?> clazz = Class.forName((String)indClasses.get(i));
                ODocument indDoc = (ODocument)inds.get(i);
                OIndexDefinition indexDefinition = (OIndexDefinition)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                indexDefinition.fromStream(indDoc);
                this.indexDefinitions.add(indexDefinition);
            }
        }
        catch (ClassNotFoundException e) {
            throw new OIndexException("Error during composite index deserialization", e);
        }
        catch (NoSuchMethodException e) {
            throw new OIndexException("Error during composite index deserialization", e);
        }
        catch (InvocationTargetException e) {
            throw new OIndexException("Error during composite index deserialization", e);
        }
        catch (InstantiationException e) {
            throw new OIndexException("Error during composite index deserialization", e);
        }
        catch (IllegalAccessException e) {
            throw new OIndexException("Error during composite index deserialization", e);
        }
    }
}

