/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeDatabaseLazySave;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProviderAbstract;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexMVRBTreeAbstract<T>
extends OSharedResourceAdaptiveExternal
implements OIndexInternal<T> {
    protected static final String CONFIG_MAP_RID = "mapRid";
    protected static final String CONFIG_CLUSTERS = "clusters";
    protected String name;
    protected String type;
    protected OMVRBTreeDatabaseLazySave<Object, T> map;
    protected Set<String> clustersToIndex = new LinkedHashSet<String>();
    protected OIndexDefinition indexDefinition;
    @ODocumentInstance
    protected ODocument configuration;
    private final OMemoryWatchDog.Listener watchDog;

    public OIndexMVRBTreeAbstract(String iType) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
        this.type = iType;
        this.watchDog = new OMemoryWatchDog.Listener(){

            public void memoryUsageLow(long iFreeMemory, long iFreeMemoryPercentage) {
                OIndexMVRBTreeAbstract.this.map.setOptimization(iFreeMemoryPercentage < 10L ? 2 : 1);
            }
        };
    }

    @Override
    public void flush() {
        this.lazySave();
    }

    public OIndexInternal<?> create(String iName, OIndexDefinition iIndexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener, OStreamSerializer iValueSerializer) {
        this.acquireExclusiveLock();
        try {
            try {
                this.name = iName;
                this.configuration = new ODocument();
                this.indexDefinition = iIndexDefinition;
                if (iClusterIdsToIndex != null) {
                    for (int id : iClusterIdsToIndex) {
                        this.clustersToIndex.add(iDatabase.getClusterNameById(id));
                    }
                }
                if (this.indexDefinition != null) {
                    if (this.indexDefinition instanceof ORuntimeKeyIndexDefinition) {
                        this.map = new OMVRBTreeDatabaseLazySave(iClusterIndexName, ((ORuntimeKeyIndexDefinition)this.indexDefinition).getSerializer(), iValueSerializer, 1);
                    } else {
                        OBinarySerializer<OCompositeKey> keySerializer = this.indexDefinition.getTypes().length > 1 ? OCompositeKeySerializer.INSTANCE : OBinarySerializerFactory.INSTANCE.getObjectSerializer(this.indexDefinition.getTypes()[0]);
                        this.map = new OMVRBTreeDatabaseLazySave(iClusterIndexName, keySerializer, iValueSerializer, this.indexDefinition.getTypes().length);
                    }
                } else {
                    this.map = new OMVRBTreeDatabaseLazySave(iClusterIndexName, new OSimpleKeySerializer(), iValueSerializer, 1);
                }
                this.installHooks(iDatabase);
                this.rebuild(iProgressListener);
                this.updateConfiguration();
            }
            catch (Exception e) {
                if (this.map != null) {
                    this.map.delete();
                }
                if (e instanceof OIndexException) {
                    throw (OIndexException)e;
                }
                throw new OIndexException("Cannot create the index '" + iName + "'", e);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexInternal<T> loadFromConfiguration(ODocument iConfig) {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            block20: {
                ORID rid = (ORID)iConfig.field(CONFIG_MAP_RID, ORID.class);
                if (rid == null) {
                    throw new OIndexException("Error during deserialization of index definition: 'mapRid' attribute is null");
                }
                this.configuration = iConfig;
                this.name = (String)this.configuration.field("name");
                ODocument indexDefinitionDoc = (ODocument)this.configuration.field("indexDefinition");
                if (indexDefinitionDoc != null) {
                    try {
                        String indexDefClassName = (String)this.configuration.field("indexDefinitionClass");
                        Class<?> indexDefClass = Class.forName(indexDefClassName);
                        this.indexDefinition = (OIndexDefinition)indexDefClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.indexDefinition.fromStream(indexDefinitionDoc);
                    }
                    catch (ClassNotFoundException e) {
                        throw new OIndexException("Error during deserialization of index definition", e);
                    }
                    catch (NoSuchMethodException e) {
                        throw new OIndexException("Error during deserialization of index definition", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new OIndexException("Error during deserialization of index definition", e);
                    }
                    catch (InstantiationException e) {
                        throw new OIndexException("Error during deserialization of index definition", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new OIndexException("Error during deserialization of index definition", e);
                    }
                } else {
                    Boolean isAutomatic = (Boolean)this.configuration.field("automatic");
                    if (Boolean.TRUE.equals(isAutomatic)) {
                        int pos = this.name.lastIndexOf(46);
                        if (pos < 0) {
                            throw new OIndexException("Can not convert from old index model to new one. Invalid index name. Dot (.) separator should be present.");
                        }
                        String className = this.name.substring(0, pos);
                        String propertyName = this.name.substring(pos + 1);
                        String keyTypeStr = (String)this.configuration.field("keyType");
                        if (keyTypeStr == null) {
                            throw new OIndexException("Can not convert from old index model to new one. Index key type is absent.");
                        }
                        OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                        this.indexDefinition = new OPropertyIndexDefinition(className, propertyName, keyType);
                        this.configuration.removeField("automatic");
                        this.configuration.removeField("keyType");
                    } else if (this.configuration.field("keyType") != null) {
                        String keyTypeStr = (String)this.configuration.field("keyType");
                        OType keyType = OType.valueOf(keyTypeStr.toUpperCase(Locale.ENGLISH));
                        this.indexDefinition = new OSimpleKeyIndexDefinition(keyType);
                        this.configuration.removeField("keyType");
                    }
                }
                this.clustersToIndex.clear();
                Collection clusters = (Collection)this.configuration.field(CONFIG_CLUSTERS);
                if (clusters != null) {
                    this.clustersToIndex.addAll(clusters);
                }
                this.map = new OMVRBTreeDatabaseLazySave(this.getDatabase(), rid);
                try {
                    this.map.load();
                }
                catch (Exception e) {
                    if (!this.onCorruptionRepairDatabase(null, "load", "Index will be rebuilt")) break block20;
                    if (this.isAutomatic()) {
                        OLogManager.instance().warn((Object)this, "Cannot load index '%s' from storage (rid=%s): rebuilt it from scratch", this.getName(), rid);
                    }
                    this.rebuild();
                }
            }
            this.installHooks(iConfig.getDatabase());
            oIndexMVRBTreeAbstract = this;
            Object var11_19 = null;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object iKey) {
        boolean bl;
        this.acquireExclusiveLock();
        try {
            bl = this.map.containsKey(iKey);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return bl;
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo) {
        return this.getValuesBetween(iRangeFrom, true, iRangeTo, true);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo) {
        return this.getEntriesBetween(iRangeFrom, iRangeTo, true);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        return this.getValuesMajor(fromKey, isInclusive, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        return this.getValuesMinor(toKey, isInclusive, -1);
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        return this.getEntriesMajor(fromKey, isInclusive, -1);
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        return this.getEntriesMinor(toKey, isInclusive, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive) {
        return this.getValuesBetween(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive, -1);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        return this.getEntriesBetween(iRangeFrom, iRangeTo, iInclusive, -1);
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        return this.getValues(iKeys, -1);
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        return this.getEntries(iKeys, -1);
    }

    @Override
    public ORID getIdentity() {
        return ((OMVRBTreeProviderAbstract)this.map.getProvider()).getRecord().getIdentity();
    }

    @Override
    public long rebuild() {
        return this.rebuild(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long rebuild(OProgressListener iProgressListener) {
        long documentIndexed;
        block24: {
            documentIndexed = 0L;
            boolean intentInstalled = this.getDatabase().declareIntent(new OIntentMassiveInsert());
            this.acquireExclusiveLock();
            try {
                try {
                    try {
                        this.map.clear();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    int documentNum = 0;
                    long documentTotal = 0L;
                    for (String cluster : this.clustersToIndex) {
                        documentTotal += this.getDatabase().countClusterElements(cluster);
                    }
                    if (iProgressListener != null) {
                        iProgressListener.onBegin(this, documentTotal);
                    }
                    for (String clusterName : this.clustersToIndex) {
                        try {
                            for (ORecord record : this.getDatabase().browseCluster(clusterName)) {
                                if (record instanceof ODocument) {
                                    ODocument doc = (ODocument)record;
                                    if (this.indexDefinition == null) {
                                        throw new OConfigurationException("Index '" + this.name + "' cannot be rebuilt because has no a valid definition (" + this.indexDefinition + ")");
                                    }
                                    Object fieldValue = this.indexDefinition.getDocumentValueToIndex(doc);
                                    if (fieldValue != null) {
                                        if (fieldValue instanceof Collection) {
                                            for (Object fieldValueItem : (Collection)fieldValue) {
                                                this.put(fieldValueItem, doc);
                                            }
                                        } else {
                                            this.put(fieldValue, doc);
                                        }
                                        ++documentIndexed;
                                    }
                                }
                                ++documentNum;
                                if (iProgressListener == null) continue;
                                iProgressListener.onProgress(this, documentNum, (float)documentNum * 100.0f / (float)documentTotal);
                            }
                        }
                        catch (NoSuchElementException e) {
                        }
                    }
                    this.lazySave();
                    if (iProgressListener != null) {
                        iProgressListener.onCompletition(this, true);
                    }
                }
                catch (Exception e) {
                    if (iProgressListener != null) {
                        iProgressListener.onCompletition(this, false);
                    }
                    try {
                        this.map.clear();
                        throw new OIndexException("Error on rebuilding the index for clusters: " + this.clustersToIndex, e);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw new OIndexException("Error on rebuilding the index for clusters: " + this.clustersToIndex, e);
                }
                Object var17_18 = null;
                if (!intentInstalled) break block24;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                if (intentInstalled) {
                    this.getDatabase().declareIntent(null);
                }
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.getDatabase().declareIntent(null);
        }
        this.releaseExclusiveLock();
        return documentIndexed;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iValue) {
        return this.remove(iKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) {
        boolean bl;
        this.acquireExclusiveLock();
        try {
            bl = this.map.remove(key) != null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<T> clear() {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.map.clear();
            oIndexMVRBTreeAbstract = this;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexInternal<T> delete() {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.map.delete();
            oIndexMVRBTreeAbstract = this;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexInternal<T> lazySave() {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            this.map.lazySave();
            oIndexMVRBTreeAbstract = this;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    public ORecord<?> getRecord() {
        return ((OMVRBTreeProviderAbstract)this.map.getProvider()).getRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<Object, T>> iterator() {
        Iterator<Map.Entry<Object, T>> iterator;
        this.acquireExclusiveLock();
        try {
            iterator = this.map.entrySet().iterator();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Object> keys() {
        Set<Object> set;
        this.acquireExclusiveLock();
        try {
            set = this.map.keySet();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.map.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClusters() {
        Set<String> set;
        this.acquireSharedLock();
        try {
            set = Collections.unmodifiableSet(this.clustersToIndex);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexMVRBTreeAbstract<T> addCluster(String iClusterName) {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.add(iClusterName)) {
                this.updateConfiguration();
            }
            oIndexMVRBTreeAbstract = this;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexMVRBTreeAbstract<T> removeCluster(String iClusterName) {
        OIndexMVRBTreeAbstract oIndexMVRBTreeAbstract;
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.remove(iClusterName)) {
                this.updateConfiguration();
            }
            oIndexMVRBTreeAbstract = this;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMVRBTreeAbstract;
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unload() {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument updateConfiguration() {
        this.acquireExclusiveLock();
        try {
            this.configuration.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                this.configuration.field("type", this.type);
                this.configuration.field("name", this.name);
                if (this.indexDefinition != null) {
                    ODocument indexDefDocument = this.indexDefinition.toStream();
                    if (!indexDefDocument.hasOwners()) {
                        indexDefDocument.addOwner(this.configuration);
                    }
                    this.configuration.field("indexDefinition", indexDefDocument, OType.EMBEDDED);
                    this.configuration.field("indexDefinitionClass", this.indexDefinition.getClass().getName());
                } else {
                    this.configuration.removeField("indexDefinition");
                    this.configuration.removeField("indexDefinitionClass");
                }
                this.configuration.field(CONFIG_CLUSTERS, this.clustersToIndex, OType.EMBEDDEDSET);
                this.configuration.field(CONFIG_MAP_RID, ((OMVRBTreeProviderAbstract)this.map.getProvider()).getRecord().getIdentity());
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
                throw throwable;
            }
            this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(ODocument iDocument) {
        if (iDocument == null) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            this.map.setRunningTransaction(true);
            Boolean clearAll = (Boolean)iDocument.field("clear");
            if (clearAll != null && clearAll.booleanValue()) {
                this.clear();
            }
            Collection entries = (Collection)iDocument.field("entries");
            for (ODocument entry : entries) {
                String serializedKey = OStringSerializerHelper.decode((String)entry.field("k"));
                Object key = serializedKey.startsWith("[") ? new OCompositeKey((List)ORecordSerializerStringAbstract.fieldTypeFromStream(iDocument, OType.EMBEDDEDLIST, OStringSerializerHelper.decode(serializedKey))) : ORecordSerializerStringAbstract.getTypeValue(serializedKey);
                List operations = (List)entry.field("ops");
                if (operations == null) continue;
                for (ODocument op : operations) {
                    int operation = (Integer)op.rawField("o");
                    OIdentifiable value = (OIdentifiable)op.field("v", OType.LINK);
                    if (operation == OTransactionIndexChanges.OPERATION.PUT.ordinal()) {
                        this.put(key, value);
                        continue;
                    }
                    if (operation != OTransactionIndexChanges.OPERATION.REMOVE.ordinal()) continue;
                    if (key.equals("*")) {
                        this.remove(value);
                        continue;
                    }
                    if (value == null) {
                        this.remove(key);
                        continue;
                    }
                    this.remove(key, value);
                }
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.releaseExclusiveLock();
            this.map.setRunningTransaction(false);
            throw throwable;
        }
        this.releaseExclusiveLock();
        this.map.setRunningTransaction(false);
    }

    @Override
    public ODocument getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isAutomatic() {
        return this.indexDefinition != null && this.indexDefinition.getClassName() != null;
    }

    protected void installHooks(ODatabaseRecord iDatabase) {
        OProfiler.getInstance().registerHookValue("index." + this.name + ".items", new OProfiler.OProfilerHookValue(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() {
                String string;
                OIndexMVRBTreeAbstract.this.acquireSharedLock();
                try {
                    string = OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.size()) : "-";
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OIndexMVRBTreeAbstract.this.releaseSharedLock();
                    throw throwable;
                }
                OIndexMVRBTreeAbstract.this.releaseSharedLock();
                return string;
            }
        });
        OProfiler.getInstance().registerHookValue("index." + this.name + ".entryPointSize", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.getEntryPointSize()) : "-";
            }
        });
        OProfiler.getInstance().registerHookValue("index." + this.name + ".maxUpdateBeforeSave", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.getMaxUpdatesBeforeSave()) : "-";
            }
        });
        OProfiler.getInstance().registerHookValue("index." + this.name + ".optimizationThreshold", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OIndexMVRBTreeAbstract.this.map != null ? Integer.valueOf(OIndexMVRBTreeAbstract.this.map.getOptimizeThreshold()) : "-";
            }
        });
        Orient.instance().getMemoryWatchDog().addListener(this.watchDog);
        iDatabase.registerListener(this);
    }

    protected void uninstallHooks(ODatabaseRecord iDatabase) {
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".items");
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".entryPointSize");
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".maxUpdateBeforeSave");
        OProfiler.getInstance().unregisterHookValue("index." + this.name + ".optimizationThreshold");
        Orient.instance().getMemoryWatchDog().removeListener(this.watchDog);
        iDatabase.unregisterListener(this);
    }

    @Override
    public void onCreate(ODatabase iDatabase) {
    }

    @Override
    public void onDelete(ODatabase iDatabase) {
    }

    @Override
    public void onOpen(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBeforeTxBegin(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges(true);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    @Override
    public void onBeforeTxRollback(ODatabase iDatabase) {
    }

    @Override
    public boolean onCorruptionRepairDatabase(ODatabase iDatabase, String iReason, String iWhatWillbeFixed) {
        return iReason.equals("load");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxRollback(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.unload();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    @Override
    public void onBeforeTxCommit(ODatabase iDatabase) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterTxCommit(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.onAfterTxCommit();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose(ODatabase iDatabase) {
        this.acquireExclusiveLock();
        try {
            this.map.commitChanges();
            Orient.instance().getMemoryWatchDog().removeListener(this.watchDog);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimize(boolean iHardMode) {
        if (this.map == null) {
            return;
        }
        this.acquireExclusiveLock();
        try {
            OLogManager.instance().debug((Object)this, "Forcing " + (iHardMode ? "hard" : "soft") + " optimization of Index %s (%d items). Found %d entries in memory...", this.name, this.map.size(), this.map.getNumberOfNodesInCache());
            this.map.setOptimization(iHardMode ? 2 : 1);
            int freed = this.map.optimize(iHardMode);
            OLogManager.instance().debug((Object)this, "Completed! Freed %d entries and now %d entries reside in memory", freed, this.map.getNumberOfNodesInCache());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    protected void checkForKeyType(Object iKey) {
        if (this.indexDefinition == null) {
            OType type = OType.getTypeByClass(iKey.getClass());
            if (type == null) {
                return;
            }
            this.indexDefinition = new OSimpleKeyIndexDefinition(type);
            this.updateConfiguration();
        }
    }

    protected ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public OType[] getKeyTypes() {
        if (this.indexDefinition == null) {
            return null;
        }
        return this.indexDefinition.getTypes();
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexMVRBTreeAbstract that = (OIndexMVRBTreeAbstract)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

