/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareDictionary;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexManagerAbstract
extends ODocumentWrapperNoClass
implements OIndexManager,
OCloseable {
    public static final String CONFIG_INDEXES = "indexes";
    public static final String DICTIONARY_NAME = "dictionary";
    protected Map<String, OIndexInternal<?>> indexes = new ConcurrentHashMap();
    protected final Map<String, Map<OMultiKey, Set<OIndex<?>>>> classPropertyIndex = new HashMap();
    protected String defaultClusterName = "index";
    protected ReadWriteLock lock = new ReentrantReadWriteLock();

    public OIndexManagerAbstract(ODatabaseRecord iDatabase) {
        super(new ODocument());
    }

    protected abstract OIndex<?> getIndexInstance(OIndex<?> var1);

    protected void acquireSharedLock() {
        this.lock.readLock().lock();
    }

    protected void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() {
        this.lock.writeLock().lock();
    }

    protected void releaseExclusiveLock() {
        this.lock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexManagerAbstract load() {
        this.acquireExclusiveLock();
        try {
            if (this.getDatabase().getStorage().getConfiguration().indexMgrRecordId == null) {
                this.create();
            }
            this.indexes.clear();
            this.classPropertyIndex.clear();
            ((ORecordId)this.document.getIdentity()).fromString(this.getDatabase().getStorage().getConfiguration().indexMgrRecordId);
            super.reload("*:-1 index:0");
            OIndexManagerAbstract oIndexManagerAbstract = this;
            Object var3_2 = null;
            this.releaseExclusiveLock();
            return oIndexManagerAbstract;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        Object RET;
        this.acquireExclusiveLock();
        try {
            RET = super.reload();
            Object var3_2 = null;
            this.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        return RET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET extends ODocumentWrapper> RET save() {
        Object RET;
        this.acquireExclusiveLock();
        try {
            RET = super.save();
            Object var3_2 = null;
            this.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        return RET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() {
        this.acquireExclusiveLock();
        try {
            this.save("internal");
            this.getDatabase().getStorage().getConfiguration().indexMgrRecordId = this.document.getIdentity().toString();
            this.getDatabase().getStorage().getConfiguration().update();
            this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null);
            Object var2_1 = null;
            this.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
    }

    @Override
    public void flush() {
        for (OIndexInternal<?> idx : this.indexes.values()) {
            idx.flush();
        }
    }

    @Override
    public Collection<? extends OIndex<?>> getIndexes() {
        Collection<OIndexInternal<?>> rawResult = this.indexes.values();
        ArrayList result = new ArrayList(rawResult.size());
        for (OIndexInternal<?> index : rawResult) {
            result.add(this.preProcessBeforeReturn(index));
        }
        return result;
    }

    @Override
    public OIndex<?> getIndex(String iName) {
        OIndexInternal<?> index = this.indexes.get(iName.toLowerCase());
        if (index == null) {
            return null;
        }
        return this.preProcessBeforeReturn(index);
    }

    public boolean existsIndex(String iName) {
        return this.indexes.containsKey(iName.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultClusterName() {
        this.acquireSharedLock();
        try {
            String string = this.defaultClusterName;
            Object var3_2 = null;
            this.releaseSharedLock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultClusterName(String defaultClusterName) {
        this.acquireExclusiveLock();
        try {
            this.defaultClusterName = defaultClusterName;
            Object var3_2 = null;
            this.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODictionary<ORecordInternal<?>> getDictionary() {
        OIndex<OIdentifiable> idx;
        this.acquireExclusiveLock();
        try {
            idx = this.getIndex(DICTIONARY_NAME);
            if (idx == null) {
                idx = this.createIndex(DICTIONARY_NAME, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.STRING), null, null);
            }
            Object var3_2 = null;
            this.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        return new ODictionary(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument getConfiguration() {
        this.acquireSharedLock();
        try {
            ODocument oDocument = this.getDocument();
            Object var3_2 = null;
            this.releaseSharedLock();
            return oDocument;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
    }

    protected ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.flush();
            this.indexes.clear();
            this.classPropertyIndex.clear();
            Object var2_1 = null;
            this.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexManager setDirty() {
        this.acquireExclusiveLock();
        try {
            this.document.setDirty();
            OIndexManagerAbstract oIndexManagerAbstract = this;
            Object var3_2 = null;
            this.releaseExclusiveLock();
            return oIndexManagerAbstract;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
    }

    @Override
    public OIndex<?> getIndex(ORID iRID) {
        for (OIndex oIndex : this.indexes.values()) {
            if (!oIndex.getIdentity().equals(iRID)) continue;
            return this.getIndexInstance(oIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIndexInternal(OIndexInternal<?> index) {
        this.acquireExclusiveLock();
        try {
            OIndexDefinition indexDefinition;
            block9: {
                block8: {
                    this.indexes.put(index.getName().toLowerCase(), index);
                    indexDefinition = index.getDefinition();
                    if (indexDefinition == null) break block8;
                    if (indexDefinition.getClassName() != null) break block9;
                }
                Object var10_3 = null;
                this.releaseExclusiveLock();
                return;
            }
            Map<OMultiKey, Set<OIndex<?>>> propertyIndex = this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase());
            if (propertyIndex == null) {
                propertyIndex = new HashMap();
                this.classPropertyIndex.put(indexDefinition.getClassName().toLowerCase(), propertyIndex);
            }
            int paramCount = indexDefinition.getParamCount();
            for (int i = 1; i <= paramCount; ++i) {
                List<String> fields = indexDefinition.getFields().subList(0, i);
                OMultiKey multiKey = new OMultiKey(this.normalizeFieldNames(fields));
                Set<OIndex<?>> indexSet = propertyIndex.get(multiKey);
                if (indexSet == null) {
                    indexSet = new HashSet();
                }
                indexSet.add(index);
                propertyIndex.put(multiKey, indexSet);
            }
        }
        catch (Throwable throwable) {
            Object var10_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        Object var10_4 = null;
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, Collection<String> fields) {
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex;
        OMultiKey multiKey;
        block4: {
            this.acquireSharedLock();
            fields = this.normalizeFieldNames(fields);
            multiKey = new OMultiKey(fields);
            propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex != null && propertyIndex.containsKey(multiKey)) break block4;
            Set<OIndex<?>> set = Collections.emptySet();
            Object var10_7 = null;
            this.releaseSharedLock();
            return set;
        }
        try {
            Set<OIndex<?>> rawResult = propertyIndex.get(multiKey);
            HashSet transactionalResult = new HashSet(rawResult.size());
            for (OIndex<?> index : rawResult) {
                transactionalResult.add(this.preProcessBeforeReturn((OIndexInternal)index));
            }
            HashSet hashSet = transactionalResult;
            Object var10_8 = null;
            this.releaseSharedLock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.releaseSharedLock();
            throw throwable;
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String className, String ... fields) {
        return this.getClassInvolvedIndexes(className, Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areIndexed(String className, Collection<String> fields) {
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex;
        OMultiKey multiKey;
        block3: {
            this.acquireSharedLock();
            try {
                fields = this.normalizeFieldNames(fields);
                multiKey = new OMultiKey(fields);
                propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
                if (propertyIndex != null) break block3;
                boolean bl = false;
                Object var7_7 = null;
                this.releaseSharedLock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.releaseSharedLock();
                throw throwable;
            }
        }
        boolean bl = propertyIndex.containsKey(multiKey) && !propertyIndex.get(multiKey).isEmpty();
        Object var7_8 = null;
        this.releaseSharedLock();
        return bl;
    }

    @Override
    public boolean areIndexed(String className, String ... fields) {
        return this.areIndexed(className, Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getClassIndexes(String className) {
        Map<OMultiKey, Set<OIndex<?>>> propertyIndex;
        HashSet result;
        block5: {
            this.acquireSharedLock();
            result = new HashSet();
            propertyIndex = this.classPropertyIndex.get(className.toLowerCase());
            if (propertyIndex != null) break block5;
            Set<OIndex<?>> set = Collections.emptySet();
            Object var9_6 = null;
            this.releaseSharedLock();
            return set;
        }
        try {
            for (Set<OIndex<?>> propertyIndexes : propertyIndex.values()) {
                for (OIndex<?> index : propertyIndexes) {
                    result.add(this.preProcessBeforeReturn((OIndexInternal)index));
                }
            }
            HashSet hashSet = result;
            Object var9_7 = null;
            this.releaseSharedLock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.releaseSharedLock();
            throw throwable;
        }
    }

    @Override
    public OIndex<?> getClassIndex(String className, String indexName) {
        className = className.toLowerCase();
        OIndexInternal<?> index = this.indexes.get(indexName = indexName.toLowerCase());
        if (index != null && index.getDefinition() != null && index.getDefinition().getClassName() != null && className.equals(index.getDefinition().getClassName().toLowerCase())) {
            return this.preProcessBeforeReturn(index);
        }
        return null;
    }

    protected List<String> normalizeFieldNames(Collection<String> fieldNames) {
        ArrayList<String> result = new ArrayList<String>(fieldNames.size());
        for (String fieldName : fieldNames) {
            result.add(fieldName.toLowerCase());
        }
        return result;
    }

    protected OIndex<?> preProcessBeforeReturn(OIndexInternal<?> index) {
        this.getDatabase().registerListener(index);
        if (index instanceof OIndexMultiValues) {
            return new OIndexTxAwareMultiValue(this.getDatabase(), this.getIndexInstance(index));
        }
        if (index instanceof OIndexDictionary) {
            return new OIndexTxAwareDictionary(this.getDatabase(), this.getIndexInstance(index));
        }
        if (index instanceof OIndexOneValue) {
            return new OIndexTxAwareOneValue(this.getDatabase(), this.getIndexInstance(index));
        }
        return index;
    }
}

