/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexMultiValues
extends OIndexMVRBTreeAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String iType) {
        super(iType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object iKey) {
        OMVRBTreeRIDSet values;
        block3: {
            Set<OIdentifiable> set;
            this.acquireExclusiveLock();
            try {
                values = (OMVRBTreeRIDSet)this.map.get(iKey);
                if (values != null) break block3;
                set = Collections.emptySet();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return set;
        }
        OMVRBTreeRIDSet oMVRBTreeRIDSet = values;
        Object var5_6 = null;
        this.releaseExclusiveLock();
        return oMVRBTreeRIDSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexMultiValues put(Object iKey, OIdentifiable iSingleValue) {
        OIndexMultiValues oIndexMultiValues;
        this.acquireExclusiveLock();
        try {
            this.checkForKeyType(iKey);
            Set values = (Set)this.map.get(iKey);
            if (values == null) {
                values = new OMVRBTreeRIDSet().setAutoConvert(false);
            }
            if (!iSingleValue.getIdentity().isValid()) {
                ((ORecord)iSingleValue).save();
            }
            values.add(iSingleValue.getIdentity());
            this.map.put(iKey, values);
            oIndexMultiValues = this;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMultiValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object iKey, OIdentifiable iValue) {
        block5: {
            boolean bl;
            this.acquireExclusiveLock();
            try {
                Object recs = this.get(iKey);
                if (!recs.remove(iValue)) break block5;
                if (recs.isEmpty()) {
                    this.map.remove(iKey);
                } else {
                    this.map.put(iKey, recs);
                }
                bl = true;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return bl;
        }
        boolean bl = false;
        Object var6_7 = null;
        this.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                this.remove(entries.getKey(), iRecord);
                ++tot;
            }
            n = tot;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                ++tot;
            }
            n = tot;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    public OIndexMultiValues create(String iName, OIndexDefinition indexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        return (OIndexMultiValues)super.create(iName, indexDefinition, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, OStreamSerializerListRID.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        block7: {
            Set<OIdentifiable> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = iFromInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var17_9 = null;
                        break block6;
                    }
                    int firstEntryIndex = this.map.getPageIndex();
                    OMVRBTreeEntry lastEntry = iToInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
                    int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
                    OMVRBTreeEntry entry = firstEntry;
                    this.map.setPageIndex(firstEntryIndex);
                    HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
                    while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxValuesToFetch > -1 && maxValuesToFetch == result.size()) {
                                HashSet<OIdentifiable> hashSet2 = result;
                                Object var17_10 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            result.add(value);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var17_12 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var17_11 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        block7: {
            Set<OIdentifiable> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var12_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = firstEntry;
                    HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
                    while (entry != null) {
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                                HashSet<OIdentifiable> hashSet2 = result;
                                Object var12_8 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            result.add(value);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var12_9 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        block7: {
            Set<OIdentifiable> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
                    if (lastEntry == null) {
                        set = Collections.emptySet();
                        Object var12_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = lastEntry;
                    HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
                    while (entry != null) {
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                                HashSet<OIdentifiable> hashSet2 = result;
                                Object var12_8 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            result.add(value);
                        }
                        entry = OMVRBTree.previous(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var12_9 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        this.acquireExclusiveLock();
        try {
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.map.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxValuesToFetch > -1 && maxValuesToFetch == result.size()) {
                        HashSet<OIdentifiable> hashSet2 = result;
                        Object var12_11 = null;
                        this.releaseExclusiveLock();
                        return hashSet2;
                    }
                    result.add(value);
                }
            }
            hashSet = result;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        Object var12_12 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        HashSet<ODocument> hashSet;
        block7: {
            Set<ODocument> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var13_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = firstEntry;
                    HashSet<ODocument> result = new HashSet<ODocument>();
                    while (entry != null) {
                        Object key = entry.getKey();
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                                HashSet<ODocument> hashSet2 = result;
                                Object var13_8 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            ODocument document = new ODocument();
                            document.field("key", key);
                            document.field("rid", value.getIdentity());
                            document.unsetDirty();
                            result.add(document);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var13_9 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        block7: {
            Set<ODocument> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
                    if (lastEntry == null) {
                        set = Collections.emptySet();
                        Object var13_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = lastEntry;
                    ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
                    while (entry != null) {
                        Object key = entry.getKey();
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                                ODocumentFieldsHashSet oDocumentFieldsHashSet2 = result;
                                Object var13_8 = null;
                                this.releaseExclusiveLock();
                                return oDocumentFieldsHashSet2;
                            }
                            ODocument document = new ODocument();
                            document.field("key", key);
                            document.field("rid", value.getIdentity());
                            document.unsetDirty();
                            result.add(document);
                        }
                        entry = OMVRBTree.previous(entry);
                    }
                    oDocumentFieldsHashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var13_9 = null;
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        block7: {
            Set<ODocument> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = iInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var17_8 = null;
                        break block6;
                    }
                    int firstEntryIndex = this.map.getPageIndex();
                    OMVRBTreeEntry lastEntry = iInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
                    int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
                    OMVRBTreeEntry entry = firstEntry;
                    this.map.setPageIndex(firstEntryIndex);
                    ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
                    while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                        Object key = entry.getKey();
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                                ODocumentFieldsHashSet oDocumentFieldsHashSet2 = result;
                                Object var17_9 = null;
                                this.releaseExclusiveLock();
                                return oDocumentFieldsHashSet2;
                            }
                            ODocument document = new ODocument();
                            document.field("key", key);
                            document.field("rid", value.getIdentity());
                            document.unsetDirty();
                            result.add(document);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    oDocumentFieldsHashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var17_11 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var17_10 = null;
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        this.acquireExclusiveLock();
        try {
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.map.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                        ODocumentFieldsHashSet oDocumentFieldsHashSet2 = result;
                        Object var12_11 = null;
                        this.releaseExclusiveLock();
                        return oDocumentFieldsHashSet2;
                    }
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            oDocumentFieldsHashSet = result;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        Object var12_12 = null;
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }
}

