/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORuntimeKeyIndexDefinition<T>
extends ODocumentWrapperNoClass
implements OIndexDefinition {
    private OBinarySerializer<T> serializer;

    public ORuntimeKeyIndexDefinition(byte iId) {
        super(new ODocument());
        this.serializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(iId);
        if (this.serializer == null) {
            throw new OConfigurationException("Runtime index definition cannot find binary serializer with id=" + iId + ". Assure to plug custom serializer into the server.");
        }
    }

    public ORuntimeKeyIndexDefinition() {
    }

    @Override
    public List<String> getFields() {
        return Collections.emptyList();
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public Comparable<?> createValue(List<?> params) {
        return (Comparable)params.get(0);
    }

    @Override
    public Comparable<?> createValue(Object ... params) {
        return this.createValue((List)Arrays.asList(params));
    }

    @Override
    public int getParamCount() {
        return 1;
    }

    @Override
    public OType[] getTypes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        ODocument oDocument;
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("keySerializerId", this.serializer.getId());
            oDocument = this.document;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        return oDocument;
    }

    @Override
    protected void fromStream() {
        byte keySerializerId = ((Number)this.document.field("keySerializerId")).byteValue();
        this.serializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(keySerializerId);
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        throw new OIndexException("This method is not supported in given index definition.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ORuntimeKeyIndexDefinition that = (ORuntimeKeyIndexDefinition)o;
        return this.serializer.equals(that.serializer);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.serializer.getId();
        return result;
    }

    @Override
    public String toString() {
        return "ORuntimeKeyIndexDefinition{serializer=" + this.serializer.getId() + '}';
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType) {
        StringBuilder ddl = new StringBuilder("create index ");
        ddl.append(indexName).append(" ").append(indexType).append(" ");
        ddl.append("runtime ").append(this.serializer.getId());
        return ddl.toString();
    }

    public OBinarySerializer<T> getSerializer() {
        return this.serializer;
    }
}

