/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OIterationException;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIdentifiableIterator<REC extends OIdentifiable>
implements Iterator<REC>,
Iterable<REC> {
    protected final ODatabaseRecord database;
    protected final ODatabaseRecordAbstract lowLevelDatabase;
    protected boolean liveUpdated = false;
    protected long limit = -1L;
    protected long browsedRecords = 0L;
    protected String fetchPlan;
    protected ORecordInternal<?> reusedRecord = null;
    protected Boolean directionForward;
    protected final ORecordId current = new ORecordId();
    protected long firstClusterPosition;
    protected long lastClusterPosition;
    protected long totalAvailableRecords;
    protected List<ORecordOperation> txEntries;
    protected int currentTxEntryPosition = -1;

    public OIdentifiableIterator(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase) {
        this.database = iDatabase;
        this.lowLevelDatabase = iLowLevelDatabase;
        this.current.clusterPosition = -1L;
    }

    public abstract boolean hasPrevious();

    public abstract OIdentifiable previous();

    public abstract OIdentifiableIterator<REC> begin();

    public abstract OIdentifiableIterator<REC> last();

    public ORecordInternal<?> current() {
        return this.readCurrentRecord(this.getRecord(), 0);
    }

    protected ORecordInternal<?> getTransactionEntry() {
        long physicalRecordTobrowse;
        long l = physicalRecordTobrowse = this.current.clusterPosition > -2L && this.lastClusterPosition > -1L ? this.lastClusterPosition - this.current.clusterPosition : 0L;
        if (physicalRecordTobrowse == 0L && this.txEntries != null) {
            ++this.currentTxEntryPosition;
            if (this.currentTxEntryPosition >= this.txEntries.size()) {
                throw new NoSuchElementException();
            }
            return this.txEntries.get(this.currentTxEntryPosition).getRecord();
        }
        return null;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean isReuseSameRecord() {
        return this.reusedRecord != null;
    }

    public OIdentifiableIterator<REC> setReuseSameRecord(boolean reuseSameRecord) {
        this.reusedRecord = reuseSameRecord ? this.database.newInstance() : null;
        return this;
    }

    protected ORecordInternal<?> getRecord() {
        ORecordInternal<?> record;
        if (this.reusedRecord != null) {
            record = this.reusedRecord;
            record.reset();
        } else {
            record = null;
        }
        return record;
    }

    @Override
    public Iterator<REC> iterator() {
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public OIdentifiableIterator<REC> setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public boolean isLiveUpdated() {
        return this.liveUpdated;
    }

    public OIdentifiableIterator<REC> setLiveUpdated(boolean liveUpdated) {
        this.liveUpdated = liveUpdated;
        return this;
    }

    protected void checkDirection(boolean iForward) {
        if (this.directionForward == null) {
            this.directionForward = iForward;
        } else if (this.directionForward != iForward) {
            throw new OIterationException("Iterator cannot change direction while browsing");
        }
    }

    protected ORecordInternal<?> readCurrentRecord(ORecordInternal<?> iRecord, int iMovement) {
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return null;
        }
        this.current.clusterPosition += (long)iMovement;
        if (iRecord != null) {
            iRecord.setIdentity(this.current);
            iRecord = this.lowLevelDatabase.load((ORecordInternal<?>)iRecord, this.fetchPlan);
        } else {
            iRecord = this.lowLevelDatabase.load(this.current, this.fetchPlan);
        }
        if (iRecord != null) {
            ++this.browsedRecords;
        }
        return iRecord;
    }
}

