/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSecurityShared
extends OSharedResourceAdaptive
implements OSecurity,
OCloseable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser authenticate(String iUserName, String iUserPassword) {
        OUser oUser;
        this.acquireExclusiveLock();
        try {
            String dbName = this.getDatabase().getName();
            OUser user = this.getUser(iUserName);
            if (user == null) {
                throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
            }
            if (user.getAccountStatus() != OUser.STATUSES.ACTIVE) {
                throw new OSecurityAccessException(dbName, "User '" + iUserName + "' is not active");
            }
            if (this.getDatabase().getStorage() instanceof OStorageEmbedded && !user.checkPassword(iUserPassword)) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                throw new OSecurityAccessException(dbName, "User or password not valid for database: '" + dbName + "'");
            }
            oUser = user;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser getUser(String iUserName) {
        block3: {
            OUser oUser;
            this.acquireExclusiveLock();
            try {
                List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser where name = '" + iUserName + "' limit 1").setFetchPlan("*:-1")).execute(new Object[0]);
                if (result == null || result.isEmpty()) break block3;
                oUser = new OUser((ODocument)result.get(0));
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oUser;
        }
        OUser oUser = null;
        Object var5_6 = null;
        this.releaseExclusiveLock();
        return oUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser createUser(String iUserName, String iUserPassword, String[] iRoles) {
        OUser oUser;
        this.acquireExclusiveLock();
        try {
            OUser user = new OUser(iUserName, iUserPassword);
            if (iRoles != null) {
                for (String r : iRoles) {
                    user.addRole(r);
                }
            }
            oUser = user.save();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropUser(String iUserName) {
        boolean bl;
        this.acquireExclusiveLock();
        try {
            Number removed = (Number)this.getDatabase().command(new OSQLSynchQuery("delete from OUser where name = '" + iUserName + "'")).execute(new Object[0]);
            bl = removed != null && removed.intValue() > 0;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORole getRole(String iRoleName) {
        block3: {
            ORole oRole;
            this.acquireExclusiveLock();
            try {
                List result = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole where name = '" + iRoleName + "' limit 1").setFetchPlan("*:-1")).execute(new Object[0]);
                if (result == null || result.isEmpty()) break block3;
                oRole = new ORole((ODocument)result.get(0));
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oRole;
        }
        ORole oRole = null;
        Object var5_6 = null;
        this.releaseExclusiveLock();
        return oRole;
    }

    @Override
    public ORole createRole(String iRoleName, ORole.ALLOW_MODES iAllowMode) {
        return this.createRole(iRoleName, null, iAllowMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORole createRole(String iRoleName, ORole iParent, ORole.ALLOW_MODES iAllowMode) {
        ORole oRole;
        this.acquireExclusiveLock();
        try {
            ORole role = new ORole(iRoleName, iParent, iAllowMode);
            oRole = role.save();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropRole(String iRoleName) {
        boolean bl;
        this.acquireExclusiveLock();
        try {
            Number removed = (Number)this.getDatabase().command(new OSQLSynchQuery("delete from ORole where name = '" + iRoleName + "'")).execute(new Object[0]);
            bl = removed != null && removed.intValue() > 0;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ODocument> getAllUsers() {
        List list;
        this.acquireExclusiveLock();
        try {
            list = (List)this.getDatabase().command(new OSQLSynchQuery("select from OUser")).execute(new Object[0]);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ODocument> getAllRoles() {
        List list;
        this.acquireExclusiveLock();
        try {
            list = (List)this.getDatabase().command(new OSQLSynchQuery("select from ORole")).execute(new Object[0]);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser create() {
        OUser oUser;
        this.acquireExclusiveLock();
        try {
            if (!this.getDatabase().getMetadata().getSchema().getClasses().isEmpty()) {
                throw new OSecurityException("Default users and roles already installed");
            }
            OUser adminUser = this.createMetadata();
            ORole readerRole = this.createRole("reader", ORole.ALLOW_MODES.DENY_ALL_BUT);
            readerRole.addRule("database", ORole.PERMISSION_READ);
            readerRole.addRule("database.schema", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.internal", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.orole", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.ouser", ORole.PERMISSION_READ);
            readerRole.addRule("database.class.*", ORole.PERMISSION_READ);
            readerRole.addRule("database.cluster.*", ORole.PERMISSION_READ);
            readerRole.addRule("database.command", ORole.PERMISSION_READ);
            readerRole.addRule("database.hook.record", ORole.PERMISSION_READ);
            readerRole.save();
            this.createUser("reader", "reader", new String[]{readerRole.getName()});
            ORole writerRole = this.createRole("writer", ORole.ALLOW_MODES.DENY_ALL_BUT);
            writerRole.addRule("database", ORole.PERMISSION_READ);
            writerRole.addRule("database.schema", ORole.PERMISSION_READ + ORole.PERMISSION_CREATE + ORole.PERMISSION_UPDATE);
            writerRole.addRule("database.cluster.internal", ORole.PERMISSION_READ);
            writerRole.addRule("database.cluster.orole", ORole.PERMISSION_READ);
            writerRole.addRule("database.cluster.ouser", ORole.PERMISSION_READ);
            writerRole.addRule("database.class.*", ORole.PERMISSION_ALL);
            writerRole.addRule("database.cluster.*", ORole.PERMISSION_ALL);
            writerRole.addRule("database.command", ORole.PERMISSION_ALL);
            writerRole.addRule("database.hook.record", ORole.PERMISSION_ALL);
            writerRole.save();
            this.createUser("writer", "writer", new String[]{writerRole.getName()});
            oUser = adminUser;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OUser repair() {
        OUser oUser;
        this.acquireExclusiveLock();
        try {
            oUser = this.createMetadata();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oUser;
    }

    protected OUser createMetadata() {
        OUser adminUser;
        ORole adminRole;
        OClass userClass;
        ODatabaseRecord database = this.getDatabase();
        OClass roleClass = database.getMetadata().getSchema().getClass("ORole");
        if (roleClass == null) {
            roleClass = database.getMetadata().getSchema().createClass("ORole");
        }
        if (!roleClass.existsProperty("name")) {
            roleClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if (!roleClass.existsProperty("mode")) {
            roleClass.createProperty("mode", OType.BYTE);
        }
        if (!roleClass.existsProperty("rules")) {
            roleClass.createProperty("rules", OType.EMBEDDEDMAP, OType.BYTE);
        }
        if ((userClass = database.getMetadata().getSchema().getClass("OUser")) == null) {
            userClass = database.getMetadata().getSchema().createClass("OUser");
        }
        if (!userClass.existsProperty("name")) {
            userClass.createProperty("name", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("password")) {
            userClass.createProperty("password", OType.STRING).setMandatory(true).setNotNull(true);
        }
        if (!userClass.existsProperty("roles")) {
            userClass.createProperty("roles", OType.LINKSET, roleClass);
        }
        if ((adminRole = this.getRole("admin")) == null) {
            adminRole = this.createRole("admin", ORole.ALLOW_MODES.ALLOW_ALL_BUT);
        }
        if ((adminUser = this.getUser("admin")) == null) {
            adminUser = this.createUser("admin", "admin", new String[]{adminRole.getName()});
        }
        return adminUser;
    }

    @Override
    public void close() {
    }

    @Override
    public void load() {
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

