/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordSchemaAwareAbstract<T>
extends ORecordAbstract<T>
implements ORecordSchemaAware<T> {
    protected OClass _clazz;

    @Override
    public void validate() throws OValidationException {
        if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && !this.getDatabase().isValidationEnabled()) {
            return;
        }
        this.checkForLoading();
        this.checkForFields();
        if (this._clazz != null) {
            if (this._clazz.isStrictMode()) {
                for (String f : this.fieldNames()) {
                    if (this._clazz.getProperty(f) != null) continue;
                    throw new OValidationException("Found additional field '" + f + "'. It cannot be added because the schema class '" + this._clazz.getName() + "' is defined as STRICT");
                }
            }
            for (OProperty p : this._clazz.properties()) {
                ORecordSchemaAwareAbstract.validateField(this, p);
            }
        }
    }

    @Override
    public OClass getSchemaClass() {
        if (this._clazz == null) {
            this.checkForLoading();
            this.checkForFields();
        }
        return this._clazz;
    }

    @Override
    public String getClassName() {
        this.checkForLoading();
        this.checkForFields();
        return this._clazz != null ? this._clazz.getName() : null;
    }

    @Override
    public void setClassName(String iClassName) {
        if (iClassName == null) {
            this._clazz = null;
            return;
        }
        this.setClass(this.getDatabase().getMetadata().getSchema().getOrCreateClass(iClassName));
    }

    @Override
    public void setClassNameIfExists(String iClassName) {
        if (iClassName == null) {
            this._clazz = null;
            return;
        }
        this.setClass(this.getDatabase().getMetadata().getSchema().getClass(iClassName));
    }

    @Override
    public ORecordSchemaAwareAbstract<T> reset() {
        super.reset();
        this._clazz = null;
        return this;
    }

    @Override
    public byte[] toStream() {
        return this.toStream(false);
    }

    public byte[] toStream(boolean iOnlyDelta) {
        if (this._source == null) {
            this._source = this._recordFormat.toStream(this, iOnlyDelta);
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void checkForFields() {
        if (this._status == ORecordElement.STATUS.LOADED && this.fields() == 0) {
            this.deserializeFields();
        }
    }

    public void deserializeFields() {
        if (this._source == null) {
            return;
        }
        this._status = ORecordElement.STATUS.UNMARSHALLING;
        this._recordFormat.fromStream(this._source, this);
        this._status = ORecordElement.STATUS.LOADED;
    }

    protected void setClass(OClass iClass) {
        this._clazz = iClass;
    }

    protected void checkFieldAccess(int iIndex) {
        if (iIndex < 0 || iIndex >= this.fields()) {
            throw new IndexOutOfBoundsException("Index " + iIndex + " is outside the range allowed: 0-" + this.fields());
        }
    }

    public static void validateField(ORecordSchemaAwareAbstract<?> iRecord, OProperty p) throws OValidationException {
        if (p.isMandatory() && !iRecord.containsField(p.getName())) {
            throw new OValidationException("The field '" + p.getName() + "' is mandatory");
        }
        Object fieldValue = iRecord instanceof ODocument ? ((ODocument)iRecord).rawField(p.getName()) : iRecord.field(p.getName());
        if (p.isNotNull() && fieldValue == null) {
            throw new OValidationException("The field '" + p.getName() + "' cannot be null");
        }
        if (fieldValue != null && p.getRegexp() != null && !fieldValue.toString().matches(p.getRegexp())) {
            throw new OValidationException("The field '" + p.getName() + "' does not match the regular expression '" + p.getRegexp() + "'. Field value is: " + fieldValue);
        }
        OType type = p.getType();
        if (fieldValue != null && type != null) {
            switch (type) {
                case LINK: {
                    Object linkedRecord;
                    if (fieldValue instanceof OIdentifiable) {
                        linkedRecord = ((OIdentifiable)fieldValue).getRecord();
                    } else if (fieldValue instanceof String) {
                        linkedRecord = new ORecordId((String)fieldValue).getRecord();
                    } else {
                        throw new OValidationException("The field '" + p.getName() + "' has been declared as LINK but the value is not a record or a record-id");
                    }
                    if (linkedRecord == null || p.getLinkedClass() == null) break;
                    if (!(linkedRecord instanceof ODocument)) {
                        throw new OValidationException("The field '" + p.getName() + "' has been declared as LINK of type '" + p.getLinkedClass() + "' but the value is the record " + linkedRecord.getIdentity() + " that is not a document");
                    }
                    if (((ODocument)linkedRecord).getSchemaClass() == null || p.getLinkedClass().isSuperClassOf(((ODocument)linkedRecord).getSchemaClass())) break;
                    throw new OValidationException("The field '" + p.getName() + "' has been declared as LINK of type '" + p.getLinkedClass().getName() + "' but the value is the document " + linkedRecord.getIdentity() + " of class '" + ((ODocument)linkedRecord).getSchemaClass() + "'");
                }
            }
        }
        if (p.getMin() != null) {
            String min = p.getMin();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains fewer characters than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains fewer bytes than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) < Long.parseLong(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) < Float.parseFloat(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) < Double.parseDouble(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is less than " + min);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the date " + fieldValue + " which precedes the first acceptable date (" + min + ")");
                    }
                }
                catch (ParseException e) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the datetime " + fieldValue + " which precedes the first acceptable datetime (" + min + ")");
                    }
                }
                catch (ParseException e) {}
            } else if ((p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET)) && fieldValue != null && ((Collection)fieldValue).size() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains fewer items than " + min + " requested");
            }
        }
        if (p.getMax() != null) {
            String max = p.getMax();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains more characters than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains more bytes than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) > Long.parseLong(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) > Float.parseFloat(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) > Double.parseDouble(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is greater than " + max);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the date " + fieldValue + " which is after the last acceptable date (" + max + ")");
                    }
                }
                catch (ParseException e) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the datetime " + fieldValue + " which is after the last acceptable datetime (" + max + ")");
                    }
                }
                catch (ParseException e) {}
            } else if ((p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET)) && fieldValue != null && ((Collection)fieldValue).size() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains more items than " + max + " requested");
            }
        }
    }
}

