/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODetachable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordSchemaAwareAbstract;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODocument
extends ORecordSchemaAwareAbstract<Object>
implements Iterable<Map.Entry<String, Object>>,
ODetachable {
    public static final byte RECORD_TYPE = 100;
    protected Map<String, Object> _fieldValues;
    protected Map<String, Object> _fieldOriginalValues;
    protected Map<String, OType> _fieldTypes;
    protected Map<String, OSimpleMultiValueChangeListener<String, Object>> _fieldChangeListeners;
    protected Map<String, OMultiValueChangeTimeLine<String, Object>> _fieldCollectionChangeTimeLines;
    protected boolean _trackingChanges = true;
    protected boolean _ordered = true;
    protected boolean _lazyLoad = true;
    protected List<WeakReference<ORecordElement>> _owners = null;
    protected static final String[] EMPTY_STRINGS = new String[0];

    public ODocument() {
        this.setup();
    }

    public ODocument(byte[] iSource) {
        this._source = iSource;
        this.setup();
    }

    @Deprecated
    public ODocument(ODatabaseRecord iDatabase) {
        this();
    }

    @Deprecated
    public ODocument(ODatabaseRecord iDatabase, ORID iRID) {
        this(iRID);
    }

    public ODocument(ORID iRID) {
        this.setup();
        this._recordId = (ORecordId)iRID;
        this._status = ORecordElement.STATUS.NOT_LOADED;
        this._dirty = false;
    }

    @Deprecated
    public ODocument(ODatabaseRecord iDatabase, String iClassName, ORID iRID) {
        this(iClassName, iRID);
    }

    public ODocument(String iClassName, ORID iRID) {
        this(iClassName);
        this._recordId = (ORecordId)iRID;
        this._dirty = false;
        this._status = ORecordElement.STATUS.NOT_LOADED;
    }

    @Deprecated
    public ODocument(ODatabaseRecord iDatabase, String iClassName) {
        this(iClassName);
    }

    public ODocument(String iClassName) {
        this.setClassName(iClassName);
        this.setup();
    }

    public ODocument(OClass iClass) {
        this.setup();
        this._clazz = iClass;
    }

    public ODocument(Object[] iFields) {
        this.setup();
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
    }

    public ODocument(Map<? extends Object, Object> iFieldMap) {
        this.setup();
        if (iFieldMap != null && !iFieldMap.isEmpty()) {
            for (Map.Entry<? extends Object, Object> entry : iFieldMap.entrySet()) {
                this.field(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public ODocument(String iFieldName, Object iFieldValue, Object ... iFields) {
        this(iFields);
        this.field(iFieldName, iFieldValue);
    }

    @Override
    public ODocument copy() {
        return this.copy((ODocument)this.copyTo(new ODocument()));
    }

    public ODocument copy(ODocument iDestination) {
        this.checkForFields();
        iDestination._ordered = this._ordered;
        iDestination._clazz = this._clazz;
        iDestination._trackingChanges = this._trackingChanges;
        if (this._owners != null) {
            iDestination._owners = new ArrayList<WeakReference<ORecordElement>>(this._owners);
        }
        if (this._fieldValues != null) {
            iDestination._fieldValues = this._fieldValues instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
            for (Map.Entry<String, Object> entry : this._fieldValues.entrySet()) {
                ODocumentHelper.copyFieldValue(iDestination, entry);
            }
        }
        if (this._fieldTypes != null) {
            iDestination._fieldTypes = new HashMap<String, OType>(this._fieldTypes);
        }
        iDestination._fieldChangeListeners = null;
        iDestination._fieldCollectionChangeTimeLines = null;
        iDestination._fieldOriginalValues = null;
        iDestination.addAllMultiValueChangeListeners();
        iDestination._dirty = this._dirty;
        return iDestination;
    }

    @Override
    public ODocument flatCopy() {
        if (this.isDirty()) {
            throw new IllegalStateException("Cannot execute a flat copy of a dirty record");
        }
        ODocument cloned = new ODocument();
        cloned.fill(this._recordId, this._version, this._source, false);
        return cloned;
    }

    public ORecord<?> placeholder() {
        ODocument cloned = new ODocument();
        cloned._source = null;
        cloned._recordId = this._recordId.copy();
        cloned._status = ORecordElement.STATUS.NOT_LOADED;
        cloned._dirty = false;
        return cloned;
    }

    @Override
    public boolean detach() {
        boolean fullyDetached = true;
        if (this._fieldValues != null) {
            for (Map.Entry<String, Object> entry : this._fieldValues.entrySet()) {
                Object fieldValue = entry.getValue();
                if (fieldValue instanceof ORecord) {
                    if (((ORecord)fieldValue).getIdentity().isNew()) {
                        fullyDetached = false;
                    } else {
                        this._fieldValues.put(entry.getKey(), ((ORecord)fieldValue).getIdentity());
                    }
                }
                if (!(fieldValue instanceof ODetachable) || ((ODetachable)fieldValue).detach()) continue;
                fullyDetached = false;
            }
        }
        return fullyDetached;
    }

    public ODocument load(String iFetchPlan) {
        return this.load(iFetchPlan, false);
    }

    public ODocument load(String iFetchPlan, boolean iIgnoreCache) {
        Object result = null;
        try {
            result = this.getDatabase().load(this, iFetchPlan, iIgnoreCache);
        }
        catch (Exception e) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found", e);
        }
        if (result == null) {
            throw new ORecordNotFoundException("The record with id '" + this.getIdentity() + "' was not found");
        }
        return result;
    }

    public ODocument reload(String iFetchPlan, boolean iIgnoreCache) {
        super.reload(iFetchPlan, iIgnoreCache);
        if (!this._lazyLoad) {
            this.checkForFields();
            this.checkForLoading();
        }
        return this;
    }

    public boolean hasSameContentOf(ODocument iOther) {
        return ODocumentHelper.hasSameContentOf(this, this.getDatabase(), iOther, this.getDatabase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        boolean saveDirtyStatus = this._dirty;
        StringBuilder buffer = new StringBuilder();
        try {
            this.checkForFields();
            if (this._clazz != null) {
                buffer.append(this._clazz.getStreamableName());
            }
            if (this._recordId != null && this._recordId.isValid()) {
                buffer.append(this._recordId);
            }
            boolean first = true;
            for (Map.Entry<String, Object> f : this._fieldValues.entrySet()) {
                buffer.append(first ? (char)'{' : ',');
                buffer.append(f.getKey());
                buffer.append(':');
                if (f.getValue() instanceof Collection) {
                    buffer.append('[');
                    buffer.append(((Collection)f.getValue()).size());
                    buffer.append(']');
                } else if (f.getValue() instanceof ORecord) {
                    ORecord record = (ORecord)f.getValue();
                    if (record.getIdentity().isValid()) {
                        record.getIdentity().toString(buffer);
                    } else {
                        buffer.append(record.toString());
                    }
                } else {
                    buffer.append(f.getValue());
                }
                if (!first) continue;
                first = false;
            }
            if (!first) {
                buffer.append('}');
            }
            if (this._recordId != null && this._recordId.isValid()) {
                buffer.append(" v");
                buffer.append(this._version);
            }
        }
        finally {
            this._dirty = saveDirtyStatus;
        }
        return buffer.toString();
    }

    public void fromString(String iValue) {
        this._dirty = true;
        this._source = OBinaryProtocol.string2bytes(iValue);
        this.removeAllCollectionChangeListeners();
        this._fieldCollectionChangeTimeLines = null;
        this._fieldOriginalValues = null;
        this._fieldTypes = null;
        this._fieldValues = null;
    }

    @Override
    public String[] fieldNames() {
        this.checkForLoading();
        this.checkForFields();
        if (this._fieldValues == null || this._fieldValues.size() == 0) {
            return EMPTY_STRINGS;
        }
        return this._fieldValues.keySet().toArray(new String[this._fieldValues.keySet().size()]);
    }

    @Override
    public Object[] fieldValues() {
        this.checkForLoading();
        this.checkForFields();
        return this._fieldValues.values().toArray(new Object[this._fieldValues.values().size()]);
    }

    public <RET> RET rawField(String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        this.checkForLoading();
        this.checkForFields();
        if (this._fieldValues.size() == 0) {
            return null;
        }
        if (iFieldName.charAt(0) != '@' && OStringSerializerHelper.indexOf(iFieldName, 0, '.', '[') == -1) {
            return (RET)this._fieldValues.get(iFieldName);
        }
        return ODocumentHelper.getFieldValue(this, iFieldName);
    }

    @Override
    public <RET> RET field(String iFieldName) {
        Object value = this.rawField(iFieldName);
        OType t = this.fieldType(iFieldName);
        if (this._lazyLoad && value instanceof ORID && t != OType.LINK && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            value = this.getDatabase().load((ORID)value);
            this.removeCollectionChangeListener(iFieldName);
            this.removeCollectionTimeLine(iFieldName);
            this._fieldValues.put(iFieldName, value);
            this.addCollectionChangeListener(iFieldName, value);
        }
        if (t != null) {
            Object newValue = null;
            if (t == OType.BINARY && value instanceof String) {
                newValue = OStringSerializerHelper.getBinaryContent(value);
            } else if (t == OType.DATE && value instanceof Long) {
                newValue = new Date((Long)value);
            } else if ((t == OType.EMBEDDEDSET || t == OType.LINKSET) && value instanceof List) {
                newValue = ODocumentHelper.convertField(this, iFieldName, Set.class, value);
            } else if ((t == OType.EMBEDDEDLIST || t == OType.LINKLIST) && value instanceof Set) {
                newValue = ODocumentHelper.convertField(this, iFieldName, List.class, value);
            }
            if (newValue != null) {
                this.removeCollectionChangeListener(iFieldName);
                this.removeCollectionTimeLine(iFieldName);
                this._fieldValues.put(iFieldName, newValue);
                this.addCollectionChangeListener(iFieldName, newValue);
                value = newValue;
            }
        }
        return value;
    }

    public <RET> RET field(String iFieldName, Class<?> iFieldType) {
        RET value = this.rawField(iFieldName);
        if (value != null) {
            value = ODocumentHelper.convertField(this, iFieldName, iFieldType, value);
        }
        return value;
    }

    @Override
    public <RET> RET field(String iFieldName, OType iFieldType) {
        this.setFieldType(iFieldName, iFieldType);
        return this.field(iFieldName);
    }

    public ODocument field(String iFieldName, Object iPropertyValue) {
        return this.field(iFieldName, iPropertyValue, null);
    }

    public ODocument fields(String iFieldName, Object iFieldValue, Object ... iFields) {
        this.field(iFieldName, iFieldValue);
        if (iFields != null && iFields.length > 0) {
            for (int i = 0; i < iFields.length; i += 2) {
                this.field(iFields[i].toString(), iFields[i + 1]);
            }
        }
        return this;
    }

    public ODocument field(String iFieldName, Object iPropertyValue, OType iFieldType) {
        OProperty prop;
        iFieldName = this.checkFieldName(iFieldName);
        this.checkForLoading();
        this.checkForFields();
        this._source = null;
        boolean knownProperty = this._fieldValues.containsKey(iFieldName);
        Object oldValue = this._fieldValues.get(iFieldName);
        if (knownProperty) {
            if (iPropertyValue == null) {
                if (oldValue == null) {
                    return this;
                }
            } else {
                try {
                    if (iPropertyValue == oldValue) {
                        if (!(iPropertyValue instanceof ORecordElement)) {
                            this.setDirty();
                        }
                        return this;
                    }
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error on checking the value of property %s against the record %s", e, iFieldName, this.getIdentity());
                }
            }
        }
        this.setFieldType(iFieldName, iFieldType);
        if (iFieldType == null && this._clazz != null && (prop = this._clazz.getProperty(iFieldName)) != null) {
            iFieldType = prop.getType();
        }
        if (iPropertyValue != null) {
            if (iFieldType != null) {
                iPropertyValue = ODocumentHelper.convertField(this, iFieldName, iFieldType.getDefaultJavaType(), iPropertyValue);
            } else if (iPropertyValue instanceof Enum) {
                iPropertyValue = iPropertyValue.toString();
            }
        }
        this.removeCollectionChangeListener(iFieldName);
        this.removeCollectionTimeLine(iFieldName);
        this._fieldValues.put(iFieldName, iPropertyValue);
        this.addCollectionChangeListener(iFieldName, iPropertyValue);
        if (this._status != ORecordElement.STATUS.UNMARSHALLING) {
            this.setDirty();
            if (this._trackingChanges && this._recordId.isValid()) {
                if (this._fieldOriginalValues == null) {
                    this._fieldOriginalValues = new HashMap<String, Object>();
                }
                if (!this._fieldOriginalValues.containsKey(iFieldName)) {
                    this._fieldOriginalValues.put(iFieldName, oldValue);
                }
            }
        }
        return this;
    }

    @Override
    public Object removeField(String iFieldName) {
        this.checkForLoading();
        this.checkForFields();
        boolean knownProperty = this._fieldValues.containsKey(iFieldName);
        Object oldValue = this._fieldValues.get(iFieldName);
        if (knownProperty && this._trackingChanges) {
            if (this._fieldOriginalValues == null) {
                this._fieldOriginalValues = new HashMap<String, Object>();
            }
            if (!this._fieldOriginalValues.containsKey(iFieldName)) {
                this._fieldOriginalValues.put(iFieldName, oldValue);
            }
        }
        this.removeCollectionTimeLine(iFieldName);
        this.removeCollectionChangeListener(iFieldName);
        this._fieldValues.remove(iFieldName);
        this._source = null;
        this.setDirty();
        return oldValue;
    }

    public ODocument merge(ODocument iOther, boolean iConflictsOtherWins, boolean iMergeSingleItemsOfMultiValueFields) {
        iOther.checkForLoading();
        iOther.checkForFields();
        if (this._clazz == null && iOther.getSchemaClass() != null) {
            this._clazz = iOther.getSchemaClass();
        }
        return this.merge(iOther._fieldValues, iConflictsOtherWins, iMergeSingleItemsOfMultiValueFields);
    }

    public ODocument merge(Map<String, Object> iOther, boolean iAddOnlyMode, boolean iMergeSingleItemsOfMultiValueFields) {
        this.checkForLoading();
        this.checkForFields();
        this._source = null;
        for (String f : iOther.keySet()) {
            if (this.containsField(f) && iMergeSingleItemsOfMultiValueFields) {
                Object field = this.field(f);
                if (field instanceof Map) {
                    Map map = (Map)field;
                    Map otherMap = (Map)iOther.get(f);
                    for (Map.Entry entry : otherMap.entrySet()) {
                        map.put(entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (field instanceof Collection) {
                    Collection coll = (Collection)field;
                    Collection otherColl = (Collection)iOther.get(f);
                    for (Map.Entry item : otherColl) {
                        if (coll.contains(item)) {
                            coll.remove(item);
                        }
                        coll.add(item);
                    }
                    continue;
                }
            }
            this.setFieldType(f, null);
            this.field(f, iOther.get(f));
        }
        if (!iAddOnlyMode) {
            for (String f : this.fieldNames()) {
                if (iOther.containsKey(f)) continue;
                this.removeField(f);
            }
        }
        return this;
    }

    public String[] getDirtyFields() {
        if ((this._fieldOriginalValues == null || this._fieldOriginalValues.isEmpty()) && (this._fieldCollectionChangeTimeLines == null || this._fieldCollectionChangeTimeLines.isEmpty())) {
            return EMPTY_STRINGS;
        }
        HashSet<String> dirtyFields = new HashSet<String>();
        if (this._fieldOriginalValues != null) {
            dirtyFields.addAll(this._fieldOriginalValues.keySet());
        }
        if (this._fieldCollectionChangeTimeLines != null) {
            dirtyFields.addAll(this._fieldCollectionChangeTimeLines.keySet());
        }
        return dirtyFields.toArray(new String[dirtyFields.size()]);
    }

    public Object getOriginalValue(String iFieldName) {
        return this._fieldOriginalValues != null ? this._fieldOriginalValues.get(iFieldName) : null;
    }

    public OMultiValueChangeTimeLine<String, Object> getCollectionTimeLine(String iFieldName) {
        return this._fieldCollectionChangeTimeLines != null ? this._fieldCollectionChangeTimeLines.get(iFieldName) : null;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        this.checkForLoading();
        this.checkForFields();
        if (this._fieldValues == null) {
            return OEmptyIterator.INSTANCE;
        }
        final Iterator<Map.Entry<String, Object>> iterator = this._fieldValues.entrySet().iterator();
        return new Iterator<Map.Entry<String, Object>>(){
            private Map.Entry<String, Object> current;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                this.current = (Map.Entry)iterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                iterator.remove();
                if (ODocument.this._trackingChanges) {
                    if (ODocument.this._fieldOriginalValues == null) {
                        ODocument.this._fieldOriginalValues = new HashMap<String, Object>();
                    }
                    if (!ODocument.this._fieldOriginalValues.containsKey(this.current.getKey())) {
                        ODocument.this._fieldOriginalValues.put(this.current.getKey(), this.current.getValue());
                    }
                }
                ODocument.this.removeCollectionChangeListener(this.current.getKey());
                ODocument.this.removeCollectionTimeLine(this.current.getKey());
            }
        };
    }

    @Override
    public boolean containsField(String iFieldName) {
        if (iFieldName == null) {
            return false;
        }
        this.checkForLoading();
        this.checkForFields();
        return this._fieldValues.containsKey(iFieldName);
    }

    @Override
    public byte getRecordType() {
        return 100;
    }

    public boolean hasOwners() {
        return this._owners != null && !this._owners.isEmpty();
    }

    public ODocument addOwner(ORecordElement iOwner) {
        if (this._owners == null) {
            this._owners = new ArrayList<WeakReference<ORecordElement>>();
        }
        this._owners.add(new WeakReference<ORecordElement>(iOwner));
        return this;
    }

    public Iterable<ORecordElement> getOwners() {
        if (this._owners == null) {
            return Collections.emptyList();
        }
        ArrayList<ORecordElement> result = new ArrayList<ORecordElement>();
        for (WeakReference<ORecordElement> o : this._owners) {
            result.add((ORecordElement)o.get());
        }
        return result;
    }

    public ODocument removeOwner(ORecordElement iRecordElement) {
        if (this._owners != null) {
            for (int i = 0; i < this._owners.size(); ++i) {
                ORecordElement e = (ORecordElement)this._owners.get(i).get();
                if (e != iRecordElement) continue;
                this._owners.remove(i);
                break;
            }
        }
        return this;
    }

    @Override
    public ORecordAbstract<Object> setDirty() {
        if (this._owners != null) {
            for (WeakReference<ORecordElement> o : this._owners) {
                ORecordElement e = (ORecordElement)o.get();
                if (e == null) continue;
                e.setDirty();
            }
        }
        this.checkForFields();
        return super.setDirty();
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
        if (this._owners != null) {
            ArrayList<WeakReference<ORecordElement>> temp = new ArrayList<WeakReference<ORecordElement>>(this._owners);
            for (WeakReference weakReference : temp) {
                ORecordElement e = (ORecordElement)weakReference.get();
                if (e == null) continue;
                e.onBeforeIdentityChanged(iRID);
            }
        }
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
        super.onAfterIdentityChanged(iRecord);
        if (this._owners != null) {
            ArrayList<WeakReference<ORecordElement>> temp = new ArrayList<WeakReference<ORecordElement>>(this._owners);
            for (WeakReference weakReference : temp) {
                ORecordElement e = (ORecordElement)weakReference.get();
                if (e == null) continue;
                e.onAfterIdentityChanged(iRecord);
            }
        }
    }

    @Override
    public ODocument fromStream(byte[] iRecordBuffer) {
        this.removeAllCollectionChangeListeners();
        this._fieldValues = null;
        this._fieldTypes = null;
        this._fieldOriginalValues = null;
        this._fieldChangeListeners = null;
        this._fieldCollectionChangeTimeLines = null;
        super.fromStream(iRecordBuffer);
        if (!this._lazyLoad) {
            this.checkForFields();
            this.checkForLoading();
        }
        return this;
    }

    @Override
    public void unsetDirty() {
        this._fieldOriginalValues = null;
        this._fieldCollectionChangeTimeLines = null;
        super.unsetDirty();
    }

    public OType fieldType(String iFieldName) {
        return this._fieldTypes != null ? this._fieldTypes.get(iFieldName) : null;
    }

    @Override
    public ODocument unload() {
        super.unload();
        this.internalReset();
        return this;
    }

    @Override
    public ODocument clear() {
        super.clear();
        this.internalReset();
        this._owners = null;
        return this;
    }

    @Override
    public ODocument reset() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && db.getTransaction().isActive()) {
            throw new IllegalStateException("Cannot reset documents during a transaction. Create a new one each time");
        }
        super.reset();
        this.internalReset();
        if (this._fieldOriginalValues != null) {
            this._fieldOriginalValues.clear();
        }
        this._owners = null;
        return this;
    }

    protected void internalReset() {
        this.removeAllCollectionChangeListeners();
        if (this._fieldCollectionChangeTimeLines != null) {
            this._fieldCollectionChangeTimeLines.clear();
        }
        if (this._fieldValues != null) {
            this._fieldValues.clear();
        }
    }

    public ODocument undo() {
        if (!this._trackingChanges) {
            throw new OConfigurationException("Cannot undo the document because tracking of changes is disabled");
        }
        for (Map.Entry<String, Object> entry : this._fieldOriginalValues.entrySet()) {
            Object value = entry.getValue();
            if (value == null) {
                this._fieldValues.remove(entry.getKey());
                continue;
            }
            this._fieldValues.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public boolean isLazyLoad() {
        return this._lazyLoad;
    }

    public void setLazyLoad(boolean iLazyLoad) {
        this._lazyLoad = iLazyLoad;
        if (this._fieldValues != null) {
            for (Map.Entry<String, Object> field : this._fieldValues.entrySet()) {
                if (!(field.getValue() instanceof ORecordLazyMultiValue)) continue;
                ((ORecordLazyMultiValue)field.getValue()).setAutoConvertToRecord(false);
            }
        }
    }

    public boolean isTrackingChanges() {
        return this._trackingChanges;
    }

    public ODocument setTrackingChanges(boolean iTrackingChanges) {
        this._trackingChanges = iTrackingChanges;
        if (!iTrackingChanges) {
            this._fieldOriginalValues = null;
            this.removeAllCollectionChangeListeners();
            this._fieldChangeListeners = null;
            this._fieldCollectionChangeTimeLines = null;
        } else {
            this.addAllMultiValueChangeListeners();
        }
        return this;
    }

    public boolean isOrdered() {
        return this._ordered;
    }

    public ODocument setOrdered(boolean iOrdered) {
        this._ordered = iOrdered;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this == obj || this._recordId.isValid();
    }

    @Override
    public int fields() {
        return this._fieldValues == null ? 0 : this._fieldValues.size();
    }

    public boolean isEmpty() {
        return this._fieldValues == null || this._fieldValues.isEmpty();
    }

    public boolean isEmbedded() {
        return this._owners != null && !this._owners.isEmpty();
    }

    @Override
    protected void checkForFields() {
        if (this._fieldValues == null) {
            Map<Object, Object> map = this._fieldValues = this._ordered ? new LinkedHashMap() : new HashMap();
        }
        if (this._status == ORecordElement.STATUS.LOADED && this._fieldValues.size() == 0) {
            this.deserializeFields();
        }
    }

    @Override
    protected void setup() {
        super.setup();
        this._recordFormat = ORecordSerializerFactory.instance().getFormat("ORecordDocument2csv");
    }

    public ODocument setFieldType(String iFieldName, OType iFieldType) {
        if (iFieldType != null) {
            if (this._fieldTypes == null) {
                this._fieldTypes = new HashMap<String, OType>();
            }
            this._fieldTypes.put(iFieldName, iFieldType);
        } else if (this._fieldTypes != null) {
            this._fieldTypes.remove(iFieldName);
            if (this._fieldTypes.size() == 0) {
                this._fieldTypes = null;
            }
        }
        return this;
    }

    @Override
    public ODocument save() {
        if (this._clazz != null) {
            return this.save(this.getDatabase().getClusterNameById(this._clazz.getDefaultClusterId()));
        }
        this.convertAllMultiValuesToTrackedVersions();
        this.validate();
        return (ODocument)super.save();
    }

    @Override
    public ODocument save(String iClusterName) {
        this.convertAllMultiValuesToTrackedVersions();
        this.validate();
        return (ODocument)super.save(iClusterName);
    }

    protected String checkFieldName(String iFieldName) {
        Character c = OSchemaShared.checkNameIfValid(iFieldName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid field name '" + iFieldName + "'. Character '" + c + "' is invalid");
        }
        return iFieldName;
    }

    private void addCollectionChangeListener(String fieldName) {
        Object fieldValue = this._fieldValues.get(fieldName);
        this.addCollectionChangeListener(fieldName, fieldValue);
    }

    private void addCollectionChangeListener(String fieldName, Object fieldValue) {
        OType fieldType = this.fieldType(fieldName);
        if (fieldType == null && this._clazz != null) {
            OProperty prop = this._clazz.getProperty(fieldName);
            OType oType = fieldType = prop != null ? prop.getType() : null;
        }
        if (!(fieldType != null && (OType.EMBEDDEDLIST.equals((Object)fieldType) || OType.EMBEDDEDMAP.equals((Object)fieldType) || OType.EMBEDDEDSET.equals((Object)fieldType) || OType.LINKLIST.equals((Object)fieldType) || OType.LINKMAP.equals((Object)fieldType)))) {
            return;
        }
        if (!(fieldValue instanceof OTrackedMultiValue)) {
            return;
        }
        OTrackedMultiValue multiValue = (OTrackedMultiValue)fieldValue;
        if (this._fieldChangeListeners == null) {
            this._fieldChangeListeners = new HashMap<String, OSimpleMultiValueChangeListener<String, Object>>();
        }
        if (!this._fieldChangeListeners.containsKey(fieldName)) {
            OSimpleMultiValueChangeListener listener = new OSimpleMultiValueChangeListener(fieldName);
            multiValue.addChangeListener(listener);
            this._fieldChangeListeners.put(fieldName, listener);
        }
    }

    private void removeAllCollectionChangeListeners() {
        if (this._fieldValues == null) {
            return;
        }
        for (String fieldName : this._fieldValues.keySet()) {
            this.removeCollectionChangeListener(fieldName);
        }
        this._fieldChangeListeners = null;
    }

    private void addAllMultiValueChangeListeners() {
        if (this._fieldValues == null) {
            return;
        }
        for (String fieldName : this._fieldValues.keySet()) {
            this.addCollectionChangeListener(fieldName);
        }
    }

    private void removeCollectionChangeListener(String fieldName) {
        if (this._fieldChangeListeners == null) {
            return;
        }
        OMultiValueChangeListener changeListener = this._fieldChangeListeners.remove(fieldName);
        if (this._fieldValues == null) {
            return;
        }
        Object fieldValue = this._fieldValues.get(fieldName);
        if (!(fieldValue instanceof OTrackedMultiValue)) {
            return;
        }
        if (changeListener != null) {
            OTrackedMultiValue multiValue = (OTrackedMultiValue)fieldValue;
            multiValue.removeRecordChangeListener(changeListener);
        }
    }

    private void removeCollectionTimeLine(String fieldName) {
        if (this._fieldCollectionChangeTimeLines == null) {
            return;
        }
        this._fieldCollectionChangeTimeLines.remove(fieldName);
    }

    public void convertAllMultiValuesToTrackedVersions() {
        if (this._fieldValues == null) {
            return;
        }
        HashMap<String, Object> fieldsToUpdate = new HashMap<String, Object>();
        for (Map.Entry<String, Object> fieldEntry : this._fieldValues.entrySet()) {
            Object fieldValue = fieldEntry.getValue();
            OType fieldType = this.fieldType(fieldEntry.getKey());
            if (fieldType == null && this._clazz != null) {
                OProperty prop = this._clazz.getProperty(fieldEntry.getKey());
                OType oType = fieldType = prop != null ? prop.getType() : null;
            }
            if (fieldType == null || !OType.EMBEDDEDLIST.equals((Object)fieldType) && !OType.EMBEDDEDMAP.equals((Object)fieldType) && !OType.EMBEDDEDSET.equals((Object)fieldType) && !OType.LINKLIST.equals((Object)fieldType) && !OType.LINKMAP.equals((Object)fieldType)) continue;
            if (fieldValue instanceof List && fieldType.equals((Object)OType.EMBEDDEDLIST) && !(fieldValue instanceof OTrackedMultiValue)) {
                fieldsToUpdate.put(fieldEntry.getKey(), new OTrackedList(this, (List)fieldValue, null));
                continue;
            }
            if (fieldValue instanceof Set && fieldType.equals((Object)OType.EMBEDDEDSET) && !(fieldValue instanceof OTrackedMultiValue)) {
                fieldsToUpdate.put(fieldEntry.getKey(), new OTrackedSet(this, (Set)fieldValue, null));
                continue;
            }
            if (fieldValue instanceof Map && fieldType.equals((Object)OType.EMBEDDEDMAP) && !(fieldValue instanceof OTrackedMultiValue)) {
                fieldsToUpdate.put(fieldEntry.getKey(), new OTrackedMap(this, (Map)fieldValue, null));
                continue;
            }
            if (fieldValue instanceof List && fieldType.equals((Object)OType.LINKLIST) && !(fieldValue instanceof OTrackedMultiValue)) {
                fieldsToUpdate.put(fieldEntry.getKey(), new ORecordLazyList(this, (List)fieldValue));
                continue;
            }
            if (!(fieldValue instanceof Map) || !fieldType.equals((Object)OType.LINKMAP) || fieldValue instanceof OTrackedMultiValue) continue;
            fieldsToUpdate.put(fieldEntry.getKey(), new ORecordLazyMap(this, (Map)fieldValue));
        }
        this._fieldValues.putAll(fieldsToUpdate);
        this.addAllMultiValueChangeListeners();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OSimpleMultiValueChangeListener<K, V>
    implements OMultiValueChangeListener<K, V> {
        private final String fieldName;

        private OSimpleMultiValueChangeListener(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public void onAfterRecordChanged(OMultiValueChangeEvent<K, V> event) {
            OMultiValueChangeTimeLine<String, Object> timeLine;
            if (ODocument.this._status != ORecordElement.STATUS.UNMARSHALLING) {
                ODocument.this.setDirty();
            }
            if (!ODocument.this._trackingChanges || !ODocument.this._recordId.isValid() || ODocument.this._status == ORecordElement.STATUS.UNMARSHALLING) {
                return;
            }
            if (ODocument.this._fieldOriginalValues != null && ODocument.this._fieldOriginalValues.containsKey(this.fieldName)) {
                return;
            }
            if (ODocument.this._fieldCollectionChangeTimeLines == null) {
                ODocument.this._fieldCollectionChangeTimeLines = new HashMap<String, OMultiValueChangeTimeLine<String, Object>>();
            }
            if ((timeLine = ODocument.this._fieldCollectionChangeTimeLines.get(this.fieldName)) == null) {
                timeLine = new OMultiValueChangeTimeLine();
                ODocument.this._fieldCollectionChangeTimeLines.put(this.fieldName, timeLine);
            }
            timeLine.addCollectionChangeEvent(event);
        }
    }
}

