/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.object;

import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelperInterface;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectSerializerHelperDocument
implements OObjectSerializerHelperInterface {
    private Set<String> classes = new HashSet<String>();
    private HashMap<Class<?>, Field> boundDocumentFields = new HashMap();

    @Override
    public ODocument toStream(Object iPojo, ODocument iRecord, OEntityManager iEntityManager, OClass schemaClass, OUserObject2RecordHandler iObj2RecHandler, ODatabaseObject db, boolean iSaveOnlyDirty) {
        return null;
    }

    @Override
    public String getDocumentBoundField(Class<?> iClass) {
        this.getClassFields(iClass);
        Field f = this.boundDocumentFields.get(iClass);
        return f != null ? f.getName() : null;
    }

    @Override
    public Object getFieldValue(Object iPojo, String iProperty) {
        return null;
    }

    @Override
    public void invokeCallback(Object iPojo, ODocument iDocument, Class<?> iAnnotation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getClassFields(Class<?> iClass) {
        if (iClass.getName().startsWith("java.lang")) {
            return;
        }
        Set<String> set = this.classes;
        synchronized (set) {
            if (this.classes.contains(iClass.getName())) {
                return;
            }
            this.analyzeClass(iClass);
        }
    }

    protected void analyzeClass(Class<?> iClass) {
        this.classes.add(iClass.getName());
        Class<Object> currentClass = iClass;
        while (currentClass != Object.class) {
            for (Field f : currentClass.getDeclaredFields()) {
                int fieldModifier = f.getModifiers();
                if (Modifier.isStatic(fieldModifier) || Modifier.isNative(fieldModifier) || Modifier.isTransient(fieldModifier) || f.getName().equals("this$0")) continue;
                if (f.getAnnotation(ODocumentInstance.class) != null) {
                    this.boundDocumentFields.put(iClass, f);
                }
                if (!(currentClass = currentClass.getSuperclass()).equals(ODocument.class)) continue;
                currentClass = Object.class;
            }
        }
    }
}

