/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.json.OJSONFetchContext;
import com.orientechnologies.orient.core.fetch.json.OJSONFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.ORecordStringable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordSerializerJSON
extends ORecordSerializerStringAbstract {
    public static final String NAME = "json";
    public static final ORecordSerializerJSON INSTANCE = new ORecordSerializerJSON();
    public static final String ATTRIBUTE_FIELD_TYPES = "@fieldTypes";
    public static final String DEF_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    public static final char[] PARAMETER_SEPARATOR = new char[]{':', ','};
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    @Override
    public ORecordInternal<?> fromString(String iSource, ORecordInternal<?> iRecord) {
        List<String> fields;
        if (iSource == null) {
            throw new OSerializationException("Error on unmarshalling JSON content: content is null");
        }
        if (!(iSource = iSource.trim()).startsWith("{") || !iSource.endsWith("}")) {
            throw new OSerializationException("Error on unmarshalling JSON content: content must be between { }");
        }
        if (iRecord != null) {
            iRecord.clear();
        }
        if ((fields = OStringSerializerHelper.smartSplit(iSource = iSource.substring(1, iSource.length() - 1).trim(), PARAMETER_SEPARATOR, 0, -1, true, ' ', '\n', '\r', '\t')).size() % 2 != 0) {
            throw new OSerializationException("Error on unmarshalling JSON content: wrong format. Use <field> : <value>");
        }
        HashMap<String, Character> fieldTypes = null;
        if (fields != null && fields.size() > 0) {
            String fieldValueAsString;
            String fieldValue;
            String fieldName;
            int i;
            for (i = 0; i < fields.size(); i += 2) {
                fieldName = OStringSerializerHelper.getStringContent(fields.get(i));
                fieldValue = fields.get(i + 1);
                fieldValueAsString = OStringSerializerHelper.getStringContent(fieldValue);
                if (fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) {
                    String[] fieldTypesParts = fieldValueAsString.split(",");
                    if (fieldTypesParts.length <= 0) continue;
                    fieldTypes = new HashMap<String, Character>();
                    for (String f : fieldTypesParts) {
                        String[] part = f.split("=");
                        if (part.length != 2) continue;
                        fieldTypes.put(part[0], Character.valueOf(part[1].charAt(0)));
                    }
                    continue;
                }
                if (!fieldName.equals("@type") || iRecord != null && iRecord.getRecordType() == fieldValueAsString.charAt(0)) continue;
                iRecord = Orient.instance().getRecordFactoryManager().newInstance((byte)fieldValueAsString.charAt(0));
            }
            try {
                for (i = 0; i < fields.size(); i += 2) {
                    fieldName = OStringSerializerHelper.getStringContent(fields.get(i));
                    fieldValue = fields.get(i + 1);
                    fieldValueAsString = OStringSerializerHelper.getStringContent(fieldValue);
                    if (fieldName.equals("@rid")) {
                        iRecord.setIdentity(new ORecordId(fieldValueAsString));
                        continue;
                    }
                    if (fieldName.equals("@version")) {
                        iRecord.setVersion(Integer.parseInt(fieldValue));
                        continue;
                    }
                    if (fieldName.equals("@type")) continue;
                    if (fieldName.equals("@class") && iRecord instanceof ODocument) {
                        ((ODocument)iRecord).setClassNameIfExists("null".equals(fieldValueAsString) ? null : fieldValueAsString);
                        continue;
                    }
                    if (fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) continue;
                    if (fieldName.equals("value") && !(iRecord instanceof ODocument)) {
                        if ("null".equals(fieldValue)) {
                            iRecord.fromStream(new byte[0]);
                            continue;
                        }
                        if (iRecord instanceof ORecordBytes) {
                            iRecord.fromStream(OBase64Utils.decode(fieldValueAsString));
                            continue;
                        }
                        if (!(iRecord instanceof ORecordStringable)) continue;
                        ((ORecordStringable)((Object)iRecord)).value(fieldValueAsString);
                        continue;
                    }
                    if (!(iRecord instanceof ODocument)) continue;
                    Object v = this.getValue((ODocument)iRecord, fieldName, fieldValue, fieldValueAsString, null, null, fieldTypes);
                    if (v != null) {
                        Object first;
                        if (v instanceof Collection && !((Collection)v).isEmpty()) {
                            if (v instanceof ORecordLazyList) {
                                ((ORecordLazyList)v).setAutoConvertToRecord(false);
                            } else if (v instanceof OMVRBTreeRIDSet) {
                                ((OMVRBTreeRIDSet)v).setAutoConvert(false);
                            }
                            first = ((Collection)v).iterator().next();
                            if (first != null && first instanceof ORecord && !((ORecord)first).getIdentity().isValid()) {
                                ((ODocument)iRecord).field(fieldName, v, v instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDLIST);
                                continue;
                            }
                        } else if (v instanceof Map && !((Map)v).isEmpty() && (first = ((Map)v).values().iterator().next()) != null && first instanceof ORecord && !((ORecord)first).getIdentity().isValid()) {
                            ((ODocument)iRecord).field(fieldName, v, OType.EMBEDDEDMAP);
                            continue;
                        }
                    }
                    ((ODocument)iRecord).field(fieldName, v);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OSerializationException("Error on unmarshalling JSON content for record " + iRecord.getIdentity(), e);
            }
        }
        return iRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValue(ODocument iRecord, String iFieldName, String iFieldValue, String iFieldValueAsString, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes) {
        OProperty p;
        if (iFieldValue.equals("null")) {
            return null;
        }
        if (iFieldName != null && iRecord.getSchemaClass() != null && (p = iRecord.getSchemaClass().getProperty(iFieldName)) != null) {
            iType = p.getType();
            iLinkedType = p.getLinkedType();
        }
        if (iFieldValue.startsWith("{") && iFieldValue.endsWith("}")) {
            iFieldValueAsString = iFieldValue.substring(1, iFieldValue.length() - 1);
            String[] fields = OStringParser.getWords(iFieldValueAsString, ":,", true);
            if (fields == null || fields.length == 0) {
                return new HashMap();
            }
            if (this.hasTypeField(fields)) {
                ORecordInternal<?> recordInternal = this.fromString(iFieldValue, null);
                if (recordInternal instanceof ODocument) {
                    ((ODocument)recordInternal).addOwner(iRecord);
                }
                return recordInternal;
            }
            if (fields.length % 2 == 1) {
                throw new OSerializationException("Bad JSON format on map. Expected pairs of field:value but received '" + iFieldValueAsString + "'");
            }
            LinkedHashMap<String, Object> embeddedMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < fields.length; i += 2) {
                iFieldName = fields[i];
                if (iFieldName.length() >= 2) {
                    iFieldName = iFieldName.substring(1, iFieldName.length() - 1);
                }
                iFieldValue = fields[i + 1];
                iFieldValueAsString = OStringSerializerHelper.getStringContent(iFieldValue);
                embeddedMap.put(iFieldName, this.getValue(iRecord, null, iFieldValue, iFieldValueAsString, iLinkedType, null, iFieldTypes));
            }
            return embeddedMap;
        }
        if (iFieldValue.startsWith("[") && iFieldValue.endsWith("]")) {
            Collection<OIdentifiable> embeddedCollection = iType == OType.LINKSET ? new OMVRBTreeRIDSet(iRecord) : (iType == OType.EMBEDDEDSET ? new OTrackedSet(iRecord) : (iType == OType.LINKLIST ? new ORecordLazyList(iRecord) : new OTrackedList(iRecord)));
            if (!(iFieldValue = iFieldValue.substring(1, iFieldValue.length() - 1)).isEmpty()) {
                List<String> items = OStringSerializerHelper.smartSplit(iFieldValue, ',', new char[0]);
                for (String item : items) {
                    iFieldValueAsString = (iFieldValue = item.trim()).length() >= 2 ? iFieldValue.substring(1, iFieldValue.length() - 1) : iFieldValue;
                    Object collectionItem = this.getValue(iRecord, null, iFieldValue, iFieldValueAsString, iLinkedType, null, iFieldTypes);
                    if (collectionItem instanceof ODocument && iRecord instanceof ODocument) {
                        ((ODocument)collectionItem).addOwner(iRecord);
                    }
                    if (collectionItem instanceof String && ((String)collectionItem).length() == 0) continue;
                    embeddedCollection.add((OIdentifiable)collectionItem);
                }
            }
            return embeddedCollection;
        }
        if (iType == null) {
            Serializable c;
            if (iFieldValue.charAt(0) != '\"' && iFieldValue.charAt(0) != '\'') {
                if (iFieldValue.equalsIgnoreCase("false") || iFieldValue.equalsIgnoreCase("true")) {
                    iType = OType.BOOLEAN;
                } else {
                    c = null;
                    if (iFieldTypes != null && (c = iFieldTypes.get(iFieldName)) != null) {
                        iType = ORecordSerializerStringAbstract.getType(iFieldValue + c);
                    }
                    if (c == null && !iFieldValue.isEmpty()) {
                        iType = iFieldValue.charAt(0) == '#' && iFieldValue.contains(":") ? OType.LINK : (OStringSerializerHelper.contains(iFieldValue, '.') ? OType.FLOAT : OType.INTEGER);
                    }
                }
            } else if (iFieldValueAsString.startsWith("{") && iFieldValueAsString.endsWith("}")) {
                iType = OType.EMBEDDED;
            } else {
                List<String> parts;
                if (iFieldValueAsString.length() >= 4 && iFieldValueAsString.charAt(0) == '#' && iFieldValueAsString.contains(":") && (parts = OStringSerializerHelper.split(iFieldValueAsString, 1, -1, ':', new char[0])).size() == 2) {
                    try {
                        Short.parseShort(parts.get(0));
                        Long.parseLong(parts.get(1));
                        iType = OType.LINK;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (iFieldTypes != null) {
                    c = null;
                    c = iFieldTypes.get(iFieldName);
                    if (c != null) {
                        iType = ORecordSerializerStringAbstract.getType(iFieldValueAsString, c.charValue());
                    }
                }
                if (iType == null) {
                    if (iFieldValueAsString.length() == DEF_DATE_FORMAT.length()) {
                        try {
                            c = this.dateFormat;
                            synchronized (c) {
                                return this.dateFormat.parseObject(iFieldValueAsString);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    iType = OType.STRING;
                }
            }
        }
        if (iType != null) {
            switch (iType) {
                case STRING: {
                    return this.decodeJSON(iFieldValueAsString);
                }
                case LINK: {
                    int pos = iFieldValueAsString.indexOf(64);
                    if (pos > -1) {
                        return new ODocument(iFieldValueAsString.substring(1, pos), (ORID)new ORecordId(iFieldValueAsString.substring(pos + 1)));
                    }
                    return new ORecordId(iFieldValueAsString);
                }
                case EMBEDDED: {
                    return this.fromString(iFieldValueAsString);
                }
                case DATE: 
                case DATETIME: {
                    if (iFieldValueAsString == null || iFieldValueAsString.equals("")) {
                        return null;
                    }
                    try {
                        return Long.parseLong(iFieldValueAsString);
                    }
                    catch (NumberFormatException e) {
                        try {
                            return this.dateFormat.parseObject(iFieldValueAsString);
                        }
                        catch (ParseException ex) {
                            throw new OSerializationException("Unable to unmarshall date: " + iFieldValueAsString, e);
                        }
                    }
                }
                case BINARY: {
                    return OStringSerializerHelper.fieldTypeFromStream(iRecord, iType, iFieldValueAsString);
                }
            }
            return OStringSerializerHelper.fieldTypeFromStream(iRecord, iType, iFieldValue);
        }
        return iFieldValueAsString;
    }

    private String decodeJSON(String iFieldValueAsString) {
        iFieldValueAsString = OStringParser.replaceAll(iFieldValueAsString, "\\\\", "\\");
        iFieldValueAsString = OStringParser.replaceAll(iFieldValueAsString, "\\\"", "\"");
        iFieldValueAsString = OStringParser.replaceAll(iFieldValueAsString, "\\/", "/");
        return iFieldValueAsString;
    }

    @Override
    public StringBuilder toString(ORecordInternal<?> iRecord, StringBuilder iOutput, String iFormat, OUserObject2RecordHandler iObjHandler, Set<Integer> iMarshalledRecords, boolean iOnlyDelta) {
        try {
            Object record;
            boolean alwaysFetchEmbeddedDocuments;
            boolean keepTypes;
            int indentLevel;
            boolean attribSameRow;
            boolean includeClazz;
            boolean includeId;
            boolean includeVer;
            boolean includeType;
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter(buffer, iFormat);
            String fetchPlan = null;
            if (iFormat == null) {
                includeType = true;
                includeVer = true;
                includeId = true;
                includeClazz = true;
                attribSameRow = true;
                indentLevel = 0;
                fetchPlan = "";
                keepTypes = true;
                alwaysFetchEmbeddedDocuments = true;
            } else {
                String[] format;
                includeType = false;
                includeVer = false;
                includeId = false;
                includeClazz = false;
                attribSameRow = false;
                alwaysFetchEmbeddedDocuments = false;
                indentLevel = 0;
                keepTypes = true;
                for (String f : format = iFormat.split(",")) {
                    if (f.equals("type")) {
                        includeType = true;
                        continue;
                    }
                    if (f.equals("rid")) {
                        includeId = true;
                        continue;
                    }
                    if (f.equals("version")) {
                        includeVer = true;
                        continue;
                    }
                    if (f.equals("class")) {
                        includeClazz = true;
                        continue;
                    }
                    if (f.equals("attribSameRow")) {
                        attribSameRow = true;
                        continue;
                    }
                    if (f.startsWith("indent")) {
                        indentLevel = Integer.parseInt(f.substring(f.indexOf(58) + 1));
                        continue;
                    }
                    if (f.startsWith("fetchPlan")) {
                        fetchPlan = f.substring(f.indexOf(58) + 1);
                        continue;
                    }
                    if (f.startsWith("keepTypes")) {
                        keepTypes = true;
                        continue;
                    }
                    if (!f.startsWith("alwaysFetchEmbedded")) continue;
                    alwaysFetchEmbeddedDocuments = true;
                }
            }
            json.beginObject(indentLevel);
            OJSONFetchContext context = new OJSONFetchContext(json, includeType, includeId, includeVer, includeClazz, attribSameRow, keepTypes, alwaysFetchEmbeddedDocuments);
            context.writeSignature(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, iRecord);
            if (iRecord instanceof ORecordSchemaAware) {
                OFetchHelper.fetch(iRecord, null, OFetchHelper.buildFetchPlan(fetchPlan), new OJSONFetchListener(), context);
            } else if (iRecord instanceof ORecordStringable) {
                record = (ORecordStringable)((Object)iRecord);
                json.writeAttribute(indentLevel + 1, true, "value", record.value());
            } else if (iRecord instanceof ORecordBytes) {
                record = (ORecordBytes)iRecord;
                json.writeAttribute(indentLevel + 1, true, "value", OBase64Utils.encodeBytes(((ORecordBytes)record).toStream()));
            } else {
                throw new OSerializationException("Error on marshalling record of type '" + iRecord.getClass() + "' to JSON. The record type cannot be exported to JSON");
            }
            json.endObject(indentLevel);
            iOutput.append(buffer);
            return iOutput;
        }
        catch (IOException e) {
            throw new OSerializationException("Error on marshalling of record to JSON", e);
        }
    }

    private boolean hasTypeField(String[] fields) {
        for (int i = 0; i < fields.length; i += 2) {
            if (!fields[i].equals("\"@type\"") && !fields[i].equals("'@type'")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return NAME;
    }
}

