/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OCaseIncentiveComparator;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropProperty
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;
    private boolean force = false;

    public OCommandExecutorSQLDropProperty parse(OCommandRequest iRequest) {
        OCommandExecutorSQLDropProperty.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
            throw new OCommandSQLParsingException("Keyword PROPERTY not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.text, pos);
        }
        String[] parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.text, pos);
        }
        this.className = parts[0];
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class not found", this.text, pos);
        }
        this.fieldName = parts[1];
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) != -1) {
            String forceParameter = word.toString();
            if ("FORCE".equals(forceParameter)) {
                this.force = true;
            } else {
                throw new OCommandSQLParsingException("Wrong query parameter", this.text, pos);
            }
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.fieldName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not yet been parsed");
        }
        ODatabaseRecord database = OCommandExecutorSQLDropProperty.getDatabase();
        OClassImpl sourceClass = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        List<OIndex<?>> indexes = this.relatedIndexes(this.fieldName);
        if (!indexes.isEmpty()) {
            if (this.force) {
                this.dropRelatedIndexes(indexes);
            } else {
                StringBuilder indexNames = new StringBuilder();
                boolean first = true;
                for (OIndex<?> index : sourceClass.getClassInvolvedIndexes(this.fieldName)) {
                    if (!first) {
                        indexNames.append(", ");
                    } else {
                        first = false;
                    }
                    indexNames.append(index.getName());
                }
                throw new OCommandExecutionException("Property used in indexes (" + indexNames.toString() + "). Please drop these indexes before removing property or use FORCE parameter.");
            }
        }
        sourceClass.dropPropertyInternal(this.fieldName);
        sourceClass.saveInternal();
        return null;
    }

    private void dropRelatedIndexes(List<OIndex<?>> indexes) {
        ODatabaseRecord database = OCommandExecutorSQLDropProperty.getDatabase();
        for (OIndex<?> index : indexes) {
            database.command(new OCommandSQL("DROP INDEX " + index.getName())).execute(new Object[0]);
        }
    }

    private List<OIndex<?>> relatedIndexes(String fieldName) {
        ArrayList result = new ArrayList();
        ODatabaseRecord database = OCommandExecutorSQLDropProperty.getDatabase();
        for (OIndex<?> oIndex : database.getMetadata().getIndexManager().getClassIndexes(this.className)) {
            if (OCollections.indexOf(oIndex.getDefinition().getFields(), fieldName, new OCaseIncentiveComparator()) <= -1) continue;
            result.add(oIndex);
        }
        return result;
    }

    @Override
    public String getSyntax() {
        return "DROP PROPERTY <class>.<property>";
    }
}

