/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLGrant
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_GRANT = "GRANT";
    private static final String KEYWORD_TO = "TO";

    public OCommandExecutorSQLGrant parse(OCommandRequest iRequest) {
        OCommandExecutorSQLGrant.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        this.privilege = 0;
        this.resource = null;
        this.role = null;
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_GRANT)) {
            throw new OCommandSQLParsingException("Keyword GRANT not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid privilege", this.text, oldPos);
        }
        this.parsePrivilege(word, oldPos);
        pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        if (pos == -1 || !word.toString().equals("ON")) {
            throw new OCommandSQLParsingException("Keyword ON not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.text, pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid resource", this.text, oldPos);
        }
        this.resource = word.toString();
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_TO)) {
            throw new OCommandSQLParsingException("Keyword TO not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.text, pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid role", this.text, oldPos);
        }
        String roleName = word.toString();
        this.role = OCommandExecutorSQLGrant.getDatabase().getMetadata().getSecurity().getRole(roleName);
        if (this.role == null) {
            throw new OCommandSQLParsingException("Invalid role: " + roleName);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.role == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        this.role.grant(this.resource, this.privilege);
        this.role.save();
        return this.role;
    }

    @Override
    public String getSyntax() {
        return "GRANT <permission> ON <resource> TO <role>";
    }
}

