/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClusters;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCommandExecutorSQLResultsetAbstract
extends OCommandExecutorSQLAbstract
implements Iterator<OIdentifiable>,
Iterable<OIdentifiable> {
    protected static final String KEYWORD_FROM_2FIND = " FROM ";
    protected OSQLAsynchQuery<ORecordSchemaAware<?>> request;
    protected OSQLFilter compiledFilter;
    protected Iterable<? extends OIdentifiable> target;
    protected List<OIdentifiable> tempResult;
    protected int resultCount;
    protected int skip = 0;

    public OCommandExecutorSQLResultsetAbstract parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        this.init(textRequest.getText());
        if (iRequest instanceof OSQLSynchQuery) {
            this.request = (OSQLSynchQuery)iRequest;
        } else if (iRequest instanceof OSQLAsynchQuery) {
            this.request = (OSQLAsynchQuery)iRequest;
        } else {
            this.request = new OSQLSynchQuery(textRequest.getText());
            if (textRequest.getResultListener() != null) {
                this.request.setResultListener(textRequest.getResultListener());
            }
        }
        return this;
    }

    public List<OIdentifiable> getResult() {
        if (this.tempResult != null) {
            return this.tempResult;
        }
        if (this.request instanceof OSQLSynchQuery) {
            return (List)((OSQLSynchQuery)this.request).getResult();
        }
        return null;
    }

    protected boolean assignTarget(Map<Object, Object> iArgs) {
        this.parameters = iArgs;
        this.compiledFilter.bindParameters(iArgs);
        if (this.target == null) {
            if (this.compiledFilter.getTargetClasses() != null) {
                this.searchInClasses();
            } else if (this.compiledFilter.getTargetClusters() != null) {
                this.searchInClusters();
            } else if (this.compiledFilter.getTargetRecords() != null) {
                this.target = this.compiledFilter.getTargetRecords();
            } else {
                return false;
            }
        }
        return true;
    }

    protected Object handleResult() {
        if (this.tempResult != null) {
            for (OIdentifiable d : this.tempResult) {
                if (d == null) continue;
                this.request.getResultListener().result(d);
            }
        }
        if (this.request instanceof OSQLSynchQuery) {
            return ((OSQLSynchQuery)this.request).getResult();
        }
        return null;
    }

    protected boolean addResult(OIdentifiable iRecord) {
        if (iRecord != null) {
            Object recordCopy;
            ++this.resultCount;
            Object object = recordCopy = iRecord instanceof ORecord ? ((ORecord)iRecord).copy() : iRecord.getIdentity().copy();
            if (recordCopy != null && this.request.getResultListener() != null) {
                this.request.getResultListener().result(recordCopy);
            }
            if (this.limit > -1 && this.resultCount >= this.limit) {
                return false;
            }
        }
        return true;
    }

    protected int parseLimit(StringBuilder word) throws OCommandSQLParsingException {
        if (!word.toString().equals("LIMIT")) {
            return -1;
        }
        this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
        try {
            this.limit = Integer.parseInt(word.toString());
        }
        catch (Exception e) {
            throw new OCommandSQLParsingException("Invalid LIMIT value setted to '" + word + "' but it should be a valid integer. Example: LIMIT 10", this.text, this.currentPos);
        }
        if (this.limit < 0) {
            throw new OCommandSQLParsingException("Invalid LIMIT value setted to the negative number '" + word + "'. Only positive numbers are valid. Example: LIMIT 10", this.text, this.currentPos);
        }
        return this.limit;
    }

    protected int parseSkip(StringBuilder word) throws OCommandSQLParsingException {
        if (!word.toString().equals("SKIP")) {
            return -1;
        }
        this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
        try {
            this.skip = Integer.parseInt(word.toString());
        }
        catch (Exception e) {
            throw new OCommandSQLParsingException("Invalid SKIP value setted to '" + word + "' but it should be a valid positive integer. Example: SKIP 10", this.text, this.currentPos);
        }
        if (this.skip < 0) {
            throw new OCommandSQLParsingException("Invalid SKIP value setted to the negative number '" + word + "'. Only positive numbers are valid. Example: SKIP 10", this.text, this.currentPos);
        }
        return this.skip;
    }

    protected boolean filter(ORecordInternal<?> iRecord) {
        return this.compiledFilter.evaluate(iRecord, this.context);
    }

    protected void searchInClasses() {
        OClass cls = this.compiledFilter.getTargetClasses().keySet().iterator().next();
        ODatabaseRecord database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        database.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)cls.getName().toLowerCase());
        ORID[] range = this.getRange();
        this.target = new ORecordIteratorClass(database, (ODatabaseRecordAbstract)database, cls.getName(), true).setRange(range[0], range[1]);
    }

    protected void searchInClusters() {
        ODatabaseRecord database = OCommandExecutorSQLResultsetAbstract.getDatabase();
        HashSet<Integer> clusterIds = new HashSet<Integer>();
        for (String clusterName : this.compiledFilter.getTargetClusters().keySet()) {
            if (clusterName == null || clusterName.length() == 0) {
                throw new OCommandExecutionException("No cluster or schema class selected in query");
            }
            database.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)clusterName.toLowerCase());
            if (Character.isDigit(clusterName.charAt(0))) {
                for (int clusterId : OStringSerializerHelper.splitIntArray(clusterName)) {
                    if (clusterId == -1) {
                        throw new OCommandExecutionException("Cluster '" + clusterName + "' not found");
                    }
                    clusterIds.add(clusterId);
                }
                continue;
            }
            int clusterId = database.getClusterIdByName(clusterName.toLowerCase());
            if (clusterId == -1) {
                throw new OCommandExecutionException("Cluster '" + clusterName + "' not found");
            }
            clusterIds.add(clusterId);
        }
        int[] clIds = new int[clusterIds.size()];
        int i = 0;
        Iterator i$ = clusterIds.iterator();
        while (i$.hasNext()) {
            int c = (Integer)i$.next();
            clIds[i++] = c;
        }
        ORID[] range = this.getRange();
        this.target = new ORecordIteratorClusters(database, (ODatabaseRecordAbstract)database, clIds).setRange(range[0], range[1]);
    }

    protected void applyLimit() {
        if (this.tempResult != null && this.limit > 0) {
            ArrayList<OIdentifiable> newList = new ArrayList<OIdentifiable>();
            int tot = Math.min(this.limit, this.tempResult.size());
            for (int i = 0; i < tot; ++i) {
                newList.add(this.tempResult.get(i));
            }
            this.tempResult.clear();
            this.tempResult = newList;
        }
    }

    protected void optimize() {
        if (this.compiledFilter == null) {
            return;
        }
        this.optimizeBranch(null, this.compiledFilter.getRootCondition());
    }

    protected Object optimizeFunction(OSQLFunctionRuntime function) {
        boolean precalculate = true;
        for (int i = 0; i < function.configuredParameters.length; ++i) {
            Object res;
            if (function.configuredParameters[i] instanceof OSQLFilterItemField) {
                precalculate = false;
                continue;
            }
            if (!(function.configuredParameters[i] instanceof OSQLFunctionRuntime)) continue;
            function.configuredParameters[i] = res = this.optimizeFunction((OSQLFunctionRuntime)function.configuredParameters[i]);
            if (!(res instanceof OSQLFunctionRuntime) && !(res instanceof OSQLFilterItemField)) continue;
            precalculate = false;
        }
        if (precalculate) {
            return function.execute(null, null);
        }
        return function;
    }

    protected void optimizeBranch(OSQLFilterCondition iParentCondition, OSQLFilterCondition iCondition) {
        if (iCondition == null) {
            return;
        }
        Object left = iCondition.getLeft();
        if (left instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)left);
        } else if (left instanceof OSQLFunctionRuntime) {
            left = this.optimizeFunction((OSQLFunctionRuntime)left);
            iCondition.setLeft(left);
        }
        Object right = iCondition.getRight();
        if (right instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)right);
        } else if (right instanceof OSQLFunctionRuntime) {
            right = this.optimizeFunction((OSQLFunctionRuntime)right);
            iCondition.setRight(right);
        }
        OQueryOperator oper = iCondition.getOperator();
        Boolean result = null;
        if (left instanceof OSQLFilterItemField && right instanceof OSQLFilterItemField && ((OSQLFilterItemField)left).getRoot().equals(((OSQLFilterItemField)right).getRoot())) {
            if (oper instanceof OQueryOperatorEquals) {
                result = Boolean.TRUE;
            } else if (oper instanceof OQueryOperatorNotEquals) {
                result = Boolean.FALSE;
            }
        }
        if (result != null) {
            if (iParentCondition != null) {
                if (iCondition == iParentCondition.getLeft()) {
                    iCondition.setLeft(result);
                } else {
                    iCondition.setRight(result);
                }
            } else if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                this.compiledFilter.setRootCondition(null);
            }
        }
    }

    protected ORID[] getRange() {
        ORID endRange;
        ORID beginRange;
        OSQLFilterCondition rootCondition = this.compiledFilter.getRootCondition();
        if (rootCondition == null) {
            beginRange = this.request instanceof OSQLSynchQuery ? ((OSQLSynchQuery)this.request).getNextPageRID() : null;
            endRange = null;
        } else {
            ORID conditionBeginRange = rootCondition.getBeginRidRange();
            ORID conditionEndRange = rootCondition.getEndRidRange();
            ORID nextPageRid = this.request instanceof OSQLSynchQuery ? ((OSQLSynchQuery)this.request).getNextPageRID() : null;
            beginRange = conditionBeginRange != null && nextPageRid != null ? (conditionBeginRange.compareTo(nextPageRid) > 0 ? conditionBeginRange : nextPageRid) : (conditionBeginRange != null ? conditionBeginRange : nextPageRid);
            endRange = conditionEndRange;
        }
        return new ORID[]{beginRange, endRange};
    }
}

