/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLRevoke
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_REVOKE = "REVOKE";
    private static final String KEYWORD_FROM = "FROM";

    public OCommandExecutorSQLRevoke parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLRevoke.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        this.privilege = 0;
        this.resource = null;
        this.role = null;
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_REVOKE)) {
            throw new OCommandSQLParsingException("Keyword REVOKE not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid privilege", this.text, oldPos);
        }
        this.parsePrivilege(word, oldPos);
        pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        if (pos == -1 || !word.toString().equals("ON")) {
            throw new OCommandSQLParsingException("Keyword ON not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.text, pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid resource", this.text, oldPos);
        }
        this.resource = word.toString();
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_FROM)) {
            throw new OCommandSQLParsingException("Keyword FROM not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.text, pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid role", this.text, oldPos);
        }
        String roleName = word.toString();
        this.role = database.getMetadata().getSecurity().getRole(roleName);
        if (this.role == null) {
            throw new OCommandSQLParsingException("Invalid role: " + roleName);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.role == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not yet been parsed");
        }
        this.role.revoke(this.resource, this.privilege);
        this.role.save();
        return this.role;
    }

    @Override
    public String getSyntax() {
        return "REVOKE <permission> ON <resource> FROM <role>";
    }
}

