/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCommandExecutorSQLSetAware
extends OCommandExecutorSQLAbstract {
    protected static final String KEYWORD_SET = "SET";
    protected int parameterCounter = 0;

    protected int parseSetFields(StringBuilder word, int pos, Map<String, Object> fields) {
        int newPos = pos;
        while (pos != -1 && (fields.size() == 0 || word.toString().equals(","))) {
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false);
            if (newPos == -1) {
                throw new OCommandSQLParsingException("Field name expected", this.text, pos);
            }
            pos = newPos;
            String fieldName = word.toString();
            newPos = OStringParser.jumpWhiteSpaces(this.text, pos);
            if (newPos == -1 || this.text.charAt(newPos) != '=') {
                throw new OCommandSQLParsingException("Character '=' was expected", this.text, pos);
            }
            pos = newPos + 1;
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false, " =><");
            if (pos == -1) {
                throw new OCommandSQLParsingException("Value expected", this.text, pos);
            }
            String fieldValue = word.toString();
            if (fieldValue.startsWith("{") || fieldValue.startsWith("[") || fieldValue.startsWith("[")) {
                newPos = OStringParser.jumpWhiteSpaces(this.text, pos);
                StringBuilder buffer = new StringBuilder();
                newPos = OStringSerializerHelper.parse(this.text, buffer, newPos, -1, OStringSerializerHelper.DEFAULT_FIELD_SEPARATOR, true, OStringSerializerHelper.DEFAULT_IGNORE_CHARS);
                fieldValue = buffer.toString();
            }
            if (fieldValue.endsWith(",")) {
                pos = newPos - 1;
                fieldValue = fieldValue.substring(0, fieldValue.length() - 1);
            } else {
                pos = newPos;
            }
            fields.put(fieldName, this.getFieldValueCountingParameters(fieldValue));
            pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        }
        if (fields.size() == 0) {
            throw new OCommandSQLParsingException("Entries to set <field> = <value> are missed. Example: name = 'Bill', salary = 300.2", this.text, pos);
        }
        return pos;
    }

    protected Object getFieldValueCountingParameters(String fieldValue) {
        if (fieldValue.trim().equals("?")) {
            ++this.parameterCounter;
        }
        return OSQLHelper.parseValue(this, fieldValue, this.context);
    }
}

