/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLTraverse
extends OCommandExecutorSQLResultsetAbstract {
    public static final String KEYWORD_TRAVERSE = "TRAVERSE";
    private OTraverse traverse = new OTraverse();

    @Override
    public OCommandExecutorSQLTraverse parse(OCommandRequest iRequest) {
        super.parse(iRequest);
        int pos = this.parseFields();
        if (pos == -1) {
            throw new OCommandSQLParsingException("Traverse must have the field list. Use " + this.getSyntax());
        }
        int endPosition = this.text.length();
        int endP = this.textUpperCase.indexOf(" LIMIT", this.currentPos);
        if (endP > -1 && endP < endPosition) {
            endPosition = endP;
        }
        this.compiledFilter = OSQLEngine.getInstance().parseFromWhereCondition(this.text.substring(pos, endPosition), this.context);
        this.traverse.predicate(this.compiledFilter);
        this.optimize();
        int n = this.currentPos = this.compiledFilter.currentPos < 0 ? endPosition : this.compiledFilter.currentPos + pos;
        if (this.currentPos > -1 && this.currentPos < this.text.length()) {
            this.currentPos = OStringParser.jump(this.text, this.currentPos, " \r\n");
            StringBuilder word = new StringBuilder();
            while (this.currentPos > -1) {
                this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
                if (this.currentPos <= -1) continue;
                String w = word.toString();
                if (w.equals("LIMIT")) {
                    this.parseLimit(word);
                    continue;
                }
                if (!w.equals("SKIP")) continue;
                this.parseSkip(word);
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        this.traverse.limit(this.limit);
        this.traverse.context(((OCommandRequestText)iRequest).getContext());
        return this;
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (super.assignTarget(iArgs)) {
            this.traverse.target(this.target.iterator());
            return true;
        }
        return false;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (!this.assignTarget(iArgs)) {
            throw new OQueryParsingException("No source found in query: specify class, cluster(s) or single record(s)");
        }
        this.context = this.traverse.getContext();
        Object result = this.traverse.execute();
        Iterator i$ = result.iterator();
        while (i$.hasNext()) {
            OIdentifiable r = (OIdentifiable)i$.next();
            this.addResult(r);
        }
        return this.handleResult();
    }

    @Override
    public boolean hasNext() {
        if (this.target == null) {
            this.assignTarget(null);
        }
        return this.traverse.hasNext();
    }

    @Override
    public OCommandContext getContext() {
        return this.traverse.getContext();
    }

    @Override
    public OIdentifiable next() {
        if (this.target == null) {
            this.assignTarget(null);
        }
        return this.traverse.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this;
    }

    protected int parseFields() {
        int currentPos = 0;
        StringBuilder word = new StringBuilder();
        currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, currentPos, word, true);
        if (!word.toString().equals(KEYWORD_TRAVERSE)) {
            return -1;
        }
        int fromPosition = this.textUpperCase.indexOf(" FROM ", currentPos);
        if (fromPosition == -1) {
            throw new OQueryParsingException("Missed FROM", this.text, currentPos);
        }
        HashSet<String> fields = new HashSet<String>();
        String fieldString = this.text.substring(currentPos, fromPosition).trim();
        if (fieldString.length() > 0) {
            List<String> items = OStringSerializerHelper.smartSplit(fieldString, ',', new char[0]);
            for (String field : items) {
                fields.add(field.trim());
            }
        } else {
            throw new OQueryParsingException("Missed field list to cross in TRAVERSE. Use " + this.getSyntax(), this.text, currentPos);
        }
        currentPos = fromPosition + "FROM".length() + 1;
        this.traverse.fields(fields);
        return currentPos;
    }

    @Override
    public String getSyntax() {
        return "TRAVERSE <field>* FROM <target> [WHERE <filter>]";
    }
}

