/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLTruncateRecord
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_RECORD = "RECORD";
    private Set<String> records = new HashSet<String>();

    public OCommandExecutorSQLTruncateRecord parse(OCommandRequest iRequest) {
        OCommandExecutorSQLTruncateRecord.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
            throw new OCommandSQLParsingException("Keyword TRUNCATE not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_RECORD)) {
            throw new OCommandSQLParsingException("Keyword RECORD not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.text, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Expected one or more records. Use " + this.getSyntax(), this.text, oldPos);
        }
        if (word.charAt(0) == '[') {
            OStringSerializerHelper.getCollection(this.text, oldPos, this.records);
        } else {
            this.records.add(word.toString());
        }
        if (this.records.isEmpty()) {
            throw new OCommandSQLParsingException("Missed record(s). Use " + this.getSyntax(), this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.records.isEmpty()) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLTruncateRecord.getDatabase();
        for (String rec : this.records) {
            try {
                ORecordId rid = new ORecordId(rec);
                database.getStorage().deleteRecord(rid, -1, 0, null);
            }
            catch (Throwable e) {
                throw new OCommandExecutionException("Error on executing command", e);
            }
        }
        return this.records.size();
    }

    @Override
    public String getSyntax() {
        return "TRUNCATE RECORD <rid>*";
    }
}

