/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLUpdate
extends OCommandExecutorSQLSetAware
implements OCommandResultListener {
    public static final String KEYWORD_UPDATE = "UPDATE";
    private static final String KEYWORD_ADD = "ADD";
    private static final String KEYWORD_PUT = "PUT";
    private static final String KEYWORD_REMOVE = "REMOVE";
    private static final String KEYWORD_INCREMENT = "INCREMENT";
    private Map<String, Object> setEntries = new LinkedHashMap<String, Object>();
    private Map<String, Object> addEntries = new LinkedHashMap<String, Object>();
    private Map<String, OPair<String, Object>> putEntries = new LinkedHashMap<String, OPair<String, Object>>();
    private Map<String, Object> removeEntries = new LinkedHashMap<String, Object>();
    private Map<String, Number> incrementEntries = new LinkedHashMap<String, Number>();
    private OQuery<?> query;
    private int recordCount = 0;
    private String subjectName;
    private static final Object EMPTY_VALUE = new Object();
    private OCommandParameters parameters;

    public OCommandExecutorSQLUpdate parse(OCommandRequest iRequest) {
        String additionalStatement;
        ODatabaseRecord database = OCommandExecutorSQLUpdate.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        this.setEntries.clear();
        this.addEntries.clear();
        this.putEntries.clear();
        this.removeEntries.clear();
        this.incrementEntries.clear();
        this.query = null;
        this.recordCount = 0;
        StringBuilder word = new StringBuilder();
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, 0, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_UPDATE)) {
            throw new OCommandSQLParsingException("Keyword UPDATE not found. Use " + this.getSyntax(), this.text, 0);
        }
        int newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        if (newPos == -1) {
            throw new OCommandSQLParsingException("Invalid target. Use " + this.getSyntax(), this.text, pos);
        }
        pos = newPos;
        this.subjectName = word.toString();
        newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        if (!(newPos != -1 && (word.toString().equals("SET") || word.toString().equals(KEYWORD_ADD) || word.toString().equals(KEYWORD_PUT) || word.toString().equals(KEYWORD_REMOVE) || word.toString().equals(KEYWORD_INCREMENT)))) {
            throw new OCommandSQLParsingException("Expected keyword SET,ADD,PUT,REMOVE or INCREMENT. Use " + this.getSyntax(), this.text, pos);
        }
        pos = newPos;
        while (pos != -1 && !word.toString().equals("WHERE")) {
            if (word.toString().equals("SET")) {
                pos = this.parseSetFields(word, pos, this.setEntries);
                continue;
            }
            if (word.toString().equals(KEYWORD_ADD)) {
                pos = this.parseAddFields(word, pos);
                continue;
            }
            if (word.toString().equals(KEYWORD_PUT)) {
                pos = this.parsePutFields(word, pos);
                continue;
            }
            if (word.toString().equals(KEYWORD_REMOVE)) {
                pos = this.parseRemoveFields(word, pos);
                continue;
            }
            if (!word.toString().equals(KEYWORD_INCREMENT)) break;
            pos = this.parseIncrementFields(word, pos);
        }
        this.query = (additionalStatement = word.toString()).equals("WHERE") || additionalStatement.equals("LIMIT") ? new OSQLAsynchQuery("select from " + this.subjectName + " " + additionalStatement + " " + this.text.substring(pos), this) : new OSQLAsynchQuery("select from " + this.subjectName, this);
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.subjectName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        this.parameters = new OCommandParameters(iArgs);
        HashMap<Integer, Object> queryArgs = new HashMap<Integer, Object>();
        for (int i = this.parameterCounter; i < this.parameters.size(); ++i) {
            if (this.parameters.getByName(i) == null) continue;
            queryArgs.put(i - this.parameterCounter, this.parameters.getByName(i));
        }
        OCommandExecutorSQLUpdate.getDatabase().query(this.query, queryArgs);
        return this.recordCount;
    }

    @Override
    public boolean result(Object iRecord) {
        Map map;
        Object v;
        Object fieldValue;
        Collection<Object> coll;
        ODocument record = (ODocument)iRecord;
        boolean recordUpdated = false;
        this.parameters.reset();
        if (!this.setEntries.isEmpty()) {
            OSQLHelper.bindParameters(record, this.setEntries, this.parameters);
            recordUpdated = true;
        }
        for (Map.Entry<String, Number> entry : this.incrementEntries.entrySet()) {
            Number prevValue = (Number)record.field(entry.getKey());
            if (prevValue == null) {
                record.field(entry.getKey(), entry.getValue());
            } else {
                record.field(entry.getKey(), OType.increment(prevValue, entry.getValue()));
            }
            recordUpdated = true;
        }
        for (Map.Entry<String, Object> entry : this.addEntries.entrySet()) {
            coll = null;
            if (!record.containsField(entry.getKey())) {
                OProperty prop;
                if (record.getSchemaClass() != null && (prop = record.getSchemaClass().getProperty(entry.getKey())) != null && prop.getType() == OType.LINKSET) {
                    coll = new HashSet();
                }
                if (coll == null) {
                    coll = new ArrayList();
                }
                record.field(entry.getKey(), coll);
            } else {
                fieldValue = record.field(entry.getKey());
                if (!(fieldValue instanceof Collection)) continue;
                coll = (Collection)fieldValue;
            }
            v = entry.getValue();
            if (v instanceof OSQLFilterItem) {
                v = ((OSQLFilterItem)v).getValue(record, this.context);
            } else if (v instanceof OSQLFunctionRuntime) {
                v = ((OSQLFunctionRuntime)v).execute(record, this);
            }
            coll.add(v);
            recordUpdated = true;
        }
        for (Map.Entry<String, OPair<String, Object>> entry : this.putEntries.entrySet()) {
            fieldValue = record.field(entry.getKey());
            if (fieldValue == null) {
                OProperty property;
                if (record.getSchemaClass() != null && (property = record.getSchemaClass().getProperty(entry.getKey())) != null && property.getType() != null && !property.getType().equals((Object)OType.EMBEDDEDMAP) && !property.getType().equals((Object)OType.LINKMAP)) {
                    throw new OCommandExecutionException("field " + entry.getKey() + " is not defined as a map");
                }
                fieldValue = new HashMap();
                record.field(entry.getKey(), fieldValue);
            }
            if (!(fieldValue instanceof Map)) continue;
            map = (Map)fieldValue;
            OPair<String, Object> pair = entry.getValue();
            if (pair.getValue() instanceof OSQLFilterItem) {
                pair.setValue(((OSQLFilterItem)pair.getValue()).getValue(record, null));
            } else if (pair.getValue() instanceof OSQLFunctionRuntime) {
                v = ((OSQLFunctionRuntime)pair.getValue()).execute(record, this);
            }
            map.put(pair.getKey(), pair.getValue());
            recordUpdated = true;
        }
        for (Map.Entry<String, Object> entry : this.removeEntries.entrySet()) {
            v = entry.getValue();
            if (v == EMPTY_VALUE) {
                record.removeField(entry.getKey());
                recordUpdated = true;
                continue;
            }
            fieldValue = record.field(entry.getKey());
            if (fieldValue instanceof Collection) {
                coll = (Collection)fieldValue;
                if (!coll.remove(v)) continue;
                recordUpdated = true;
                continue;
            }
            if (!(fieldValue instanceof Map) || (map = (Map)fieldValue).remove(v) == null) continue;
            recordUpdated = true;
        }
        if (recordUpdated) {
            record.setDirty();
            record.save();
            ++this.recordCount;
        }
        return true;
    }

    private int parseAddFields(StringBuilder word, int pos) {
        int newPos = pos;
        while (pos != -1 && (this.addEntries.size() == 0 || word.toString().equals(",")) && !word.toString().equals("WHERE")) {
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false);
            if (newPos == -1) {
                throw new OCommandSQLParsingException("Field name expected. Use " + this.getSyntax(), this.text, pos);
            }
            pos = newPos;
            String fieldName = word.toString();
            newPos = OStringParser.jumpWhiteSpaces(this.text, pos);
            if (newPos == -1 || this.text.charAt(newPos) != '=') {
                throw new OCommandSQLParsingException("Character '=' was expected. Use " + this.getSyntax(), this.text, pos);
            }
            pos = newPos;
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos + 1, word, false, " =><");
            if (pos == -1) {
                throw new OCommandSQLParsingException("Value expected. Use " + this.getSyntax(), this.text, pos);
            }
            String fieldValue = word.toString();
            if (fieldValue.endsWith(",")) {
                pos = newPos - 1;
                fieldValue = fieldValue.substring(0, fieldValue.length() - 1);
            } else {
                pos = newPos;
            }
            this.addEntries.put(fieldName, this.getFieldValueCountingParameters(fieldValue));
            pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        }
        if (this.addEntries.size() == 0) {
            throw new OCommandSQLParsingException("Entries to add <field> = <value> are missed. Example: name = 'Bill', salary = 300.2. Use " + this.getSyntax(), this.text, pos);
        }
        return pos;
    }

    private int parsePutFields(StringBuilder word, int pos) {
        int newPos = pos;
        while (pos != -1 && (this.setEntries.size() == 0 || word.toString().equals(",")) && !word.toString().equals("WHERE")) {
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false);
            if (newPos == -1) {
                throw new OCommandSQLParsingException("Field name expected. Use " + this.getSyntax(), this.text, pos);
            }
            pos = newPos;
            String fieldName = word.toString();
            newPos = OStringParser.jumpWhiteSpaces(this.text, pos);
            if (newPos == -1 || this.text.charAt(newPos) != '=') {
                throw new OCommandSQLParsingException("Character '=' was expected. Use " + this.getSyntax(), this.text, pos);
            }
            pos = newPos;
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos + 1, word, false, " =><,");
            if (pos == -1) {
                throw new OCommandSQLParsingException("Key expected. Use " + this.getSyntax(), this.text, pos);
            }
            String fieldKey = word.toString();
            if (fieldKey.endsWith(",")) {
                pos = newPos + 1;
                fieldKey = fieldKey.substring(0, fieldKey.length() - 1);
            } else {
                pos = newPos;
                if ((newPos = OStringParser.jumpWhiteSpaces(this.text, pos)) == -1 || this.text.charAt(pos) != ',') {
                    throw new OCommandSQLParsingException("',' expected. Use " + this.getSyntax(), this.text, pos);
                }
                pos = newPos;
            }
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos + 1, word, false, " =><,");
            if (pos == -1) {
                throw new OCommandSQLParsingException("Value expected. Use " + this.getSyntax(), this.text, pos);
            }
            String fieldValue = word.toString();
            if (fieldValue.endsWith(",")) {
                pos = newPos - 1;
                fieldValue = fieldValue.substring(0, fieldValue.length() - 1);
            } else {
                pos = newPos;
            }
            this.putEntries.put(fieldName, new OPair<String, Object>((String)this.getFieldValueCountingParameters(fieldKey), this.getFieldValueCountingParameters(fieldValue)));
            pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        }
        if (this.putEntries.size() == 0) {
            throw new OCommandSQLParsingException("Entries to put <field> = <key>, <value> are missed. Example: name = 'Bill', 30. Use " + this.getSyntax(), this.text, pos);
        }
        return pos;
    }

    private int parseRemoveFields(StringBuilder word, int pos) {
        int newPos = pos;
        while (pos != -1 && (this.removeEntries.size() == 0 || word.toString().equals(",")) && !word.toString().equals("WHERE")) {
            Object value;
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false);
            if (newPos == -1) {
                throw new OCommandSQLParsingException("Field name expected. Use " + this.getSyntax(), this.text, pos);
            }
            String fieldName = word.toString();
            pos = OStringParser.jumpWhiteSpaces(this.text, newPos);
            if (pos > -1 && this.text.charAt(pos) == '=') {
                if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos + 1, word, false, " =><,")) == -1) {
                    throw new OCommandSQLParsingException("Value expected. Use " + this.getSyntax(), this.text, pos);
                }
                String fieldValue = word.toString();
                if (fieldValue.endsWith(",")) {
                    pos = newPos - 1;
                    fieldValue = fieldValue.substring(0, fieldValue.length() - 1);
                } else {
                    pos = newPos;
                }
                value = this.getFieldValueCountingParameters(fieldValue);
            } else {
                value = EMPTY_VALUE;
            }
            this.removeEntries.put(fieldName, value);
            pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        }
        if (this.removeEntries.size() == 0) {
            throw new OCommandSQLParsingException("Field(s) to remove are missed. Example: name, salary. Use " + this.getSyntax(), this.text, pos);
        }
        return pos;
    }

    private int parseIncrementFields(StringBuilder word, int pos) {
        int newPos = pos;
        while (pos != -1 && (this.incrementEntries.size() == 0 || word.toString().equals(",")) && !word.toString().equals("WHERE")) {
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false);
            if (newPos == -1) {
                throw new OCommandSQLParsingException("Field name expected. Use " + this.getSyntax(), this.text, pos);
            }
            pos = newPos;
            String fieldName = word.toString();
            newPos = OStringParser.jumpWhiteSpaces(this.text, pos);
            if (newPos == -1 || this.text.charAt(newPos) != '=') {
                throw new OCommandSQLParsingException("Character '=' was expected. Use " + this.getSyntax(), this.text, pos);
            }
            pos = newPos;
            newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos + 1, word, false, " =><");
            if (pos == -1) {
                throw new OCommandSQLParsingException("Value expected. Use " + this.getSyntax(), this.text, pos);
            }
            String fieldValue = word.toString();
            if (fieldValue.endsWith(",")) {
                pos = newPos - 1;
                fieldValue = fieldValue.substring(0, fieldValue.length() - 1);
            } else {
                pos = newPos;
            }
            this.incrementEntries.put(fieldName, (Number)this.getFieldValueCountingParameters(fieldValue));
            pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true);
        }
        if (this.incrementEntries.size() == 0) {
            throw new OCommandSQLParsingException("Entries to increment <field> = <value> are missed. Example: salary = -100. Use " + this.getSyntax(), this.text, pos);
        }
        return pos;
    }

    @Override
    public String getSyntax() {
        return "UPDATE <class>|cluster:<cluster>> [SET|ADD|PUT|REMOVE|INCREMENT] [[,] <field-name> = <field-value>]* [WHERE <conditions>]";
    }
}

