/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.ODynamicSQLElementFactory;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLEngine {
    private static Set<OSQLFunctionFactory> FUNCTION_FACTORIES = null;
    private static Set<OCommandExecutorSQLFactory> EXECUTOR_FACTORIES = null;
    private static Set<OQueryOperatorFactory> OPERATOR_FACTORIES = null;
    private static OQueryOperator[] SORTED_OPERATORS = null;
    protected static final OSQLEngine INSTANCE = new OSQLEngine();

    protected OSQLEngine() {
    }

    public synchronized OQueryOperator[] getRecordOperators() {
        boolean added;
        if (SORTED_OPERATORS != null) {
            return SORTED_OPERATORS;
        }
        Iterator<OQueryOperatorFactory> ite = OSQLEngine.getOperatorFactories();
        ArrayList<OQueryOperator> operators = new ArrayList<OQueryOperator>();
        while (ite.hasNext()) {
            OQueryOperatorFactory factory = ite.next();
            operators.addAll(factory.getOperators());
        }
        ArrayList<OQueryOperator> sorted = new ArrayList<OQueryOperator>();
        LinkedHashSet<Pair> pairs = new LinkedHashSet<Pair>();
        for (OQueryOperator ca : operators) {
            for (OQueryOperator cb : operators) {
                if (ca == cb) continue;
                switch (ca.compare(cb)) {
                    case BEFORE: {
                        pairs.add(new Pair(ca, cb));
                        break;
                    }
                    case AFTER: {
                        pairs.add(new Pair(cb, ca));
                    }
                }
                switch (cb.compare(ca)) {
                    case BEFORE: {
                        pairs.add(new Pair(cb, ca));
                        break;
                    }
                    case AFTER: {
                        pairs.add(new Pair(ca, cb));
                    }
                }
            }
        }
        do {
            added = false;
            Iterator it = operators.iterator();
            block12: while (it.hasNext()) {
                OQueryOperator candidate = (OQueryOperator)it.next();
                for (Pair pair : pairs) {
                    if (pair.after != candidate) continue;
                    continue block12;
                }
                sorted.add(candidate);
                it.remove();
                Iterator itp = pairs.iterator();
                while (itp.hasNext()) {
                    if (((Pair)itp.next()).before != candidate) continue;
                    itp.remove();
                }
                added = true;
            }
        } while (added);
        if (!operators.isEmpty()) {
            throw new OException("Unvalid sorting. " + OCollections.toString(pairs));
        }
        SORTED_OPERATORS = sorted.toArray(new OQueryOperator[sorted.size()]);
        return SORTED_OPERATORS;
    }

    public static void registerOperator(OQueryOperator iOperator) {
        ODynamicSQLElementFactory.OPERATORS.add(iOperator);
        SORTED_OPERATORS = null;
    }

    public void registerFunction(String iName, OSQLFunction iFunction) {
        ODynamicSQLElementFactory.FUNCTIONS.put(iName.toUpperCase(Locale.ENGLISH), iFunction);
    }

    public void registerFunction(String iName, Class<? extends OSQLFunction> iFunctionClass) {
        ODynamicSQLElementFactory.FUNCTIONS.put(iName.toUpperCase(Locale.ENGLISH), iFunctionClass);
    }

    public OSQLFunction getFunction(String iFunctionName) {
        iFunctionName = iFunctionName.toUpperCase(Locale.ENGLISH);
        Iterator<OSQLFunctionFactory> ite = OSQLEngine.getFunctionFactories();
        while (ite.hasNext()) {
            OSQLFunctionFactory factory = ite.next();
            if (!factory.getFunctionNames().contains(iFunctionName)) continue;
            return factory.createFunction(iFunctionName);
        }
        throw new OCommandSQLParsingException("No function for name " + iFunctionName + ", available names are : " + OCollections.toString(OSQLEngine.getFunctionNames()));
    }

    public void unregisterFunction(String iName) {
        iName = iName.toUpperCase(Locale.ENGLISH);
        ODynamicSQLElementFactory.FUNCTIONS.remove(iName);
    }

    public static synchronized Iterator<OSQLFunctionFactory> getFunctionFactories() {
        if (FUNCTION_FACTORIES == null) {
            Iterator<OSQLFunctionFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OSQLFunctionFactory.class);
            HashSet<OSQLFunctionFactory> factories = new HashSet<OSQLFunctionFactory>();
            while (ite.hasNext()) {
                factories.add(ite.next());
            }
            FUNCTION_FACTORIES = Collections.unmodifiableSet(factories);
        }
        return FUNCTION_FACTORIES.iterator();
    }

    public static synchronized Iterator<OQueryOperatorFactory> getOperatorFactories() {
        if (OPERATOR_FACTORIES == null) {
            Iterator<OQueryOperatorFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OQueryOperatorFactory.class);
            HashSet<OQueryOperatorFactory> factories = new HashSet<OQueryOperatorFactory>();
            while (ite.hasNext()) {
                factories.add(ite.next());
            }
            OPERATOR_FACTORIES = Collections.unmodifiableSet(factories);
        }
        return OPERATOR_FACTORIES.iterator();
    }

    public static synchronized Iterator<OCommandExecutorSQLFactory> getCommandFactories() {
        if (EXECUTOR_FACTORIES == null) {
            Iterator<OCommandExecutorSQLFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OCommandExecutorSQLFactory.class);
            HashSet<OCommandExecutorSQLFactory> factories = new HashSet<OCommandExecutorSQLFactory>();
            while (ite.hasNext()) {
                factories.add(ite.next());
            }
            EXECUTOR_FACTORIES = Collections.unmodifiableSet(factories);
        }
        return EXECUTOR_FACTORIES.iterator();
    }

    public static Set<String> getFunctionNames() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OSQLFunctionFactory> ite = OSQLEngine.getFunctionFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getFunctionNames());
        }
        return types;
    }

    public static Set<String> getCommandNames() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OCommandExecutorSQLFactory> ite = OSQLEngine.getCommandFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getCommandNames());
        }
        return types;
    }

    public static synchronized void scanForPlugins() {
        FUNCTION_FACTORIES = null;
    }

    public OCommandExecutorSQLAbstract getCommand(String candidate) {
        Set<String> names = OSQLEngine.getCommandNames();
        String commandName = candidate;
        boolean found = names.contains(commandName);
        int pos = -1;
        while (!found && (pos = candidate.indexOf(32, pos + 1)) > -1) {
            commandName = candidate.substring(0, pos);
            found = names.contains(commandName);
        }
        if (found) {
            Iterator<OCommandExecutorSQLFactory> ite = OSQLEngine.getCommandFactories();
            while (ite.hasNext()) {
                OCommandExecutorSQLFactory factory = ite.next();
                if (!factory.getCommandNames().contains(commandName)) continue;
                return factory.createCommand(commandName);
            }
        }
        return null;
    }

    public OSQLFilter parseFromWhereCondition(String iText, OCommandContext iContext) {
        return new OSQLFilter(iText, iContext);
    }

    public static OSQLEngine getInstance() {
        return INSTANCE;
    }

    private static final class Pair {
        final OQueryOperator before;
        final OQueryOperator after;

        public Pair(OQueryOperator before, OQueryOperator after) {
            this.before = before;
            this.after = after;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                Pair that = (Pair)obj;
                return this.before == that.before && this.after == that.after;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.before) + 31 * System.identityHashCode(this.after);
        }

        public String toString() {
            return this.before + " > " + this.after;
        }
    }
}

