/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorContainsValue
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorContainsValue() {
        super("CONTAINSVALUE", 5, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        OSQLFilterCondition condition = iCondition.getLeft() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getLeft() : (iCondition.getRight() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getRight() : null);
        if (iLeft instanceof Map) {
            Map map = (Map)iLeft;
            if (condition == null) return map.containsValue(iRight);
            for (Object v : map.values()) {
                Object object = this.loadIfNeed(v);
                if (!((Boolean)condition.evaluate((ORecordSchemaAware)object, iContext)).booleanValue()) continue;
                return true;
            }
            return false;
        } else {
            Iterator i$;
            if (!(iRight instanceof Map)) return false;
            Map map = (Map)iRight;
            if (condition == null || !(i$ = map.values().iterator()).hasNext()) return false;
            Object v = i$.next();
            Object object = this.loadIfNeed(v);
            if (!((Boolean)condition.evaluate((ORecordSchemaAware)object, iContext)).booleanValue()) return map.containsValue(iLeft);
            return true;
        }
    }

    private Object loadIfNeed(Object o) {
        ORecord record = (ORecord)o;
        if (record.getRecord().getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                o = record.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OException("Error during loading record with id : " + record.getIdentity());
            }
        }
        return o;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (!(iRight instanceof OSQLFilterCondition) && !(iLeft instanceof OSQLFilterCondition)) {
            return OIndexReuseType.INDEX_METHOD;
        }
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public Collection<OIdentifiable> executeIndexQuery(OIndex<?> index, List<Object> keyParams, int fetchLimit) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (!(index.getDefinition() instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)index.getDefinition()).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.VALUE) {
            return null;
        }
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            if (indexResult instanceof Collection) {
                return (Collection)indexResult;
            }
            return indexResult == null ? null : Collections.singletonList((OIdentifiable)indexResult);
        }
        return null;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

