/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorEquals
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorEquals() {
        super("=", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        return OQueryOperatorEquals.equals(iLeft, iRight);
    }

    public static boolean equals(Object iLeft, Object iRight) {
        if (iLeft instanceof ORecord) {
            return OQueryOperatorEquals.comparesValues(iRight, (ORecord)iLeft);
        }
        if (iRight instanceof ORecord) {
            return OQueryOperatorEquals.comparesValues(iLeft, (ORecord)iRight);
        }
        Object right = OType.convert(iRight, iLeft.getClass());
        if (right == null) {
            return false;
        }
        return iLeft.equals(right);
    }

    protected static boolean comparesValues(Object iValue, ORecord<?> iRecord) {
        ORID other = iRecord.getIdentity();
        if (!other.isPersistent() && iRecord instanceof ODocument) {
            Object fieldValue;
            String[] firstFieldName = ((ODocument)iRecord).fieldNames();
            if (firstFieldName.length > 0 && (fieldValue = ((ODocument)iRecord).field(firstFieldName[0])) != null) {
                return fieldValue.equals(iValue);
            }
            return false;
        }
        return other.equals(iValue);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iLeft instanceof OIdentifiable && iRight instanceof OIdentifiable) {
            return OIndexReuseType.NO_INDEX;
        }
        if (iRight == null || iLeft == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Collection<OIdentifiable> executeIndexQuery(OIndex<?> index, List<Object> keyParams, int fetchLimit) {
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            if (indexResult instanceof Collection) {
                return (Collection)indexResult;
            }
            if (indexResult == null) {
                return null;
            }
            return indexResult == null ? null : Collections.singletonList((OIdentifiable)indexResult);
        }
        Object keyOne = indexDefinition.createValue(keyParams);
        if (keyOne == null) {
            return null;
        }
        Object keyTwo = indexDefinition.createValue(keyParams);
        Collection<OIdentifiable> result = fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true);
        if (OProfiler.getInstance().isRecording()) {
            OProfiler.getInstance().updateCounter("Query.compositeIndexUsage", 1L);
            OProfiler.getInstance().updateCounter("Query.compositeIndexUsage." + indexDefinition.getParamCount(), 1L);
        }
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof ORID) {
                return (ORID)iRight;
            }
            if (iRight instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iRight).getValue(null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iRight).getValue(null, null);
            }
        }
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            if (iLeft instanceof ORID) {
                return (ORID)iLeft;
            }
            if (iLeft instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iLeft).getValue(null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iLeft).getValue(null, null);
            }
        }
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return this.getBeginRidRange(iLeft, iRight);
    }
}

