/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorIn
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorIn() {
        super("IN", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (!(iLeft instanceof Collection)) break block8;
                        Collection sourceCollection = (Collection)iLeft;
                        if (iRight instanceof Collection) {
                            Collection collectionToMatch = (Collection)iRight;
                            for (Object o1 : sourceCollection) {
                                for (Object o2 : collectionToMatch) {
                                    if (!OQueryOperatorEquals.equals(o1, o2)) continue;
                                    return true;
                                }
                            }
                        } else {
                            for (Object o : sourceCollection) {
                                if (!OQueryOperatorEquals.equals(iRight, o)) continue;
                                return true;
                            }
                        }
                        break block9;
                    }
                    if (!(iRight instanceof Collection)) break block10;
                    Collection sourceCollection = (Collection)iRight;
                    for (Object o : sourceCollection) {
                        if (!OQueryOperatorEquals.equals(iLeft, o)) continue;
                        return true;
                    }
                    break block9;
                }
                if (!iLeft.getClass().isArray()) break block11;
                for (Object o : (Object[])iLeft) {
                    if (!OQueryOperatorEquals.equals(iRight, o)) continue;
                    return true;
                }
                break block9;
            }
            if (!iRight.getClass().isArray()) break block9;
            for (Object o : (Object[])iRight) {
                if (!OQueryOperatorEquals.equals(iLeft, o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Collection<OIdentifiable> executeIndexQuery(OIndex<?> index, List<Object> keyParams, int fetchLimit) {
        Collection<OIdentifiable> result;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            List inParams = (List)keyParams.get(0);
            ArrayList<Object> inKeys = new ArrayList<Object>();
            boolean containsNotCompatibleKey = false;
            for (Object keyValue : inParams) {
                Object key = indexDefinition.createValue(OSQLHelper.getValue(keyValue));
                if (key == null) {
                    containsNotCompatibleKey = true;
                    break;
                }
                inKeys.add(key);
            }
            if (containsNotCompatibleKey) {
                return null;
            }
            result = fetchLimit > -1 ? index.getValues(inKeys, fetchLimit) : index.getValues(inKeys);
        } else {
            return null;
        }
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        int ridSize;
        Iterable<Object> ridCollection;
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            ridCollection = OMultiValue.getMultiValueIterable(iLeft);
            ridSize = OMultiValue.getSize(iLeft);
        } else if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            ridCollection = OMultiValue.getMultiValueIterable(iRight);
            ridSize = OMultiValue.getSize(iRight);
        } else {
            return null;
        }
        List<ORID> rids = this.addRangeResults(ridCollection, ridSize);
        return rids == null ? null : Collections.min(rids);
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        int ridSize;
        Iterable<Object> ridCollection;
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            ridCollection = OMultiValue.getMultiValueIterable(iLeft);
            ridSize = OMultiValue.getSize(iLeft);
        } else if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            ridCollection = OMultiValue.getMultiValueIterable(iRight);
            ridSize = OMultiValue.getSize(iRight);
        } else {
            return null;
        }
        List<ORID> rids = this.addRangeResults(ridCollection, ridSize);
        return rids == null ? null : Collections.max(rids);
    }

    protected List<ORID> addRangeResults(Iterable<?> ridCollection, int ridSize) {
        ArrayList<ORID> rids = null;
        for (Object rid : ridCollection) {
            ORID r;
            if (rid instanceof OSQLFilterItemParameter) {
                rid = ((OSQLFilterItemParameter)rid).getValue(null, null);
            }
            if (!(rid instanceof OIdentifiable) || !(r = ((OIdentifiable)rid).getIdentity()).isPersistent()) continue;
            if (rids == null) {
                rids = new ArrayList<ORID>(ridSize);
            }
            rids.add(r);
        }
        return rids;
    }
}

