/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator.math;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;

public class OQueryOperatorMultiply
extends OQueryOperator {
    public OQueryOperatorMultiply() {
        super("*", 10, false);
    }

    public Object evaluateRecord(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iRight == null || iLeft == null) {
            return null;
        }
        if (iLeft instanceof Number && iRight instanceof Number) {
            Number l = (Number)iLeft;
            Number r = (Number)iRight;
            if (l instanceof Integer) {
                return l.intValue() * r.intValue();
            }
            if (l instanceof Long) {
                return l.longValue() * r.longValue();
            }
            if (l instanceof Short) {
                return l.shortValue() * r.shortValue();
            }
            if (l instanceof Float) {
                return Float.valueOf(l.floatValue() * r.floatValue());
            }
            if (l instanceof Double) {
                return l.doubleValue() * r.doubleValue();
            }
        }
        return null;
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

