/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ORawBuffer
implements Externalizable {
    public byte[] buffer;
    public int version;
    public byte recordType;

    public ORawBuffer() {
    }

    public ORawBuffer(byte[] buffer, int version, byte recordType) {
        this.buffer = buffer;
        this.version = version;
        this.recordType = recordType;
    }

    public void readExternal(ObjectInput iInput) throws IOException, ClassNotFoundException {
        int bufferLenght = iInput.readInt();
        if (bufferLenght > 0) {
            this.buffer = new byte[bufferLenght];
            iInput.read(this.buffer);
        } else {
            this.buffer = null;
        }
        this.version = iInput.readInt();
        this.recordType = iInput.readByte();
    }

    public void writeExternal(ObjectOutput iOutput) throws IOException {
        int bufferLenght = this.buffer != null ? this.buffer.length : 0;
        iOutput.writeInt(bufferLenght);
        if (bufferLenght > 0) {
            iOutput.write(this.buffer);
        }
        iOutput.writeInt(this.version);
        iOutput.write(this.recordType);
    }

    public String toString() {
        return "size:" + (this.buffer != null ? Integer.valueOf(this.buffer.length) : "empty");
    }
}

