/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterHoleConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocalHole;
import com.orientechnologies.orient.core.storage.impl.local.OMultiFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.File;
import java.io.IOException;

public class OClusterLocal
extends OSharedResourceAdaptive
implements OCluster {
    public static final int RECORD_SIZE = 15;
    public static final String TYPE = "PHYSICAL";
    private static final String DEF_EXTENSION = ".ocl";
    private static final int DEF_SIZE = 1000000;
    private OMultiFileSegment fileSegment;
    private int id;
    private long beginOffsetData = -1L;
    private long endOffsetData = -1L;
    protected OClusterLocalHole holeSegment;
    private OStoragePhysicalClusterConfiguration config;
    private OStorageLocal storage;
    private String name;

    public OClusterLocal() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
    }

    public void configure(OStorage iStorage, OStorageClusterConfiguration iConfig) throws IOException {
        this.config = (OStoragePhysicalClusterConfiguration)iConfig;
        this.init(iStorage, this.config.getId(), this.config.getName(), this.config.getLocation(), this.config.getDataSegmentId(), new Object[0]);
    }

    public void configure(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) throws IOException {
        this.config = new OStoragePhysicalClusterConfiguration(iStorage.getConfiguration(), iId, iDataSegmentId);
        this.config.name = iClusterName;
        this.init(iStorage, iId, iClusterName, iLocation, iDataSegmentId, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(int iStartSize) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (iStartSize == -1) {
                iStartSize = 1000000;
            }
            if (this.config.root.clusters.size() <= this.config.id) {
                this.config.root.clusters.add(this.config);
            } else {
                this.config.root.clusters.set(this.config.id, this.config);
            }
            this.fileSegment.create(iStartSize);
            this.holeSegment.create();
            this.fileSegment.files[0].writeHeaderLong(0, this.beginOffsetData);
            this.fileSegment.files[0].writeHeaderLong(8, this.beginOffsetData);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileSegment.open();
            this.holeSegment.open();
            this.beginOffsetData = this.fileSegment.files[0].readHeaderLong(0);
            this.endOffsetData = this.fileSegment.files[0].readHeaderLong(8);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileSegment.close();
            this.holeSegment.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.truncate();
            for (OFile f : this.fileSegment.files) {
                OMMapManager.removeFile(f);
                f.delete();
            }
            this.fileSegment.files = null;
            this.holeSegment.delete();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            long begin = this.getFirstEntryPosition();
            if (begin > -1L) {
                long end = this.getLastEntryPosition();
                OPhysicalPosition ppos = new OPhysicalPosition();
                ppos.clusterPosition = begin;
                while (ppos.clusterPosition <= end) {
                    this.getPhysicalPosition(ppos);
                    if (this.storage.checkForRecordValidity(ppos)) {
                        this.storage.getDataSegmentById(ppos.dataSegmentId).deleteRecord(ppos.dataSegmentPos);
                    }
                    ++ppos.clusterPosition;
                }
            }
            this.fileSegment.truncate();
            this.holeSegment.truncate();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        this.acquireExclusiveLock();
        try {
            switch (iAttribute) {
                case NAME: {
                    this.setNameInternal(stringValue);
                    return;
                }
                case DATASEGMENT: {
                    this.setDataSegmentInternal(stringValue);
                    return;
                }
            }
            return;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        long filePosition = iPPosition.clusterPosition * 15L;
        this.acquireSharedLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(filePosition);
            OFile f = this.fileSegment.files[(int)pos[0]];
            long p = pos[1];
            iPPosition.dataSegmentId = f.readShort(p);
            iPPosition.dataSegmentPos = f.readLong(p += 2L);
            iPPosition.recordType = f.readByte(p += 8L);
            iPPosition.recordVersion = f.readInt(++p);
            OPhysicalPosition oPhysicalPosition = iPPosition;
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataSegmentPosition(long iPosition, int iDataSegmentId, long iDataSegmentPosition) throws IOException {
        iPosition *= 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(iPosition);
            OFile f = this.fileSegment.files[(int)pos[0]];
            long p = pos[1];
            f.writeShort(p, (short)iDataSegmentId);
            f.writeLong(p += 2L, iDataSegmentPosition);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVersion(long iPosition, int iVersion) throws IOException {
        iPosition *= 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(iPosition);
            this.fileSegment.files[(int)pos[0]].writeInt(pos[1] + 2L + 8L + 1L, iVersion);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecordType(long iPosition, byte iRecordType) throws IOException {
        iPosition *= 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(iPosition);
            this.fileSegment.files[(int)pos[0]].writeByte(pos[1] + 2L + 8L, iRecordType);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhysicalPosition(long iPosition) throws IOException {
        long position = iPosition * 15L;
        this.acquireExclusiveLock();
        try {
            long[] pos = this.fileSegment.getRelativePosition(position);
            OFile file = this.fileSegment.files[(int)pos[0]];
            long p = pos[1] + 2L + 8L + 1L;
            this.holeSegment.pushPosition(position);
            int version = file.readInt(p);
            file.writeInt(p, (version + 1) * -1);
            this.updateBoundsAfterDeletion(iPosition);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHole(long iPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            boolean bl = this.holeSegment.removeEntryWithPosition(iPosition * 15L);
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataSegmentId() {
        this.acquireSharedLock();
        try {
            int n = this.config.getDataSegmentId();
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhysicalPosition(OPhysicalPosition iPPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            boolean recycled;
            long[] pos;
            long offset = this.holeSegment.popLastEntryPosition();
            if (offset > -1L) {
                pos = this.fileSegment.getRelativePosition(offset);
                recycled = true;
            } else {
                pos = this.fileSegment.allocateSpace(15);
                offset = this.fileSegment.getAbsolutePosition(pos);
                recycled = false;
            }
            OFile file = this.fileSegment.files[(int)pos[0]];
            long p = pos[1];
            file.writeShort(p, (short)iPPosition.dataSegmentId);
            file.writeLong(p += 2L, iPPosition.dataSegmentPos);
            file.writeByte(p += 8L, iPPosition.recordType);
            iPPosition.recordVersion = recycled ? file.readInt(p + 1L) * -1 : 0;
            file.writeInt(p + 1L, iPPosition.recordVersion);
            iPPosition.clusterPosition = offset / 15L;
            this.updateBoundsAfterInsertion(iPPosition.clusterPosition);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstEntryPosition() {
        this.acquireSharedLock();
        try {
            long l = this.beginOffsetData;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEntryPosition() {
        this.acquireSharedLock();
        try {
            long l = this.endOffsetData > -1L ? this.endOffsetData : this.fileSegment.getFilledUpTo() / 15L - 1L;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntries() {
        this.acquireSharedLock();
        try {
            long l = this.fileSegment.getFilledUpTo() / 15L - (long)this.holeSegment.getHoles();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public int getId() {
        return this.id;
    }

    public OClusterPositionIterator absoluteIterator() {
        return new OClusterPositionIterator(this);
    }

    public OClusterPositionIterator absoluteIterator(long iBeginRange, long iEndRange) throws IOException {
        return new OClusterPositionIterator(this, iBeginRange, iEndRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.acquireSharedLock();
        try {
            long l = this.fileSegment.getSize();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilledUpTo() {
        this.acquireSharedLock();
        try {
            long l = this.fileSegment.getFilledUpTo();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public String toString() {
        return this.name + " (id=" + this.id + ")";
    }

    public void lock() {
        this.acquireSharedLock();
    }

    public void unlock() {
        this.releaseSharedLock();
    }

    public String getType() {
        return TYPE;
    }

    public long getRecordsSize() {
        this.acquireSharedLock();
        try {
            long size = this.fileSegment.getFilledUpTo();
            OClusterPositionIterator it = this.absoluteIterator();
            OPhysicalPosition pos = new OPhysicalPosition();
            while (it.hasNext()) {
                pos.clusterPosition = it.next();
                this.getPhysicalPosition(pos);
                if (pos.dataSegmentPos <= -1L || pos.recordVersion <= -1) continue;
                size += (long)this.storage.getDataSegmentById(pos.dataSegmentId).getRecordSize(pos.dataSegmentPos);
            }
            long l = size;
            return l;
        }
        catch (IOException e) {
            throw new OIOException("Error on calculating cluster size for: " + this.getName(), e);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() throws IOException {
        this.acquireSharedLock();
        try {
            this.fileSegment.synch();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public String getName() {
        return this.name;
    }

    public OStoragePhysicalClusterConfiguration getConfig() {
        return this.config;
    }

    private void setNameInternal(String iNewName) {
        if (this.storage.getClusterIdByName(iNewName) > -1) {
            throw new IllegalArgumentException("Cluster with name '" + iNewName + "' already exists");
        }
        for (int i = 0; i < this.fileSegment.files.length; ++i) {
            String osFileName = this.fileSegment.files[i].getName();
            if (!osFileName.startsWith(this.name)) continue;
            File newFile = new File(this.storage.getStoragePath() + "/" + iNewName + osFileName.substring(osFileName.lastIndexOf(this.name) + this.name.length()));
            for (OStorageFileConfiguration conf : this.config.infoFiles) {
                if (conf.parent.name.equals(this.name)) {
                    conf.parent.name = iNewName;
                }
                if (!conf.path.endsWith(osFileName)) continue;
                conf.path = new String(conf.path.replace(osFileName, newFile.getName()));
            }
            boolean renamed = this.fileSegment.files[i].renameTo(newFile);
            while (!renamed) {
                OMemoryWatchDog.freeMemory(100L);
                renamed = this.fileSegment.files[i].renameTo(newFile);
            }
        }
        this.config.name = iNewName;
        this.holeSegment.rename(this.name, iNewName);
        this.storage.renameCluster(this.name, iNewName);
        this.name = iNewName;
        this.storage.getConfiguration().update();
    }

    private void setDataSegmentInternal(String iName) {
        int dataId = this.storage.getDataSegmentIdByName(iName);
        this.config.setDataSegmentId(dataId);
        this.storage.getConfiguration().update();
    }

    protected void updateBoundsAfterInsertion(long iPosition) throws IOException {
        if (iPosition < this.beginOffsetData || this.beginOffsetData == -1L) {
            this.beginOffsetData = iPosition;
            this.fileSegment.files[0].writeHeaderLong(0, this.beginOffsetData);
        }
        if (this.endOffsetData > -1L && iPosition > this.endOffsetData) {
            this.endOffsetData = iPosition;
            this.fileSegment.files[0].writeHeaderLong(8, this.endOffsetData);
        }
    }

    protected void updateBoundsAfterDeletion(long iPosition) throws IOException {
        long[] fetchPos;
        long currentPos;
        long position = iPosition * 15L;
        if (iPosition == this.beginOffsetData) {
            if (this.getEntries() == 0L) {
                this.beginOffsetData = -1L;
            } else {
                ++this.beginOffsetData;
                for (currentPos = position + 15L; currentPos < this.fileSegment.getFilledUpTo() && this.fileSegment.files[(int)(fetchPos = this.fileSegment.getRelativePosition(currentPos))[0]].readShort(fetchPos[1]) == -1; currentPos += 15L) {
                    ++this.beginOffsetData;
                }
            }
            this.fileSegment.files[0].writeHeaderLong(0, this.beginOffsetData);
        }
        if (iPosition == this.endOffsetData) {
            if (this.getEntries() == 0L) {
                this.endOffsetData = -1L;
            } else {
                --this.endOffsetData;
                for (currentPos = position - 15L; currentPos >= this.beginOffsetData && this.fileSegment.files[(int)(fetchPos = this.fileSegment.getRelativePosition(currentPos))[0]].readShort(fetchPos[1]) == -1; currentPos -= 15L) {
                    --this.endOffsetData;
                }
            }
            this.fileSegment.files[0].writeHeaderLong(8, this.endOffsetData);
        }
    }

    protected void init(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) throws IOException {
        this.storage = (OStorageLocal)iStorage;
        this.config.setDataSegmentId(iDataSegmentId);
        this.config.id = iId;
        this.config.name = iClusterName;
        this.name = iClusterName;
        this.id = iId;
        if (this.fileSegment == null) {
            this.fileSegment = new OMultiFileSegment(this.storage, this.config, DEF_EXTENSION, 1000000);
            this.config.setHoleFile(new OStorageClusterHoleConfiguration(this.config, "${STORAGE_PATH}/" + this.config.name, this.config.fileType, this.config.fileMaxSize));
            this.holeSegment = new OClusterLocalHole(this, this.storage, this.config.getHoleFile());
        }
    }
}

