/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalTxExecuter;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageLocal
extends OStorageEmbedded {
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    private final Map<String, OCluster> clusterMap = new LinkedHashMap<String, OCluster>();
    private OCluster[] clusters = new OCluster[0];
    private ODataLocal[] dataSegments = new ODataLocal[0];
    private final OStorageLocalTxExecuter txManager;
    private String storagePath;
    private final OStorageVariableParser variableParser;
    private int defaultClusterId = -1;
    private static String[] ALL_FILE_EXTENSIONS = new String[]{"ocf", ".och", ".ocl", ".oda", ".odh", ".otx"};
    private final String PROFILER_CREATE_RECORD;
    private final String PROFILER_READ_RECORD;
    private final String PROFILER_UPDATE_RECORD;
    private final String PROFILER_DELETE_RECORD;

    public OStorageLocal(String iName, String iFilePath, String iMode) throws IOException {
        super(iName, iFilePath, iMode);
        File f = new File(this.url);
        this.storagePath = f.exists() || !this.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getParent()));
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this);
        this.txManager = new OStorageLocalTxExecuter(this, this.configuration.txSegment);
        this.PROFILER_CREATE_RECORD = "storage." + this.name + ".createRecord";
        this.PROFILER_READ_RECORD = "storage." + this.name + ".readRecord";
        this.PROFILER_UPDATE_RECORD = "storage." + this.name + ".updateRecord";
        this.PROFILER_DELETE_RECORD = "storage." + this.name + ".deleteRecord";
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        this.installProfilerHooks();
    }

    @Override
    public synchronized void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            int i;
            this.addUser();
            if (this.status != OStorage.STATUS.CLOSED) {
                return;
            }
            if (!this.exists()) {
                throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
            }
            this.status = OStorage.STATUS.OPEN;
            int pos = this.registerDataSegment(new OStorageDataConfiguration(this.configuration, "default", 0, this.getStoragePath()));
            this.dataSegments[pos].open();
            pos = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, this.clusters.length, 0, "internal"));
            this.clusters[pos].open();
            this.configuration.load();
            pos = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, this.clusters.length, 0, "index"));
            this.clusters[pos].open();
            this.defaultClusterId = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, this.clusters.length, 0, "default"));
            this.clusters[this.defaultClusterId].open();
            for (i = 0; i < this.configuration.dataSegments.size(); ++i) {
                OStorageDataConfiguration dataConfig = this.configuration.dataSegments.get(i);
                pos = this.registerDataSegment(dataConfig);
                if (pos == -1) {
                    this.dataSegments[i].close();
                    this.dataSegments[i] = new ODataLocal(this, dataConfig, i);
                    this.dataSegments[i].open();
                    continue;
                }
                this.dataSegments[pos].open();
            }
            for (i = 0; i < this.configuration.clusters.size(); ++i) {
                OStorageClusterConfiguration clusterConfig = this.configuration.clusters.get(i);
                if (clusterConfig != null) {
                    pos = this.createClusterFromConfig(clusterConfig);
                    try {
                        if (pos == -1) {
                            this.clusters[i].close();
                            this.clusters[i] = new OClusterLocal();
                            this.clusters[i].configure(this, (OStoragePhysicalClusterConfiguration)clusterConfig);
                            this.clusterMap.put(this.clusters[i].getName(), this.clusters[i]);
                            this.clusters[i].open();
                            continue;
                        }
                        if (clusterConfig.getName().equals("default")) {
                            this.defaultClusterId = pos;
                        }
                        this.clusters[pos].open();
                    }
                    catch (FileNotFoundException e) {
                        OLogManager.instance().warn((Object)this, "Error on loading cluster '" + this.clusters[i].getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", new Object[0]);
                        this.clusterMap.remove(this.clusters[i].getName());
                        this.clusters[i] = null;
                    }
                    continue;
                }
                this.clusters = Arrays.copyOf(this.clusters, this.clusters.length + 1);
                this.clusters[i] = null;
            }
            this.txManager.open();
        }
        catch (Exception e) {
            this.close(true);
            throw new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".open", timer);
        }
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            if (this.status != OStorage.STATUS.CLOSED) {
                throw new OStorageException("Cannot create new storage '" + this.name + "' because it is not closed");
            }
            this.addUser();
            File storageFolder = new File(this.storagePath);
            if (!storageFolder.exists()) {
                storageFolder.mkdir();
            }
            if (this.exists()) {
                throw new OStorageException("Cannot create new storage '" + this.name + "' because it already exists");
            }
            this.status = OStorage.STATUS.OPEN;
            this.addDataSegment("default");
            this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "internal", null, null, new Object[0]);
            this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "index", null, null, new Object[0]);
            this.defaultClusterId = this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "default", null, null, new Object[0]);
            this.configuration.create();
            this.txManager.create();
        }
        catch (OStorageException e) {
            this.close();
            throw e;
        }
        catch (IOException e) {
            this.close();
            throw new OStorageException("Error on creation of storage '" + this.name + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".create", timer);
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean exists() {
        return this.exists(this.storagePath);
    }

    private boolean exists(String path) {
        return new File(path + "/" + "default" + ".0" + ".oda").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean iForce) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            if (!this.checkForClose(iForce)) {
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            for (OCluster cluster : this.clusters) {
                if (cluster == null) continue;
                cluster.close();
            }
            this.clusters = new OCluster[0];
            this.clusterMap.clear();
            for (ODataLocal data : this.dataSegments) {
                data.close();
            }
            this.dataSegments = new ODataLocal[0];
            this.txManager.close();
            if (this.configuration != null) {
                this.configuration.close();
            }
            this.level2Cache.shutdown();
            OMMapManager.flush();
            super.close(iForce);
            Orient.instance().unregisterStorage(this);
            this.status = OStorage.STATUS.CLOSED;
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
        }
    }

    @Override
    public void delete() {
        if (this.status != OStorage.STATUS.CLOSED && this.getUsers() > 0) {
            while (this.removeUser() > 0) {
            }
        }
        this.close(true);
        try {
            Orient.instance().unregisterStorage(this);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Cannot unregister storage", (Throwable)e, new Object[0]);
        }
        long timer = OProfiler.getInstance().startChrono();
        File dbDir = new File(OSystemVariableResolver.resolveSystemVariables(this.url));
        if (!dbDir.exists() || !dbDir.isDirectory()) {
            dbDir = dbDir.getParentFile();
        }
        this.lock.acquireExclusiveLock();
        try {
            for (int i = 0; i < this.DELETE_MAX_RETRIES; ++i) {
                if (dbDir.exists() && dbDir.isDirectory()) {
                    int notDeletedFiles = 0;
                    block9: for (File f : dbDir.listFiles()) {
                        for (String ext : ALL_FILE_EXTENSIONS) {
                            if (!f.getPath().endsWith(ext)) continue;
                            if (f.delete()) continue block9;
                            ++notDeletedFiles;
                            continue block9;
                        }
                    }
                    if (notDeletedFiles == 0) {
                        dbDir.delete();
                        return;
                    }
                } else {
                    return;
                }
                OLogManager.instance().debug((Object)this, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES);
                OMemoryWatchDog.freeMemory(this.DELETE_WAIT_TIME);
            }
            throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ". Database files seem locked");
        }
        finally {
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".delete", timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(boolean iVerbose, OCommandOutputListener iListener) {
        int errors = 0;
        int warnings = 0;
        this.lock.acquireSharedLock();
        try {
            long totalRecors = 0L;
            long start = System.currentTimeMillis();
            this.formatMessage(iVerbose, iListener, "\nChecking database '" + this.getName() + "'...\n", new Object[0]);
            this.formatMessage(iVerbose, iListener, "\n(1) Checking data-clusters. This activity checks if pointers to data are coherent.", new Object[0]);
            OPhysicalPosition ppos = new OPhysicalPosition();
            for (OCluster c : this.clusters) {
                if (!(c instanceof OClusterLocal)) continue;
                this.formatMessage(iVerbose, iListener, "\n- data-cluster #%-5d %s -> ", c.getId(), c.getName());
                OClusterPositionIterator it = c.absoluteIterator();
                while (it.hasNext()) {
                    ppos.clusterPosition = it.next();
                    ++totalRecors;
                    try {
                        c.getPhysicalPosition(ppos);
                        if (ppos.dataSegmentId >= this.dataSegments.length) {
                            this.formatMessage(iVerbose, iListener, "WARN: Found wrong data segment %d ", ppos.dataSegmentId);
                            ++warnings;
                        }
                        if (ppos.recordSize < 0) {
                            this.formatMessage(iVerbose, iListener, "WARN: Found wrong record size %d ", ppos.recordSize);
                            ++warnings;
                        }
                        if (ppos.recordSize >= 1000000) {
                            this.formatMessage(iVerbose, iListener, "WARN: Found suspected big record size %d. Is it corrupted? ", ppos.recordSize);
                            ++warnings;
                        }
                        if (ppos.dataSegmentPos > this.dataSegments[ppos.dataSegmentId].getFilledUpTo()) {
                            this.formatMessage(iVerbose, iListener, "WARN: Found wrong pointer to data chunk %d out of data segment size (%d) ", ppos.dataSegmentPos, this.dataSegments[ppos.dataSegmentId].getFilledUpTo());
                            ++warnings;
                        }
                        if (ppos.recordVersion >= 0) continue;
                        boolean found = false;
                        int tot = ((OClusterLocal)c).holeSegment.getHoles();
                        for (int i = 0; i < tot; ++i) {
                            long recycledPosition = ((OClusterLocal)c).holeSegment.getEntryPosition(i) / 15L;
                            if (recycledPosition != ppos.clusterPosition) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.formatMessage(iVerbose, iListener, "WARN: Cannot find hole for deleted record %d:%d ", c.getId(), ppos.clusterPosition);
                        ++warnings;
                    }
                    catch (IOException e) {
                        this.formatMessage(iVerbose, iListener, "WARN: Error while reading record #%d:%d ", e, c.getId(), ppos.clusterPosition);
                        ++warnings;
                    }
                }
                int tot = ((OClusterLocal)c).holeSegment.getHoles();
                if (tot > 0) {
                    this.formatMessage(iVerbose, iListener, " [found " + tot + " hole(s)]", new Object[0]);
                    for (int i = 0; i < tot; ++i) {
                        long recycledPosition = -1L;
                        try {
                            ppos.clusterPosition = ((OClusterLocal)c).holeSegment.getEntryPosition(i) / 15L;
                            c.getPhysicalPosition(ppos);
                            if (ppos.recordVersion <= -1) continue;
                            this.formatMessage(iVerbose, iListener, "WARN: Found wrong hole %d/%d for deleted record %d:%d. The record seems good ", i, tot - 1, c.getId(), recycledPosition);
                            ++warnings;
                            continue;
                        }
                        catch (Exception e) {
                            this.formatMessage(iVerbose, iListener, "WARN: Found wrong hole %d/%d for deleted record %d:%d. The record not exists ", i, tot - 1, c.getId(), recycledPosition);
                            ++warnings;
                        }
                    }
                }
                this.formatMessage(iVerbose, iListener, "OK", new Object[0]);
            }
            int totalChunks = 0;
            this.formatMessage(iVerbose, iListener, "\n\n(2) Checking data chunks integrity. In this phase data segments are scanned to check the back reference into the clusters.", new Object[0]);
            for (ODataLocal d : this.dataSegments) {
                this.formatMessage(iVerbose, iListener, "\n- data-segment %s (id=%d) size=%d/%d...", d.getName(), d.getId(), d.getFilledUpTo(), d.getSize(), d.getHoles());
                int nextPos = 0;
                List<ODataHoleInfo> holes = d.getHolesList();
                if (iVerbose) {
                    this.formatMessage(iVerbose, iListener, "\n-- found %d holes:", holes.size());
                    for (ODataHoleInfo hole : holes) {
                        this.formatMessage(iVerbose, iListener, "\n--- hole #%-7d offset=%-10d size=%-7d", hole.holeOffset, hole.dataOffset, hole.size);
                    }
                }
                this.formatMessage(iVerbose, iListener, "\n-- checking chunks:", new Object[0]);
                int pos = 0;
                while ((long)nextPos < d.getFilledUpTo()) {
                    try {
                        pos = nextPos;
                        ODataHoleInfo foundHole = null;
                        for (ODataHoleInfo hole : holes) {
                            if (hole.dataOffset != (long)pos) continue;
                            foundHole = hole;
                            break;
                        }
                        int recordSize = d.getRecordSize(pos);
                        this.formatMessage(iVerbose, iListener, "\n--- chunk #%-7d offset=%-10d size=%-7d -> ", totalChunks, pos, recordSize);
                        if (recordSize < 0) {
                            recordSize *= -1;
                            if (foundHole != null) {
                                if (foundHole.size != recordSize) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) differs in size with the hole size %d ", d.getName(), totalChunks, pos, recordSize, foundHole.size);
                                    ++warnings;
                                }
                                nextPos = pos + foundHole.size;
                            } else {
                                this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has no hole for deleted chunk ", d.getName(), totalChunks, pos, recordSize);
                                ++warnings;
                                nextPos = pos + recordSize;
                            }
                        } else if (foundHole != null) {
                            this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) it's between the holes (hole #%d) even if has no negative recordSize. Jump the content ", d.getName(), totalChunks, pos, recordSize, foundHole.holeOffset);
                            ++warnings;
                            nextPos = pos + foundHole.size;
                        } else {
                            ORecordId rid;
                            nextPos = pos + 14 + recordSize;
                            byte[] buffer = d.getRecord(pos);
                            if (buffer.length != recordSize) {
                                this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has wrong record size because the record length is %d ", d.getName(), totalChunks, pos, recordSize, buffer.length);
                                ++warnings;
                            }
                            if (!(rid = d.getRecordRid(pos)).isValid()) {
                                this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) points to invalid RID %s ", d.getName(), totalChunks, pos, recordSize, rid);
                                ++warnings;
                            } else if (rid.clusterId >= this.clusters.length) {
                                this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has invalid RID because points to %s but configured clusters are %d in total ", d.getName(), totalChunks, pos, recordSize, rid, this.clusters.length);
                                ++warnings;
                            } else if (this.clusters[rid.clusterId] == null) {
                                this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) has invalid RID because points to %s but the cluster %d not exists ", d.getName(), totalChunks, pos, recordSize, rid, rid.clusterId);
                                ++warnings;
                            } else {
                                ppos.clusterPosition = rid.clusterPosition;
                                this.clusters[rid.clusterId].getPhysicalPosition(ppos);
                                if (ppos.dataSegmentId != d.getId()) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) point to the RID %d but it doesn't point to current data segment %d but to %d ", d.getName(), totalChunks, pos, recordSize, rid, d.getId(), ppos.dataSegmentId);
                                    ++warnings;
                                }
                                if (ppos.dataSegmentPos != (long)pos) {
                                    this.formatMessage(iVerbose, iListener, "WARN: Chunk %s:%d (offset=%d size=%d) point to the RID %d but it doesn't point to current chunk %d but to %d ", d.getName(), totalChunks, pos, recordSize, rid, ppos.dataSegmentPos, pos);
                                    ++warnings;
                                }
                            }
                        }
                        ++totalChunks;
                        this.formatMessage(iVerbose, iListener, "OK", new Object[0]);
                    }
                    catch (Exception e) {
                        iListener.onMessage("ERROR: " + e.toString());
                        ++errors;
                    }
                }
                this.formatMessage(iVerbose, iListener, "\n", new Object[0]);
            }
            iListener.onMessage("\nCheck of database completed in " + (System.currentTimeMillis() - start) + "ms:\n- Total records checked: " + totalRecors + "\n- Total chunks checked.: " + totalChunks + "\n- Warnings.............: " + warnings + "\n- Errors...............: " + errors + "\n");
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return errors == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODataLocal getDataSegmentById(int iDataSegmentId) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            if (iDataSegmentId >= this.dataSegments.length) {
                throw new IllegalArgumentException("Data segment #" + iDataSegmentId + " does not exist in storage '" + this.name + "'");
            }
            ODataLocal oDataLocal = this.dataSegments[iDataSegmentId];
            return oDataLocal;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        if (iDataSegmentName == null) {
            return 0;
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            for (ODataLocal d : this.dataSegments) {
                if (!d.getName().equalsIgnoreCase(iDataSegmentName)) continue;
                int n = d.getId();
                return n;
            }
            throw new IllegalArgumentException("Data segment '" + iDataSegmentName + "' does not exist in storage '" + this.name + "'");
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDataSegment(String iSegmentName, String iDirectory) {
        this.checkOpeness();
        iSegmentName = iSegmentName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            OStorageDataConfiguration conf = new OStorageDataConfiguration(this.configuration, iSegmentName, this.configuration.dataSegments.size(), iDirectory);
            this.configuration.dataSegments.add(conf);
            int pos = this.registerDataSegment(conf);
            if (pos == -1) {
                throw new OConfigurationException("Cannot add segment " + conf.name + " because it is already part of storage '" + this.name + "'");
            }
            this.dataSegments[pos].create(-1);
            this.configuration.update();
            int n = pos;
            return n;
        }
        catch (Throwable e) {
            OLogManager.instance().error((Object)this, "Error on creation of new data segment '" + iSegmentName + "' in: " + iDirectory, e, OStorageException.class, new Object[0]);
            int n = -1;
            return n;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        this.checkOpeness();
        try {
            OCluster cluster;
            if (iClusterName != null) {
                iClusterName = iClusterName.toLowerCase();
                int clusterPos = this.clusters.length;
                for (int i = 0; i < this.clusters.length; ++i) {
                    if (this.clusters[i] != null) continue;
                    clusterPos = i;
                    break;
                }
                cluster = Orient.instance().getClusterFactory().createCluster(iClusterType);
                cluster.configure(this, clusterPos, iClusterName, iLocation, this.getDataSegmentIdByName(iDataSegmentName), iParameters);
            } else {
                cluster = null;
            }
            this.registerCluster(cluster);
            if (cluster != null) {
                cluster.create(-1);
                this.configuration.update();
            }
            return cluster.getId();
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error in creation of new cluster '" + iClusterName + "' of type: " + iClusterType, e, OStorageException.class, new Object[0]);
            return -1;
        }
    }

    public ODataLocal[] getDataSegments() {
        return this.dataSegments;
    }

    public OStorageLocalTxExecuter getTxManager() {
        return this.txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropCluster(int iClusterId) {
        this.lock.acquireExclusiveLock();
        try {
            if (iClusterId < 0 || iClusterId >= this.clusters.length) {
                throw new IllegalArgumentException("Cluster id '" + iClusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.length - 1) + ") in storage '" + this.name + "'");
            }
            OCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                boolean bl = false;
                return bl;
            }
            this.getLevel2Cache().freeCluster(iClusterId);
            cluster.delete();
            this.clusterMap.remove(cluster.getName());
            this.clusters[iClusterId] = null;
            this.configuration.dropCluster(iClusterId);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error while removing cluster '" + iClusterId + "'", e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropDataSegment(String iName) {
        this.lock.acquireExclusiveLock();
        try {
            int id = this.getDataSegmentIdByName(iName);
            ODataLocal data = this.dataSegments[id];
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            data.delete();
            this.dataSegments[id] = null;
            this.configuration.dropCluster(id);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error while removing data segment '" + iName + "'", e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            for (int i = 0; i < iClusterIds.length; ++i) {
                if (iClusterIds[i] >= this.clusters.length) {
                    throw new OConfigurationException("Cluster id " + iClusterIds[i] + " was not found in storage '" + this.name + "'");
                }
                OCluster c = this.clusters[iClusterIds[i]];
                if (c == null) continue;
                tot += c.getEntries();
            }
            long l = tot;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getClusterDataRange(int iClusterId) {
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id " + iClusterId + " is invalid in storage '" + this.name + "'");
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long[] lArray;
            if (this.clusters[iClusterId] != null) {
                long[] lArray2 = new long[2];
                lArray2[0] = this.clusters[iClusterId].getFirstEntryPosition();
                lArray = lArray2;
                lArray2[1] = this.clusters[iClusterId].getLastEntryPosition();
            } else {
                lArray = new long[]{};
            }
            long[] lArray3 = lArray;
            return lArray3;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int iClusterId) {
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id " + iClusterId + " is invalid in storage '" + this.name + "'");
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long l = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getEntries() : 0L;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OPhysicalPosition createRecord(int iDataSegmentId, ORecordId iRid, byte[] iContent, int iRecordVersion, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        OPhysicalPosition ppos;
        this.checkOpeness();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        ODataLocal dataSegment = this.getDataSegmentById(iDataSegmentId);
        if (this.txManager.isCommitting()) {
            ppos = this.txManager.createRecord(this.txManager.getCurrentTransaction().getId(), dataSegment, cluster, iRid, iContent, iRecordVersion, iRecordType, iDataSegmentId);
            iRid.clusterPosition = ppos.clusterPosition;
        } else {
            ppos = this.createRecord(dataSegment, cluster, iContent, iRecordType, iRid, iRecordVersion);
            if (OGlobalConfiguration.NON_TX_RECORD_UPDATE_SYNCH.getValueAsBoolean()) {
                this.synchRecordUpdate(cluster, ppos);
            }
            if (iCallback != null) {
                iCallback.call(iRid, ppos.clusterPosition);
            }
        }
        return ppos;
    }

    @Override
    public ORawBuffer readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        this.checkOpeness();
        return this.readRecord(this.getClusterById(iRid.clusterId), iRid, true);
    }

    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<Integer> iCallback) {
        int returnValue;
        this.checkOpeness();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        if (this.txManager.isCommitting()) {
            return this.txManager.updateRecord(this.txManager.getCurrentTransaction().getId(), cluster, iRid, iContent, iVersion, iRecordType);
        }
        OPhysicalPosition ppos = this.updateRecord(cluster, iRid, iContent, iVersion, iRecordType);
        if (ppos != null && OGlobalConfiguration.NON_TX_RECORD_UPDATE_SYNCH.getValueAsBoolean()) {
            this.synchRecordUpdate(cluster, ppos);
        }
        int n = returnValue = ppos != null ? ppos.recordVersion : -1;
        if (iCallback != null) {
            iCallback.call(iRid, returnValue);
        }
        return returnValue;
    }

    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        boolean returnValue;
        this.checkOpeness();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        if (this.txManager.isCommitting()) {
            return this.txManager.deleteRecord(this.txManager.getCurrentTransaction().getId(), cluster, iRid.clusterPosition, iVersion);
        }
        OPhysicalPosition ppos = this.deleteRecord(cluster, iRid, iVersion);
        if (ppos != null && OGlobalConfiguration.NON_TX_RECORD_UPDATE_SYNCH.getValueAsBoolean()) {
            this.synchRecordUpdate(cluster, ppos);
        }
        boolean bl = returnValue = ppos != null;
        if (iCallback != null) {
            iCallback.call(iRid, returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClusterNames() {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            Set<String> set = this.clusterMap.keySet();
            return set;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusterIdByName(String iClusterName) {
        this.checkOpeness();
        if (iClusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        if (iClusterName.length() == 0) {
            throw new IllegalArgumentException("Cluster name is empty");
        }
        if (Character.isDigit(iClusterName.charAt(0))) {
            return Integer.parseInt(iClusterName);
        }
        this.lock.acquireSharedLock();
        try {
            OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
            if (segment != null) {
                int n = segment.getId();
                return n;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterTypeByName(String iClusterName) {
        this.checkOpeness();
        if (iClusterName == null) {
            throw new IllegalArgumentException("Cluster name is null");
        }
        this.lock.acquireSharedLock();
        try {
            OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
            if (segment != null) {
                String string = segment.getType();
                return string;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(OTransaction iTx) {
        this.lock.acquireExclusiveLock();
        try {
            try {
                this.txManager.clearLogEntries(iTx);
                this.txManager.commitAllPendingRecords(iTx);
                if (OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) {
                    this.synch();
                }
            }
            catch (RuntimeException e) {
                this.rollback(iTx);
                throw e;
            }
            catch (IOException e) {
                this.rollback(iTx);
                throw new OException(e);
            }
            finally {
                try {
                    this.txManager.clearLogEntries(iTx);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Clear tx log entries failed", (Throwable)e, new Object[0]);
                }
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void rollback(OTransaction iTx) {
        try {
            this.txManager.getTxSegment().rollback(iTx);
            if (OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) {
                this.synch();
            }
        }
        catch (IOException ioe) {
            OLogManager.instance().error((Object)this, "Error executing rollback for transaction with id '" + iTx.getId() + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
        }
    }

    @Override
    public void synch() {
        this.checkOpeness();
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            for (OCluster cluster : this.clusters) {
                if (cluster == null) continue;
                cluster.synch();
            }
            for (ODataLocal data : this.dataSegments) {
                if (data == null) continue;
                data.synch();
            }
            if (this.configuration != null) {
                this.configuration.synch();
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on synch storage '" + this.name + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".synch", timer);
        }
    }

    protected void synchRecordUpdate(OCluster cluster, OPhysicalPosition ppos) {
        this.checkOpeness();
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            cluster.synch();
            ODataLocal data = this.getDataSegmentById(ppos.dataSegmentId);
            data.synch();
            if (this.configuration != null) {
                this.configuration.synch();
            }
        }
        catch (IOException e) {
            throw new OStorageException("Error on synch storage '" + this.name + "'", e);
        }
        finally {
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + "record.synch", timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ODataHoleInfo> getHolesList() {
        ArrayList<ODataHoleInfo> holes = new ArrayList<ODataHoleInfo>();
        this.lock.acquireSharedLock();
        try {
            for (ODataLocal d : this.dataSegments) {
                holes.addAll(d.getHolesList());
            }
            ArrayList<ODataHoleInfo> arrayList = holes;
            return arrayList;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoles() {
        this.lock.acquireSharedLock();
        try {
            long holes = 0L;
            for (ODataLocal d : this.dataSegments) {
                holes += d.getHoles();
            }
            long l = holes;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoleSize() {
        this.lock.acquireSharedLock();
        try {
            List<ODataHoleInfo> holes = this.getHolesList();
            long size = 0L;
            for (ODataHoleInfo h : holes) {
                if (h.dataOffset <= -1L || h.size <= 0) continue;
                size += (long)h.size;
            }
            long l = size;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            if (iClusterId >= this.clusters.length) {
                String string = null;
                return string;
            }
            String string = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getName() : null;
            return string;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            this.checkClusterSegmentIndexRange(iClusterId);
            OCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterId + " is null");
            }
            OCluster oCluster = cluster;
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterName + " does not exist in storage '" + this.name + "'");
            }
            OCluster oCluster = cluster;
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public String getURL() {
        return "local:" + this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.lock.acquireSharedLock();
        try {
            long size = 0L;
            for (OCluster c : this.clusters) {
                if (c == null) continue;
                size += c.getRecordsSize();
            }
            long l = size;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public String getMode() {
        return this.mode;
    }

    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OCluster> getClusterInstances() {
        HashSet<OCluster> result = new HashSet<OCluster>();
        this.lock.acquireSharedLock();
        try {
            for (OCluster c : this.clusters) {
                result.add(c);
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return result;
    }

    public void renameCluster(String iOldName, String iNewName) {
        this.clusterMap.put(iNewName, this.clusterMap.remove(iOldName));
    }

    protected int registerDataSegment(OStorageDataConfiguration iConfig) throws IOException {
        this.checkOpeness();
        int pos = 0;
        for (ODataLocal data : this.dataSegments) {
            if (!data.getName().equals(iConfig.name)) continue;
            data.config = iConfig;
            return -1;
        }
        pos = this.dataSegments.length;
        ODataLocal segment = new ODataLocal(this, iConfig, pos);
        this.dataSegments = OArrays.copyOf(this.dataSegments, this.dataSegments.length + 1);
        this.dataSegments[pos] = segment;
        return pos;
    }

    private int createClusterFromConfig(OStorageClusterConfiguration iConfig) throws IOException {
        OCluster cluster = this.clusterMap.get(iConfig.getName());
        if (cluster != null) {
            if (cluster instanceof OClusterLocal) {
                ((OClusterLocal)cluster).configure(this, iConfig);
            }
            return -1;
        }
        cluster = Orient.instance().getClusterFactory().createCluster(iConfig);
        cluster.configure(this, iConfig);
        return this.registerCluster(cluster);
    }

    private int registerCluster(OCluster iCluster) throws IOException {
        int id;
        if (iCluster != null) {
            if (this.clusterMap.containsKey(iCluster.getName())) {
                throw new OConfigurationException("Cannot add segment '" + iCluster.getName() + "' because it is already registered in storage '" + this.name + "'");
            }
            this.clusterMap.put(iCluster.getName(), iCluster);
            id = iCluster.getId();
        } else {
            id = this.clusters.length;
        }
        this.clusters = OArrays.copyOf(this.clusters, this.clusters.length + 1);
        this.clusters[id] = iCluster;
        return id;
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId > this.clusters.length - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in storage '" + this.name + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OPhysicalPosition createRecord(ODataLocal iDataSegment, OCluster iClusterSegment, byte[] iContent, byte iRecordType, ORecordId iRid, int recordVersion) {
        this.checkOpeness();
        if (iContent == null) {
            throw new IllegalArgumentException("Record is null");
        }
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            OPhysicalPosition oPhysicalPosition;
            OPhysicalPosition ppos = new OPhysicalPosition(-1, -1L, iRecordType);
            iClusterSegment.addPhysicalPosition(ppos);
            iRid.clusterPosition = ppos.clusterPosition;
            this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
            try {
                ppos.dataSegmentId = iDataSegment.getId();
                ppos.dataSegmentPos = iDataSegment.addRecord(iRid, iContent);
                iClusterSegment.updateDataSegmentPosition(ppos.clusterPosition, ppos.dataSegmentId, ppos.dataSegmentPos);
                if (recordVersion != 0) {
                    iClusterSegment.updateVersion(iRid.clusterPosition, recordVersion);
                }
                oPhysicalPosition = ppos;
            }
            catch (Throwable throwable) {
                try {
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    throw throwable;
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Error on creating record in cluster: " + iClusterSegment, (Throwable)e, new Object[0]);
                    OPhysicalPosition oPhysicalPosition2 = null;
                    return oPhysicalPosition2;
                }
            }
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
            return oPhysicalPosition;
        }
        finally {
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono(this.PROFILER_CREATE_RECORD, timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock) {
        if (iRid.clusterPosition < 0L) {
            throw new IllegalArgumentException("Cannot read record " + iRid + " since the position is invalid in storage '" + this.name + "'");
        }
        long timer = OProfiler.getInstance().startChrono();
        if (iAtomicLock) {
            this.lock.acquireSharedLock();
        }
        try {
            OPhysicalPosition ppos;
            block15: {
                ORawBuffer oRawBuffer;
                this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                try {
                    long lastPos = iClusterSegment.getLastEntryPosition();
                    if (lastPos < 0L) {
                        throw new ORecordNotFoundException("Record " + iRid + " is outside cluster range. The cluster '" + iClusterSegment.getName() + "' is empty in storage '" + this.name + "'");
                    }
                    if (iRid.clusterPosition > lastPos) {
                        throw new ORecordNotFoundException("Record " + iRid + " is outside cluster range. Valid range for cluster '" + iClusterSegment.getName() + "' is 0-" + lastPos + " in storage '" + this.name + "'");
                    }
                    ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                    if (ppos != null && this.checkForRecordValidity(ppos)) break block15;
                    oRawBuffer = null;
                }
                catch (Throwable throwable) {
                    try {
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                        throw throwable;
                    }
                    catch (IOException e) {
                        OLogManager.instance().error((Object)this, "Error on reading record " + iRid + " (cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                        ORawBuffer oRawBuffer2 = null;
                        return oRawBuffer2;
                    }
                }
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                return oRawBuffer;
            }
            ODataLocal data = this.getDataSegmentById(ppos.dataSegmentId);
            ORawBuffer oRawBuffer = new ORawBuffer(data.getRecord(ppos.dataSegmentPos), ppos.recordVersion, ppos.recordType);
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
            return oRawBuffer;
        }
        finally {
            if (iAtomicLock) {
                this.lock.releaseSharedLock();
            }
            OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OPhysicalPosition updateRecord(OCluster iClusterSegment, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        block20: {
            if (iClusterSegment == null) {
                throw new OStorageException("Cluster not defined for record: " + iRid);
            }
            long timer = OProfiler.getInstance().startChrono();
            this.lock.acquireExclusiveLock();
            try {
                long newDataSegmentOffset;
                OPhysicalPosition ppos;
                block19: {
                    OPhysicalPosition oPhysicalPosition;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (this.checkForRecordValidity(ppos)) break block19;
                        oPhysicalPosition = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                            throw throwable;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Error on updating record " + iRid + " (cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                            break block20;
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    return oPhysicalPosition;
                }
                switch (iVersion) {
                    case -1: {
                        ++ppos.recordVersion;
                        iClusterSegment.updateVersion(iRid.clusterPosition, ppos.recordVersion);
                        break;
                    }
                    case -2: {
                        break;
                    }
                    default: {
                        if (iVersion > -1) {
                            if (iVersion != ppos.recordVersion) {
                                throw new OConcurrentModificationException("Cannot update record " + iRid + " in storage '" + this.name + "' because the version is not the latest. Probably you are updating an old record or it has been modified by another user (db=v" + ppos.recordVersion + " your=v" + iVersion + ")", iRid, ppos.recordVersion, iVersion);
                            }
                            ++ppos.recordVersion;
                            iClusterSegment.updateVersion(iRid.clusterPosition, ppos.recordVersion);
                            break;
                        }
                        ppos.recordVersion = iVersion - Integer.MIN_VALUE;
                        iClusterSegment.updateVersion(iRid.clusterPosition, ppos.recordVersion);
                    }
                }
                if (ppos.recordType != iRecordType) {
                    iClusterSegment.updateRecordType(iRid.clusterPosition, iRecordType);
                }
                if ((newDataSegmentOffset = ppos.dataSegmentPos == -1L ? this.getDataSegmentById(ppos.dataSegmentId).addRecord(iRid, iContent) : this.getDataSegmentById(ppos.dataSegmentId).setRecord(ppos.dataSegmentPos, iRid, iContent)) != ppos.dataSegmentPos) {
                    iClusterSegment.updateDataSegmentPosition(ppos.clusterPosition, ppos.dataSegmentId, newDataSegmentOffset);
                    ppos.dataSegmentPos = newDataSegmentOffset;
                }
                OPhysicalPosition oPhysicalPosition = ppos;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                return oPhysicalPosition;
            }
            finally {
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OPhysicalPosition deleteRecord(OCluster iClusterSegment, ORecordId iRid, int iVersion) {
        block13: {
            long timer = OProfiler.getInstance().startChrono();
            this.lock.acquireExclusiveLock();
            try {
                OPhysicalPosition ppos;
                block12: {
                    OPhysicalPosition oPhysicalPosition;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (this.checkForRecordValidity(ppos)) break block12;
                        oPhysicalPosition = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                            throw throwable;
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Error on deleting record " + iRid + "( cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                            break block13;
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    return oPhysicalPosition;
                }
                if (iVersion > -1 && ppos.recordVersion != iVersion) {
                    throw new OConcurrentModificationException("Cannot delete the record " + iRid + " in storage '" + this.name + "' because the version is not the latest. Probably you are deleting an old record or it has been modified by another user (db=v" + ppos.recordVersion + " your=v" + iVersion + ")", iRid, ppos.recordVersion, iVersion);
                }
                if (ppos.dataSegmentPos > -1L) {
                    this.getDataSegmentById(ppos.dataSegmentId).deleteRecord(ppos.dataSegmentPos);
                }
                iClusterSegment.removePhysicalPosition(iRid.clusterPosition);
                OPhysicalPosition oPhysicalPosition = ppos;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                return oPhysicalPosition;
            }
            finally {
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
            }
        }
        return null;
    }

    private void installProfilerHooks() {
        OProfiler.getInstance().registerHookValue("storage." + this.name + ".data.holes", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoles();
            }
        });
        OProfiler.getInstance().registerHookValue("storage." + this.name + ".data.holeSize", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoleSize();
            }
        });
    }

    private void formatMessage(boolean iVerbose, OCommandOutputListener iListener, String iMessage, Object ... iArgs) {
        if (iVerbose) {
            iListener.onMessage(String.format(iMessage, iArgs));
        }
    }
}

