/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.OTxSegment;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import java.io.IOException;
import java.util.ArrayList;

public class OStorageLocalTxExecuter {
    private final OStorageLocal storage;
    private final OTxSegment txSegment;
    private OTransaction currentTransaction;

    public OStorageLocalTxExecuter(OStorageLocal iStorage, OStorageTxConfiguration iConfig) throws IOException {
        this.storage = iStorage;
        iConfig.path = "${STORAGE_PATH}/txlog.otx";
        this.txSegment = new OTxSegment(this.storage, iStorage.getConfiguration().txSegment);
    }

    public void open() throws IOException {
        this.txSegment.open();
    }

    public void create() throws IOException {
        this.txSegment.create(1000000);
    }

    public void close() throws IOException {
        this.txSegment.close();
    }

    protected OPhysicalPosition createRecord(int iTxId, ODataLocal iDataSegment, OCluster iClusterSegment, ORecordId iRid, byte[] iContent, int iRecordVersion, byte iRecordType, int dataSegmentId) {
        iRid.clusterPosition = -1L;
        try {
            OPhysicalPosition ppos = this.storage.createRecord(iDataSegment, iClusterSegment, iContent, iRecordType, iRid, iRecordVersion);
            this.txSegment.addLog((byte)0, iTxId, iRid.clusterId, iRid.clusterPosition, iRecordType, 0, null, dataSegmentId);
            return ppos;
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on creating entry in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
            return null;
        }
    }

    protected int updateRecord(int iTxId, OCluster iClusterSegment, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        try {
            ORawBuffer buffer = this.storage.readRecord(iClusterSegment, iRid, true);
            this.txSegment.addLog((byte)2, iTxId, iRid.clusterId, iRid.clusterPosition, iRecordType, buffer.version, buffer.buffer, -1);
            OPhysicalPosition ppos = this.storage.updateRecord(iClusterSegment, iRid, iContent, iVersion, iRecordType);
            if (ppos != null) {
                return ppos.recordVersion;
            }
            return -1;
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on updating entry #" + iRid + " in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
            return -1;
        }
    }

    protected boolean deleteRecord(int iTxId, OCluster iClusterSegment, long iPosition, int iVersion) {
        try {
            ORecordId rid = new ORecordId(iClusterSegment.getId(), iPosition);
            ORawBuffer buffer = this.storage.readRecord(iClusterSegment, rid, true);
            if (buffer != null) {
                OPhysicalPosition ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iPosition));
                this.txSegment.addLog((byte)1, iTxId, iClusterSegment.getId(), iPosition, buffer.recordType, buffer.version, buffer.buffer, ppos.dataSegmentId);
                return this.storage.deleteRecord(iClusterSegment, rid, iVersion) != null;
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting entry #" + iPosition + " in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
        }
        return false;
    }

    public OTxSegment getTxSegment() {
        return this.txSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAllPendingRecords(OTransaction iTx) throws IOException {
        this.currentTransaction = iTx;
        try {
            ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
            while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                for (ORecordOperation oRecordOperation : iTx.getCurrentRecordEntries()) {
                    tmpEntries.add(oRecordOperation);
                }
                iTx.clearRecordEntries();
                if (tmpEntries.isEmpty()) continue;
                for (ORecordOperation oRecordOperation : tmpEntries) {
                    this.commitEntry(iTx, oRecordOperation, iTx.isUsingLog());
                }
            }
            OTransactionAbstract.updateCacheFromEntries(this.storage, iTx, iTx.getAllRecordEntries(), true);
        }
        finally {
            this.currentTransaction = null;
        }
    }

    public void clearLogEntries(OTransaction iTx) throws IOException {
        this.txSegment.clearLogEntries(iTx.getId());
    }

    private void commitEntry(OTransaction iTx, ORecordOperation txEntry, boolean iUseLog) throws IOException {
        if (txEntry.type != 2 && !txEntry.getRecord().isDirty()) {
            return;
        }
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        if (rid.clusterId == -1 && txEntry.getRecord() instanceof ODocument && ((ODocument)txEntry.getRecord()).getSchemaClass() != null) {
            rid.clusterId = ((ODocument)txEntry.getRecord()).getSchemaClass().getDefaultClusterId();
        }
        OCluster cluster = this.storage.getClusterById(rid.clusterId);
        ODataLocal dataSegment = this.storage.getDataSegmentById(txEntry.dataSegmentId);
        if (cluster.getName().equals("index")) {
            return;
        }
        if (!(cluster instanceof OClusterLocal)) {
            return;
        }
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
        }
        switch (txEntry.type) {
            case 0: {
                break;
            }
            case 3: {
                byte[] stream = txEntry.getRecord().toStream();
                if (rid.isNew()) {
                    txEntry.getRecord().onBeforeIdentityChanged(rid);
                    rid.clusterId = cluster.getId();
                }
                if (rid.isNew()) {
                    OPhysicalPosition ppos = iUseLog ? this.createRecord(iTx.getId(), dataSegment, cluster, rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), txEntry.dataSegmentId) : iTx.getDatabase().getStorage().createRecord(txEntry.dataSegmentId, rid, stream, 0, txEntry.getRecord().getRecordType(), 0, null);
                    rid.clusterPosition = ppos.clusterPosition;
                    txEntry.getRecord().setVersion(ppos.recordVersion);
                    txEntry.getRecord().onAfterIdentityChanged(txEntry.getRecord());
                    break;
                }
                if (iUseLog) {
                    txEntry.getRecord().setVersion(this.updateRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                    break;
                }
                txEntry.getRecord().setVersion(iTx.getDatabase().getStorage().updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                break;
            }
            case 1: {
                byte[] stream = txEntry.getRecord().toStream();
                if (iUseLog) {
                    txEntry.getRecord().setVersion(this.updateRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                    break;
                }
                txEntry.getRecord().setVersion(iTx.getDatabase().getStorage().updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                break;
            }
            case 2: {
                if (iUseLog) {
                    this.deleteRecord(iTx.getId(), cluster, rid.clusterPosition, txEntry.getRecord().getVersion());
                    break;
                }
                iTx.getDatabase().getStorage().deleteRecord(rid, txEntry.getRecord().getVersion(), 0, null);
            }
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    public boolean isCommitting() {
        return this.currentTransaction != null;
    }

    public OTransaction getCurrentTransaction() {
        return this.currentTransaction;
    }
}

