/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;

public class OStorageVariableParser
implements OVariableParserListener {
    public static final String STORAGE_PATH = "STORAGE_PATH";
    private String dbPath;
    public static final String VAR_BEGIN = "${";
    public static final String VAR_END = "}";
    public static final String DB_PATH_VARIABLE = "${STORAGE_PATH}";

    public OStorageVariableParser(String dbPath) {
        this.dbPath = dbPath;
    }

    public String resolveVariables(String iPath) {
        return OVariableParser.resolveVariables(iPath, VAR_BEGIN, VAR_END, this);
    }

    public String convertPathToRelative(String iPath) {
        return iPath.replace(this.dbPath, DB_PATH_VARIABLE);
    }

    public String resolve(String variable) {
        if (variable.equals(STORAGE_PATH)) {
            return this.dbPath;
        }
        String resolved = System.getProperty(variable);
        if (resolved == null) {
            resolved = System.getenv(variable);
        }
        return resolved;
    }
}

