/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.storage.impl.memory.ODataSegmentMemory;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageMemory
extends OStorageEmbedded {
    private final List<ODataSegmentMemory> dataSegments = new ArrayList<ODataSegmentMemory>();
    private final List<OClusterMemory> clusters = new ArrayList<OClusterMemory>();
    private final Map<String, OClusterMemory> clusterMap = new HashMap<String, OClusterMemory>();
    private int defaultClusterId = 0;

    public OStorageMemory(String iURL) {
        super(iURL, iURL, "rw");
        this.configuration = new OStorageConfiguration(this);
    }

    @Override
    public void create(Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        try {
            try {
                this.addDataSegment("default");
                this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "internal", null, null, new Object[0]);
                this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "index", null, null, new Object[0]);
                this.defaultClusterId = this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "default", null, null, new Object[0]);
                this.configuration.create();
                this.status = OStorage.STATUS.OPEN;
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw new OStorageException("Error on creation of storage: " + this.name, e);
            }
            Object var4_2 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        if (this.status == OStorage.STATUS.OPEN) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            if (!this.exists()) {
                throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
            }
            this.status = OStorage.STATUS.OPEN;
            Object var5_4 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean iForce) {
        this.lock.acquireExclusiveLock();
        try {
            if (!this.checkForClose(iForce)) {
                Object var5_2 = null;
                this.lock.releaseExclusiveLock();
                return;
            }
            this.status = OStorage.STATUS.CLOSING;
            for (OClusterMemory c : this.clusters) {
                if (c == null) continue;
                c.close();
            }
            this.clusters.clear();
            this.clusterMap.clear();
            for (ODataSegmentMemory d : this.dataSegments) {
                if (d == null) continue;
                d.close();
            }
            this.dataSegments.clear();
            this.level2Cache.shutdown();
            super.close(iForce);
            Orient.instance().unregisterStorage(this);
            this.status = OStorage.STATUS.CLOSED;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        Object var5_3 = null;
        this.lock.releaseExclusiveLock();
    }

    @Override
    public void delete() {
        this.close(true);
    }

    @Override
    public void reload() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        iClusterName = iClusterName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            int clusterId = this.clusters.size();
            for (int i = 0; i < this.clusters.size(); ++i) {
                if (this.clusters.get(i) != null) continue;
                clusterId = i;
                break;
            }
            OClusterMemory cluster = new OClusterMemory();
            cluster.configure(this, clusterId, iClusterName, iLocation, this.getDataSegmentIdByName(iDataSegmentName), iParameters);
            if (clusterId == this.clusters.size()) {
                this.clusters.add(cluster);
            } else {
                this.clusters.set(clusterId, cluster);
            }
            this.clusterMap.put(iClusterName, cluster);
            int n = clusterId;
            Object var10_10 = null;
            this.lock.releaseExclusiveLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropCluster(int iClusterId) {
        this.lock.acquireExclusiveLock();
        try {
            block4: {
                try {
                    OCluster c = this.clusters.get(iClusterId);
                    if (c == null) break block4;
                    c.delete();
                    this.clusters.set(iClusterId, null);
                    this.getLevel2Cache().freeCluster(iClusterId);
                    this.clusterMap.remove(c.getName());
                }
                catch (IOException iOException) {
                    Object var4_5 = null;
                    this.lock.releaseExclusiveLock();
                }
            }
            Object var4_4 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropDataSegment(String iName) {
        ODataSegment data;
        int id;
        block5: {
            this.lock.acquireExclusiveLock();
            id = this.getDataSegmentIdByName(iName);
            data = this.dataSegments.get(id);
            if (data != null) break block5;
            boolean bl = false;
            Object var6_7 = null;
            this.lock.releaseExclusiveLock();
            return bl;
        }
        try {
            data.drop();
            this.dataSegments.set(id, null);
            this.configuration.dropCluster(id);
            boolean bl = true;
            Object var6_8 = null;
            this.lock.releaseExclusiveLock();
            return bl;
        }
        catch (Exception e) {
            try {
                OLogManager.instance().exception("Error while removing data segment '" + iName + "'", e, OStorageException.class, new Object[0]);
                Object var6_9 = null;
                this.lock.releaseExclusiveLock();
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.lock.releaseExclusiveLock();
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDataSegment(String iDataSegmentName) {
        this.lock.acquireExclusiveLock();
        try {
            this.dataSegments.add(new ODataSegmentMemory(iDataSegmentName, this.dataSegments.size()));
            int n = this.dataSegments.size() - 1;
            Object var4_3 = null;
            this.lock.releaseExclusiveLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    @Override
    public int addDataSegment(String iSegmentName, String iLocation) {
        return this.addDataSegment(iSegmentName);
    }

    @Override
    public OPhysicalPosition createRecord(int iDataSegmentId, ORecordId iRid, byte[] iContent, int iRecordVersion, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        OPhysicalPosition oPhysicalPosition;
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            ODataSegmentMemory data = (ODataSegmentMemory)this.getDataSegmentById(iDataSegmentId);
            long offset = data.createRecord(iContent);
            OCluster cluster = this.getClusterById(iRid.clusterId);
            OPhysicalPosition ppos = new OPhysicalPosition(iDataSegmentId, offset, iRecordType);
            cluster.addPhysicalPosition(ppos);
            iRid.clusterPosition = ppos.clusterPosition;
            if (iCallback != null) {
                iCallback.call(iRid, iRid.clusterPosition);
            }
            oPhysicalPosition = ppos;
            Object var17_15 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.createRecord", timer);
        }
        catch (IOException e) {
            try {
                throw new OStorageException("Error on create record in cluster: " + iRid.clusterId, e);
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.createRecord", timer);
                throw throwable;
            }
        }
        return oPhysicalPosition;
    }

    @Override
    public ORawBuffer readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        return this.readRecord(this.getClusterById(iRid.clusterId), iRid, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            try {
                OPhysicalPosition ppos;
                block8: {
                    ORawBuffer oRawBuffer;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                    long lastPos = iClusterSegment.getLastEntryPosition();
                    if (iRid.clusterPosition > lastPos) {
                        throw new ORecordNotFoundException("Record " + iRid + " is outside cluster size. Valid range for cluster '" + iClusterSegment.getName() + "' is 0-" + lastPos);
                    }
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (ppos != null) break block8;
                        oRawBuffer = null;
                        Object var12_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                        throw throwable;
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                    Object var14_13 = null;
                    this.lock.releaseSharedLock();
                    OProfiler.getInstance().stopChrono("OStorageMemory.readRecord", timer);
                    return oRawBuffer;
                }
                ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
                ORawBuffer oRawBuffer = new ORawBuffer(dataSegment.readRecord(ppos.dataSegmentPos), ppos.recordVersion, ppos.recordType);
                Object var12_11 = null;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                Object var14_14 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.readRecord", timer);
                return oRawBuffer;
            }
            catch (IOException e) {
                throw new OStorageException("Error on read record in cluster: " + iClusterSegment.getId(), e);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.readRecord", timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<Integer> iCallback) {
        long timer = OProfiler.getInstance().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lock.acquireSharedLock();
        try {
            try {
                OPhysicalPosition ppos;
                block13: {
                    int n;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = cluster.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (ppos != null) break block13;
                        if (iCallback != null) {
                            iCallback.call(iRid, -1);
                        }
                        n = -1;
                        Object var14_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var16_16 = null;
                    this.lock.releaseSharedLock();
                    OProfiler.getInstance().stopChrono("OStorageMemory.updateRecord", timer);
                    return n;
                }
                if (iVersion != -1) {
                    if (iVersion > -1) {
                        if (iVersion != ppos.recordVersion) {
                            throw new OConcurrentModificationException("Cannot update record " + iRid + " because the version is not the latest. Probably you are updating an old record or it has been modified by another user (db=v" + ppos.recordVersion + " your=v" + iVersion + ")", iRid, ppos.recordVersion, iVersion);
                        }
                        ++ppos.recordVersion;
                    } else {
                        --ppos.recordVersion;
                    }
                }
                ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
                dataSegment.updateRecord(ppos.dataSegmentPos, iContent);
                if (iCallback != null) {
                    iCallback.call(null, ppos.recordVersion);
                }
                int n = ppos.recordVersion;
                Object var14_14 = null;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var16_17 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.updateRecord", timer);
                return n;
            }
            catch (IOException e) {
                throw new OStorageException("Error on update record " + iRid, e);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.updateRecord", timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        long timer = OProfiler.getInstance().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lock.acquireSharedLock();
        try {
            try {
                OPhysicalPosition ppos;
                block10: {
                    boolean bl;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = cluster.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (ppos != null) break block10;
                        if (iCallback != null) {
                            iCallback.call(iRid, false);
                        }
                        bl = false;
                        Object var12_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_13 = null;
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var14_14 = null;
                    this.lock.releaseSharedLock();
                    OProfiler.getInstance().stopChrono("OStorageMemory.deleteRecord", timer);
                    return bl;
                }
                if (iVersion > -1 && ppos.recordVersion != iVersion) {
                    throw new OConcurrentModificationException("Cannot delete record " + iRid + " because the version is not the latest. Probably you are deleting an old record or it has been modified by another user (db=v" + ppos.recordVersion + " your=v" + iVersion + ")", iRid, ppos.recordVersion, iVersion);
                }
                cluster.removePhysicalPosition(iRid.clusterPosition);
                ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
                dataSegment.deleteRecord(ppos.dataSegmentPos);
                if (iCallback != null) {
                    iCallback.call(null, true);
                }
                boolean bl = true;
                Object var12_12 = null;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var14_15 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono("OStorageMemory.deleteRecord", timer);
                return bl;
            }
            catch (IOException e) {
                throw new OStorageException("Error on delete record " + iRid, e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.deleteRecord", timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int iClusterId) {
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            long l = cluster.getEntries();
            Object var6_4 = null;
            this.lock.releaseSharedLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getClusterDataRange(int iClusterId) {
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            long[] lArray = new long[]{cluster.getFirstEntryPosition(), cluster.getLastEntryPosition()};
            Object var5_4 = null;
            this.lock.releaseSharedLock();
            return lArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds) {
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            for (int i = 0; i < iClusterIds.length; ++i) {
                OCluster cluster = this.clusters.get(iClusterIds[i]);
                if (cluster == null) continue;
                tot += cluster.getEntries();
            }
            long l = tot;
            Object var7_6 = null;
            this.lock.releaseSharedLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            OCluster oCluster = this.clusterMap.get(iClusterName.toLowerCase());
            Object var4_3 = null;
            this.lock.releaseSharedLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusterIdByName(String iClusterName) {
        OCluster cluster;
        block3: {
            iClusterName = iClusterName.toLowerCase();
            this.lock.acquireSharedLock();
            try {
                cluster = this.clusterMap.get(iClusterName.toLowerCase());
                if (cluster != null) break block3;
                int n = -1;
                Object var5_5 = null;
                this.lock.releaseSharedLock();
                return n;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
        }
        int n = cluster.getId();
        Object var5_6 = null;
        this.lock.releaseSharedLock();
        return n;
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        return "MEMORY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        String string;
        this.lock.acquireSharedLock();
        try {
            for (int i = 0; i < this.clusters.size(); ++i) {
                OCluster cluster = this.clusters.get(i);
                if (cluster == null || cluster.getId() != iClusterId) continue;
                String string2 = cluster.getName();
                Object var6_6 = null;
                this.lock.releaseSharedLock();
                return string2;
            }
            string = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        Object var6_7 = null;
        this.lock.releaseSharedLock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClusterNames() {
        this.lock.acquireSharedLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            Object var3_2 = null;
            this.lock.releaseSharedLock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(OTransaction iTx) {
        this.lock.acquireExclusiveLock();
        try {
            try {
                ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                    for (ORecordOperation oRecordOperation : iTx.getCurrentRecordEntries()) {
                        tmpEntries.add(oRecordOperation);
                    }
                    iTx.clearRecordEntries();
                    for (ORecordOperation oRecordOperation : tmpEntries) {
                        this.commitEntry(iTx, oRecordOperation);
                    }
                    tmpEntries.clear();
                }
                OTransactionAbstract.updateCacheFromEntries(this, iTx, iTx.getAllRecordEntries(), true);
            }
            catch (IOException e) {
                this.rollback(iTx);
                Object var6_9 = null;
                this.lock.releaseExclusiveLock();
            }
            Object var6_8 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    @Override
    public void rollback(OTransaction iTx) {
    }

    @Override
    public void synch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        this.lock.acquireSharedLock();
        try {
            boolean bl = !this.clusters.isEmpty();
            Object var3_2 = null;
            this.lock.releaseSharedLock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODataSegment getDataSegmentById(int iDataId) {
        this.lock.acquireSharedLock();
        try {
            if (iDataId < 0 || iDataId > this.dataSegments.size() - 1) {
                throw new IllegalArgumentException("Invalid data segment id " + iDataId + ". Range is 0-" + (this.dataSegments.size() - 1));
            }
            ODataSegment oDataSegment = this.dataSegments.get(iDataId);
            Object var4_3 = null;
            this.lock.releaseSharedLock();
            return oDataSegment;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        if (iDataSegmentName == null) {
            return 0;
        }
        this.lock.acquireSharedLock();
        try {
            ODataSegmentMemory d;
            Iterator<ODataSegmentMemory> i$ = this.dataSegments.iterator();
            do {
                if (!i$.hasNext()) throw new IllegalArgumentException("Data segment '" + iDataSegmentName + "' does not exist in storage '" + this.name + "'");
            } while (!(d = i$.next()).getName().equalsIgnoreCase(iDataSegmentName));
            int n = d.getId();
            Object var6_5 = null;
            this.lock.releaseSharedLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = this.clusters.get(iClusterId);
            Object var4_3 = null;
            this.lock.releaseSharedLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            Object var3_2 = null;
            this.lock.releaseSharedLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends OCluster> getClusterInstances() {
        this.lock.acquireSharedLock();
        try {
            Collection<OClusterMemory> collection = Collections.unmodifiableCollection(this.clusters);
            Object var3_2 = null;
            this.lock.releaseSharedLock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long size = 0L;
        this.lock.acquireSharedLock();
        try {
            for (ODataSegmentMemory d : this.dataSegments) {
                if (d == null) continue;
                size += d.getSize();
            }
            Object var6_4 = null;
            this.lock.releaseSharedLock();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        block4: {
            if (ppos.dataSegmentId > 0) {
                return false;
            }
            this.lock.acquireSharedLock();
            try {
                ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
                if (ppos.dataSegmentPos < (long)dataSegment.count()) break block4;
                boolean bl = false;
                Object var5_4 = null;
                this.lock.releaseSharedLock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.lock.releaseSharedLock();
        return true;
    }

    private void commitEntry(OTransaction iTx, ORecordOperation txEntry) throws IOException {
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        OCluster cluster = this.getClusterById(rid.clusterId);
        rid.clusterId = cluster.getId();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
        }
        switch (txEntry.type) {
            case 0: {
                break;
            }
            case 3: {
                if (!rid.isNew()) break;
                byte[] stream = txEntry.getRecord().toStream();
                if (rid.isNew()) {
                    txEntry.getRecord().onBeforeIdentityChanged(rid);
                    OPhysicalPosition ppos = this.createRecord(txEntry.dataSegmentId, rid, stream, 0, txEntry.getRecord().getRecordType(), 0, null);
                    txEntry.getRecord().setVersion(ppos.recordVersion);
                    txEntry.getRecord().onAfterIdentityChanged(txEntry.getRecord());
                    break;
                }
                txEntry.getRecord().setVersion(this.updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                break;
            }
            case 1: {
                byte[] stream = txEntry.getRecord().toStream();
                txEntry.getRecord().setVersion(this.updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                break;
            }
            case 2: {
                this.deleteRecord(rid, txEntry.getRecord().getVersion(), 0, null);
            }
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    @Override
    public String getURL() {
        return "memory:" + this.url;
    }

    public OStorageConfigurationSegment getConfigurationSegment() {
        return null;
    }

    public void renameCluster(String iOldName, String iNewName) {
        OClusterMemory cluster = (OClusterMemory)this.getClusterByName(iOldName);
        if (cluster != null) {
            try {
                cluster.set(OCluster.ATTRIBUTES.NAME, iNewName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

