/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private boolean usingLog = OGlobalConfiguration.TX_USE_LOG.getValueAsBoolean();
    private static AtomicInteger txSerial = new AtomicInteger();

    public OTransactionOptimistic(ODatabaseRecordTx iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
    }

    @Override
    public void begin() {
        this.status = OTransaction.TXSTATUS.BEGUN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit() {
        Iterator i$2;
        this.checkTransaction();
        this.status = OTransaction.TXSTATUS.COMMITTING;
        if (!(this.database.getStorage() instanceof OStorageEmbedded)) {
            this.database.getStorage().commit(this);
            return;
        }
        List<String> involvedIndexes = this.getInvolvedIndexes();
        if (involvedIndexes != null) {
            Collections.sort(involvedIndexes);
        }
        ArrayList<OIndexMVRBTreeAbstract> lockedIndexes = null;
        try {
            if (involvedIndexes != null) {
                for (String indexName : involvedIndexes) {
                    OIndexMVRBTreeAbstract index = (OIndexMVRBTreeAbstract)this.database.getMetadata().getIndexManager().getIndexInternal(indexName);
                    if (lockedIndexes == null) {
                        lockedIndexes = new ArrayList();
                    }
                    index.acquireExclusiveLock();
                    lockedIndexes.add(index);
                }
            }
            Collection<? extends OIndex<?>> indexes = this.database.getMetadata().getIndexManager().getIndexes();
            ArrayList indexesToLock = null;
            if (indexes != null) {
                indexesToLock = new ArrayList(indexes);
                Collections.sort(indexesToLock, new Comparator<OIndex<?>>(){

                    @Override
                    public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                        return indexOne.getName().compareTo(indexTwo.getName());
                    }
                });
            }
            if (indexesToLock != null && !indexesToLock.isEmpty() && lockedIndexes == null) {
                lockedIndexes = new ArrayList<OIndexMVRBTreeAbstract>();
            }
            for (OIndex oIndex : indexesToLock) {
                for (Map.Entry entry : this.recordEntries.entrySet()) {
                    Object record = ((ORecordOperation)entry.getValue()).record.getRecord();
                    if (!(record instanceof ODocument)) continue;
                    ODocument doc = (ODocument)record;
                    if (lockedIndexes.contains(oIndex.getInternal()) || doc.getSchemaClass() == null || oIndex.getDefinition() == null || !doc.getSchemaClass().isSubClassOf(oIndex.getDefinition().getClassName())) continue;
                    ((OIndexMVRBTreeAbstract)oIndex.getInternal()).acquireExclusiveLock();
                    lockedIndexes.add((OIndexMVRBTreeAbstract)oIndex.getInternal());
                }
            }
            this.database.getStorage().callInLock(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    OTransactionOptimistic.this.database.getStorage().commit(OTransactionOptimistic.this);
                    ODocument indexEntries = OTransactionOptimistic.this.getIndexChanges();
                    if (indexEntries != null) {
                        for (Map.Entry<String, Object> indexEntry : indexEntries) {
                            OIndex<?> index = OTransactionOptimistic.this.database.getMetadata().getIndexManager().getIndexInternal(indexEntry.getKey());
                            index.commit((ODocument)indexEntry.getValue());
                        }
                    }
                    return null;
                }
            }, true);
            Object var12_11 = null;
            if (lockedIndexes == null) return;
            i$2 = lockedIndexes.iterator();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (lockedIndexes == null) throw throwable;
            Iterator i$2 = lockedIndexes.iterator();
            while (i$2.hasNext()) {
                OIndexMVRBTreeAbstract index = (OIndexMVRBTreeAbstract)i$2.next();
                index.releaseExclusiveLock();
            }
            throw throwable;
        }
        while (i$2.hasNext()) {
            OIndexMVRBTreeAbstract index = (OIndexMVRBTreeAbstract)i$2.next();
            index.releaseExclusiveLock();
        }
    }

    @Override
    public void rollback() {
        this.checkTransaction();
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        this.database.getLevel1Cache().clear();
        for (ORecordOperation v : this.recordEntries.values()) {
            v.getRecord().unload();
        }
        for (ORecordOperation v : this.allEntries.values()) {
            v.getRecord().unload();
        }
        this.indexEntries.clear();
    }

    @Override
    public ORecordInternal<?> loadRecord(ORID iRid, ORecordInternal<?> iRecord, String iFetchPlan) {
        this.checkTransaction();
        ORecordInternal<?> txRecord = this.getRecord(iRid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            return txRecord;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, iFetchPlan, false);
    }

    @Override
    public void deleteRecord(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public void saveRecord(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        if (iRecord == null) {
            return;
        }
        this.addRecord(iRecord, iRecord.getIdentity().isValid() ? (byte)1 : 3, iClusterName);
    }

    protected void addRecord(ORecordInternal<?> iRecord, byte iStatus, String iClusterName) {
        this.checkTransaction();
        switch (iStatus) {
            case 3: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord);
                break;
            }
            case 0: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_READ, iRecord);
                break;
            }
            case 1: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord);
                break;
            }
            case 2: {
                this.database.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, iRecord);
            }
        }
        if (iRecord.getIdentity().isTemporary()) {
            this.temp2persistent.put(iRecord.getIdentity().copy(), iRecord);
        }
        if (this.status == OTransaction.TXSTATUS.COMMITTING && this.database.getStorage() instanceof OStorageEmbedded) {
            switch (iStatus) {
                case 1: 
                case 3: {
                    this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getVersion(), iRecord.getRecordType(), false, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, null);
                    break;
                }
                case 2: {
                    this.database.executeDeleteRecord(iRecord, iRecord.getVersion(), false, false, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS);
                }
            }
        } else {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            if (!rid.isValid()) {
                iRecord.onBeforeIdentityChanged(rid);
                if (rid.clusterId == -1) {
                    rid.clusterId = iClusterName != null ? this.database.getClusterIdByName(iClusterName) : this.database.getDefaultClusterId();
                }
                rid.clusterPosition = this.newObjectCounter--;
                iRecord.onAfterIdentityChanged(iRecord);
            } else {
                this.database.getLevel1Cache().freeRecord(rid);
            }
            ORecordOperation txEntry = this.getRecordEntry(rid);
            if (txEntry == null) {
                if (!rid.isTemporary() || iStatus == 3) {
                    txEntry = new ORecordOperation(iRecord, iStatus);
                    this.recordEntries.put(rid, txEntry);
                }
            } else {
                txEntry.record = iRecord;
                switch (txEntry.type) {
                    case 0: {
                        switch (iStatus) {
                            case 1: {
                                txEntry.type = 1;
                                break;
                            }
                            case 2: {
                                txEntry.type = (byte)2;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (iStatus) {
                            case 2: {
                                txEntry.type = (byte)2;
                            }
                        }
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        switch (iStatus) {
                            case 2: {
                                this.recordEntries.remove(rid);
                            }
                        }
                    }
                }
            }
        }
        switch (iStatus) {
            case 3: {
                this.database.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, iRecord);
                break;
            }
            case 0: {
                this.database.callbackHooks(ORecordHook.TYPE.AFTER_READ, iRecord);
                break;
            }
            case 1: {
                this.database.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, iRecord);
                break;
            }
            case 2: {
                this.database.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, iRecord);
            }
        }
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.recordEntries.size() + ", idxEntries=" + this.indexEntries.size() + "]";
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }
}

