/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OObjectNotDetachedException;
import com.orientechnologies.orient.object.dictionary.ODictionaryWrapper;
import com.orientechnologies.orient.object.iterator.OObjectIteratorClass;
import com.orientechnologies.orient.object.iterator.OObjectIteratorCluster;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.util.ArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ODatabaseObjectTx
extends ODatabasePojoAbstract<Object>
implements ODatabaseObject,
OUserObject2RecordHandler {
    public static final String TYPE = "object";
    protected ODictionary<Object> dictionary;
    protected OEntityManager entityManager;
    protected boolean saveOnlyDirty;
    protected boolean lazyLoading;

    public ODatabaseObjectTx(String iURL) {
        super(new ODatabaseDocumentTx(iURL));
        ((ODatabaseDocumentTx)this.underlying).setDatabaseOwner(this);
        this.init();
    }

    @Override
    public <T> T newInstance(Class<T> iType) {
        return (T)this.newInstance(iType.getName());
    }

    @Override
    public <RET> RET newInstance(String iClassName) {
        this.checkSecurity("database.class", ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            return (RET)this.entityManager.createPojo(iClassName);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on creating object of class " + iClassName, (Throwable)e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass) {
        return this.browseClass(iClusterClass, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass, boolean iPolymorphic) {
        if (iClusterClass == null) {
            return null;
        }
        return this.browseClass(iClusterClass.getSimpleName(), iPolymorphic);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName, boolean iPolymorphic) {
        this.checkOpeness();
        this.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iClassName);
        return new OObjectIteratorClass(this, (ODatabaseRecordAbstract)this.getUnderlying().getUnderlying(), iClassName, iPolymorphic);
    }

    public <RET> OObjectIteratorCluster<RET> browseCluster(String iClusterName) {
        this.checkOpeness();
        this.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)iClusterName);
        return new OObjectIteratorCluster(this, (ODatabaseRecordAbstract)this.getUnderlying().getUnderlying(), this.getClusterIdByName(iClusterName));
    }

    @Override
    public Object load(Object iPojo) {
        return this.load(iPojo, (String)null);
    }

    public Object reload(Object iPojo) {
        return this.reload(iPojo, (String)null, true);
    }

    @Override
    public Object reload(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iPojo == null) {
            return iPojo;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        ((ODatabaseDocumentTx)this.underlying).reload(record, iFetchPlan, iIgnoreCache);
        this.stream2pojo(record, iPojo, iFetchPlan);
        return iPojo;
    }

    @Override
    public Object load(Object iPojo, String iFetchPlan) {
        return this.load(iPojo, iFetchPlan, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(record, iFetchPlan, iIgnoreCache);
            this.stream2pojo(record, iPojo, iFetchPlan);
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this;
    }

    @Override
    public Object load(ORID iRecordId) {
        return this.load(iRecordId, (String)null);
    }

    @Override
    public Object load(ORID iRecordId, String iFetchPlan) {
        return this.load(iRecordId, iFetchPlan, false);
    }

    @Override
    public Object load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iRecordId == null) {
            return null;
        }
        ODocument record = (ODocument)this.rid2Records.get(iRecordId);
        if (record == null && (record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache)) == null) {
            return null;
        }
        Object result = this.records2Objects.get(record);
        if (result != null) {
            return result;
        }
        result = this.stream2pojo(record, this.newInstance(record.getClassName()), iFetchPlan);
        this.registerUserObject(result, record);
        return result;
    }

    @Override
    public Object save(Object iContent) {
        return this.save(iContent, (String)null, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    @Override
    public <RET> RET save(Object iContent, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return this.save(iContent, (String)null, iMode, iCallback);
    }

    @Override
    public Object save(Object iPojo, String iClusterName) {
        return this.save(iPojo, iClusterName, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <RET> RET save(Object iPojo, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        this.checkOpeness();
        if (iPojo == null) {
            return null;
        }
        if (OMultiValue.isMultiValue(iPojo)) {
            for (Object pojo : OMultiValue.getMultiValueIterable(iPojo)) {
                this.save(pojo, iClusterName);
            }
            return (RET)iPojo;
        } else {
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
            ODocument record = this.getRecordByUserObject(iPojo, true);
            try {
                record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
                if (this.saveOnlyDirty && !record.isDirty()) return (RET)iPojo;
                this.pojo2Stream(iPojo, record);
                ((ODatabaseDocumentTx)this.underlying).save(record, iClusterName, iMode, iCallback);
                this.registerUserObject(iPojo, record);
                return (RET)iPojo;
            }
            finally {
                record.setInternalStatus(ORecordElement.STATUS.LOADED);
            }
        }
    }

    public ODatabaseObject delete(Object iPojo) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid == null) {
                throw new OObjectNotDetachedException("Cannot retrieve the object's ID for '" + iPojo + "' because has not been detached");
            }
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(rid);
        }
        ((ODatabaseDocumentTx)this.underlying).delete(record);
        if (this.getTransaction() instanceof OTransactionNoTx) {
            this.unregisterPojo(iPojo, record);
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName);
    }

    public long countClass(Class<?> iClass) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClass.getSimpleName());
    }

    @Override
    public ODictionary<Object> getDictionary() {
        this.checkOpeness();
        if (this.dictionary == null) {
            this.dictionary = new ODictionaryWrapper(this);
        }
        return this.dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabasePojoAbstract<Object> commit() {
        try {
            ((ODatabaseRecordTx)((ODatabaseDocumentTx)this.underlying).getUnderlying()).commit();
            if (this.getTransaction().getAllRecordEntries() != null) {
                Object pojo = null;
                for (ORecordOperation oRecordOperation : this.getTransaction().getAllRecordEntries()) {
                    pojo = this.records2Objects.get(oRecordOperation.getRecord());
                    if (pojo == null) continue;
                    switch (oRecordOperation.type) {
                        case 3: {
                            this.rid2Records.put(oRecordOperation.getRecord().getIdentity(), (ODocument)oRecordOperation.getRecord());
                            OObjectSerializerHelper.setObjectID(oRecordOperation.getRecord().getIdentity(), pojo);
                        }
                        case 1: {
                            OObjectSerializerHelper.setObjectVersion(oRecordOperation.getRecord().getVersion(), pojo);
                            break;
                        }
                        case 2: {
                            OObjectSerializerHelper.setObjectID(null, pojo);
                            OObjectSerializerHelper.setObjectVersion(null, pojo);
                            this.unregisterPojo(pojo, (ODocument)oRecordOperation.getRecord());
                        }
                    }
                }
            }
        }
        finally {
            this.getTransaction().close();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabasePojoAbstract<Object> rollback() {
        try {
            Object pojo;
            ArrayList<ORecordOperation> newEntries;
            if (this.getTransaction().getCurrentRecordEntries() != null) {
                newEntries = new ArrayList<ORecordOperation>();
                for (ORecordOperation oRecordOperation : this.getTransaction().getCurrentRecordEntries()) {
                    if (oRecordOperation.type != 3) continue;
                    newEntries.add(oRecordOperation);
                }
            } else {
                newEntries = null;
            }
            ((ODatabaseRecordTx)((ODatabaseDocumentTx)this.underlying).getUnderlying()).rollback();
            if (newEntries != null) {
                Object pojo2 = null;
                for (ORecordOperation entry : newEntries) {
                    pojo2 = this.records2Objects.get(entry.getRecord());
                    OObjectSerializerHelper.setObjectID(null, pojo2);
                    OObjectSerializerHelper.setObjectVersion(null, pojo2);
                }
            }
            if (this.getTransaction().getCurrentRecordEntries() != null) {
                for (ORecordOperation oRecordOperation : this.getTransaction().getCurrentRecordEntries()) {
                    this.rid2Records.remove(oRecordOperation.getRecord().getIdentity());
                    pojo = this.records2Objects.remove(oRecordOperation.getRecord());
                    if (pojo == null) continue;
                    this.objects2Records.remove(pojo);
                }
            }
            if (this.getTransaction().getAllRecordEntries() != null) {
                for (ORecordOperation oRecordOperation : this.getTransaction().getAllRecordEntries()) {
                    this.rid2Records.remove(oRecordOperation.getRecord().getIdentity());
                    pojo = this.records2Objects.remove(oRecordOperation.getRecord());
                    if (pojo == null) continue;
                    this.objects2Records.remove(pojo);
                }
            }
        }
        finally {
            this.getTransaction().close();
        }
        return this;
    }

    @Override
    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public ODatabaseDocument getUnderlying() {
        return (ODatabaseDocument)this.underlying;
    }

    @Override
    public int getVersion(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getVersion();
        }
        return OObjectSerializerHelper.getObjectVersion(iPojo);
    }

    @Override
    public ORID getIdentity(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getIdentity();
        }
        return OObjectSerializerHelper.getObjectID(this, iPojo);
    }

    public boolean isSaveOnlyDirty() {
        return this.saveOnlyDirty;
    }

    public void setSaveOnlyDirty(boolean saveOnlyDirty) {
        this.saveOnlyDirty = saveOnlyDirty;
    }

    @Override
    public Object newInstance() {
        this.checkOpeness();
        return new ODocument();
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, byte iOperation) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, int iOperation, Object iResourceSpecific) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, int iOperation, Object ... iResourcesSpecific) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourcesSpecific);
    }

    @Override
    public ODocument pojo2Stream(Object iPojo, ODocument iRecord) {
        return OObjectSerializerHelper.toStream(iPojo, iRecord, this.getEntityManager(), this.getMetadata().getSchema().getClass(iPojo.getClass().getSimpleName()), this, this, this.saveOnlyDirty);
    }

    @Override
    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iRecord = (ODocument)iRecord.load();
        }
        return OObjectSerializerHelper.fromStream(iRecord, iPojo, this.getEntityManager(), this, iFetchPlan, this.lazyLoading);
    }

    @Override
    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    @Override
    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected void init() {
        this.entityManager = OEntityManager.getEntityManagerByDatabaseURL(this.getURL());
        this.saveOnlyDirty = OGlobalConfiguration.OBJECT_SAVE_ONLY_DIRTY.getValueAsBoolean();
        OObjectSerializerHelper.register();
        this.lazyLoading = true;
    }
}

