/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OLazyObjectListInterface;
import com.orientechnologies.orient.core.db.object.OLazyObjectMultivalueElement;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OLazyObjectIterator;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OLazyObjectList<TYPE>
implements OLazyObjectListInterface<TYPE>,
OLazyObjectMultivalueElement,
Serializable {
    private static final long serialVersionUID = 289711963195698937L;
    private ORecord<?> sourceRecord;
    private final ArrayList<Object> list = new ArrayList();
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;

    public OLazyObjectList() {
    }

    public OLazyObjectList(ORecord<?> iSourceRecord, Collection<?> iSourceList) {
        this.sourceRecord = iSourceRecord;
        if (iSourceList != null) {
            this.list.addAll(iSourceList);
        }
    }

    public OLazyObjectList(ORecord<?> iSourceRecord) {
        this.sourceRecord = iSourceRecord;
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OLazyObjectIterator((ODatabasePojoAbstract)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner(), this.sourceRecord, this.list.iterator(), this.convertToRecord);
    }

    @Override
    public boolean contains(Object o) {
        this.convertAll();
        return this.list.contains(o);
    }

    @Override
    public boolean add(TYPE element) {
        if (this.converted && element instanceof ORID) {
            this.converted = false;
        }
        this.setDirty();
        return this.list.add(element);
    }

    @Override
    public void add(int index, TYPE element) {
        if (this.converted && element instanceof ORID) {
            this.converted = false;
        }
        this.setDirty();
        this.list.add(index, element);
    }

    @Override
    public TYPE get(int index) {
        this.convert(index);
        return (TYPE)this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.convertAll();
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.convertAll();
        return this.list.lastIndexOf(o);
    }

    @Override
    public Object[] toArray() {
        this.convertAll();
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.convertAll();
        return this.list.toArray(a);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.convertAll();
        this.setDirty();
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.convertAll();
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        this.setDirty();
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TYPE> c) {
        this.setDirty();
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.convertAll();
        this.setDirty();
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.convertAll();
        this.setDirty();
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.setDirty();
        this.list.clear();
    }

    @Override
    public TYPE set(int index, TYPE element) {
        this.convert(index);
        this.setDirty();
        return (TYPE)this.list.set(index, element);
    }

    @Override
    public TYPE remove(int index) {
        this.convert(index);
        this.setDirty();
        return (TYPE)this.list.remove(index);
    }

    @Override
    public ListIterator<TYPE> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<TYPE> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<TYPE> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OLazyObjectList<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    @Override
    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public boolean isConverted() {
        return this.converted;
    }

    @Override
    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.convert(i);
        }
        this.converted = true;
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    private void convert(int iIndex) {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        Object o = this.list.get(iIndex);
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (o != null) {
            ODocument doc = new ODocument();
            if (o instanceof ORID) {
                doc = (ODocument)database.load((ORID)o, this.fetchPlan);
            } else if (o instanceof ODocument) {
                doc = (ODocument)o;
            }
            this.list.set(iIndex, OObjectEntityEnhancer.getInstance().getProxiedInstance(doc.getClassName(), ((ODatabaseObject)database.getDatabaseOwner()).getEntityManager(), doc, new Object[0]));
        }
    }

    public String toString() {
        return this.list.toString();
    }
}

