/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectLazyIterator<TYPE>
implements Iterator<TYPE>,
Serializable {
    private static final long serialVersionUID = -4012483076050044405L;
    private final ORecord<?> sourceRecord;
    private final ODatabasePojoAbstract<TYPE> database;
    private final Iterator<? extends Object> underlying;
    private String fetchPlan;
    private final boolean autoConvert2Object;

    public OObjectLazyIterator(ODatabasePojoAbstract<TYPE> database, ORecord<?> iSourceRecord, Iterator<? extends Object> iIterator, boolean iConvertToRecord) {
        this.database = database;
        this.sourceRecord = iSourceRecord;
        this.underlying = iIterator;
        this.autoConvert2Object = iConvertToRecord;
    }

    @Override
    public TYPE next() {
        return this.next(this.fetchPlan);
    }

    public TYPE next(String iFetchPlan) {
        Object value = this.underlying.next();
        if (value == null) {
            return null;
        }
        if (value instanceof ORID && this.autoConvert2Object) {
            return this.database.getUserObjectByRecord((ORecordInternal)((ODatabaseRecord)this.database.getUnderlying()).load((ORID)value, iFetchPlan), iFetchPlan);
        }
        if (value instanceof ODocument && this.autoConvert2Object) {
            return this.database.getUserObjectByRecord((ODocument)value, iFetchPlan);
        }
        if (OObjectEntitySerializer.isToSerialize(value.getClass())) {
            return (TYPE)OObjectEntitySerializer.deserializeFieldValue(value.getClass(), value);
        }
        return (TYPE)value;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }
}

