/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OLazyObjectMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.object.db.OObjectLazyList;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.db.OObjectLazySet;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.serialization.OLazyObjectCustomSerializer;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerList;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerMap;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerSet;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectProxyMethodHandler
implements MethodHandler {
    protected ODocument doc;
    protected Map<String, Integer> loadedFields;

    public OObjectProxyMethodHandler(ODocument iDocument) {
        this.doc = iDocument;
        if (!((ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner()).isLazyLoading()) {
            this.doc.detach();
        }
        this.loadedFields = new HashMap<String, Integer>();
    }

    public ODocument getDoc() {
        return this.doc;
    }

    public void setDoc(ODocument iDoc) {
        this.doc = iDoc;
    }

    @Override
    public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
        if (this.isSetterMethod(m.getName(), m)) {
            return this.manageSetMethod(self, m, proceed, args);
        }
        if (this.isGetterMethod(m.getName(), m)) {
            return this.manageGetMethod(self, m, proceed, args);
        }
        if (m.getName().equals("equals") && args[0] != null && args[0] instanceof Proxy) {
            return (Boolean)proceed.invoke(self, args) != false && this.doc.equals(OObjectEntitySerializer.getDocument((Proxy)args[0]));
        }
        if (m.getName().equals("hashCode")) {
            return this.doc.hashCode() + (Integer)proceed.invoke(self, args);
        }
        return proceed.invoke(self, args);
    }

    protected Object manageGetMethod(Object self, Method m, Method proceed, Object[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException, IllegalArgumentException, NoSuchFieldException {
        Object docValue;
        String fieldName = this.getFieldName(m);
        boolean idOrVersionField = false;
        if (OObjectEntitySerializer.isIdField(m.getDeclaringClass(), fieldName)) {
            idOrVersionField = true;
            OObjectEntitySerializer.setIdField(m.getDeclaringClass(), self, this.doc.getIdentity());
        } else if (OObjectEntitySerializer.isVersionField(m.getDeclaringClass(), fieldName)) {
            idOrVersionField = true;
            if (this.doc.getIdentity().isValid() && !this.doc.getIdentity().isTemporary()) {
                OObjectEntitySerializer.setVersionField(m.getDeclaringClass(), self, this.doc.getVersion());
            }
        }
        Cloneable value = proceed.invoke(self, args);
        if (!idOrVersionField && value != null && (Number.class.isAssignableFrom(value.getClass()) && ((Number)((Object)value)).doubleValue() == 0.0 || Boolean.class.isAssignableFrom(value.getClass())) && (docValue = this.doc.field(fieldName)) != null && !docValue.equals(value)) {
            value = this.lazyLoadField(self, fieldName, docValue);
        }
        if (!idOrVersionField) {
            if (value == null) {
                docValue = this.doc.field(fieldName, OType.getTypeByClass(this.getField(fieldName, self.getClass()).getType()));
                if (docValue != null) {
                    value = this.lazyLoadField(self, fieldName, docValue);
                }
            } else if ((value instanceof Collection || value instanceof Map) && !(value instanceof OLazyObjectMultivalueElement) || value.getClass().isArray()) {
                Class<?> genericMultiValueType = OReflectionHelper.getGenericMultivalueType(this.getField(fieldName, self.getClass()));
                if (genericMultiValueType != null && !OReflectionHelper.isJavaType(genericMultiValueType)) {
                    if (OObjectEntitySerializer.isSerializedType(this.getField(fieldName, self.getClass())) && !(value instanceof OLazyObjectCustomSerializer)) {
                        this.manageSerializedCollections(self, fieldName, value);
                    } else {
                        value = this.manageObjectCollections(self, fieldName, value);
                    }
                } else {
                    Object docValue2 = this.doc.field(fieldName);
                    if (docValue2 == null) {
                        if (value.getClass().isArray()) {
                            OClass schemaClass = this.doc.getSchemaClass();
                            OProperty schemaProperty = null;
                            if (schemaClass != null) {
                                schemaProperty = schemaClass.getProperty(fieldName);
                            }
                            this.doc.field(fieldName, OObjectEntitySerializer.typeToStream(value, schemaProperty != null ? schemaProperty.getType() : null, this.getDatabase(), this.doc));
                        } else {
                            this.doc.field(fieldName, value);
                        }
                    } else if (!this.loadedFields.containsKey(fieldName)) {
                        value = this.manageArrayFieldObject(fieldName, self, docValue2);
                        Method setMethod = this.getSetMethod(self.getClass().getSuperclass(), this.getSetterFieldName(fieldName), value);
                        setMethod.invoke(self, value);
                    } else if ((value instanceof Set || value instanceof Map) && this.loadedFields.get(fieldName) < this.doc.getVersion()) {
                        value = value instanceof Set ? new OObjectLazySet(this.doc, (Set)docValue2) : new OObjectLazyMap(this.doc, (Map)docValue2);
                        Method setMethod = this.getSetMethod(self.getClass().getSuperclass(), this.getSetterFieldName(fieldName), value);
                        setMethod.invoke(self, value);
                    }
                }
            }
        }
        if (this.doc.getIdentity().isValid() && !this.doc.getIdentity().isTemporary()) {
            this.loadedFields.put(fieldName, this.doc.getVersion());
        } else {
            this.loadedFields.put(fieldName, 0);
        }
        return value;
    }

    protected Object manageObjectCollections(Object self, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (value instanceof Collection) {
            value = this.manageCollectionSave(fieldName, (Collection)value);
        } else if (value instanceof Map) {
            value = this.manageMapSave(fieldName, (Map)value);
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(this.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageSerializedCollections(Object self, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (value instanceof Collection) {
            if (value instanceof List) {
                ArrayList<Object> docList = (ArrayList<Object>)this.doc.field(fieldName);
                if (docList == null) {
                    docList = new ArrayList<Object>();
                    this.doc.field(fieldName, docList);
                }
                value = new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, (List<Object>)docList, value);
            } else if (value instanceof Set) {
                HashSet<Object> docSet = (HashSet<Object>)this.doc.field(fieldName, OType.LINKSET);
                if (docSet == null) {
                    docSet = new HashSet<Object>();
                    this.doc.field(fieldName, docSet);
                }
                value = new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, docSet, (Set)((Object)value));
            }
        } else if (value instanceof Map) {
            HashMap<Object, Object> docMap = (HashMap<Object, Object>)this.doc.field(fieldName);
            if (docMap == null) {
                docMap = new HashMap<Object, Object>();
                this.doc.field(fieldName, docMap);
            }
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, docMap, (Map)((Object)value));
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(this.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageArraySave(String iFieldName, Object[] value) {
        Object o;
        if (value.length > 0 && (o = value[0]) instanceof Proxy) {
            ODocument[] newValue = new ODocument[value.length];
            for (int i = 0; i < value.length; ++i) {
                newValue[i] = value[i] != null ? OObjectEntitySerializer.getDocument((Proxy)value[i]) : null;
            }
            this.doc.field(iFieldName, newValue);
        }
        return value;
    }

    protected Object manageMapSave(String iFieldName, Map<?, ?> value) {
        if (!(value instanceof OLazyObjectMultivalueElement)) {
            Map docMap = (Map)this.doc.field(iFieldName);
            if (docMap == null) {
                docMap = new ORecordLazyMap(this.doc);
                this.doc.field(iFieldName, docMap);
            }
            value = new OObjectLazyMap(this.doc, docMap, value);
        }
        return value;
    }

    protected Object manageCollectionSave(String iFieldName, Collection<?> value) {
        if (!(value instanceof OLazyObjectMultivalueElement)) {
            if (value instanceof List) {
                List docList = (List)this.doc.field(iFieldName);
                if (docList == null) {
                    docList = new ORecordLazyList(this.doc);
                    this.doc.field(iFieldName, docList);
                }
                value = new OObjectLazyList(this.doc, docList, value);
            } else if (value instanceof Set) {
                Set docSet = (Set)this.doc.field(iFieldName, OType.LINKSET);
                if (docSet == null) {
                    docSet = new ORecordLazySet(this.doc);
                    this.doc.field(iFieldName, docSet);
                }
                value = new OObjectLazySet(this.doc, docSet, (Set)value);
            }
        }
        if (!((ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner()).isLazyLoading()) {
            ((OLazyObjectMultivalueElement)((Object)value)).detach();
        }
        return value;
    }

    protected Object lazyLoadField(Object self, String fieldName, Object docValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean customSerialization = false;
        if (OObjectEntitySerializer.isSerializedType(this.getField(fieldName, self.getClass()))) {
            customSerialization = true;
        }
        if (docValue instanceof OIdentifiable) {
            docValue = this.convertDocumentToObject((ODocument)((OIdentifiable)docValue).getRecord());
        } else if (docValue instanceof Collection) {
            docValue = this.manageCollectionLoad(fieldName, self, docValue, customSerialization);
        } else if (docValue instanceof Map) {
            docValue = this.manageMapLoad(fieldName, self, docValue, customSerialization);
        } else if (docValue.getClass().isArray() && !docValue.getClass().getComponentType().isPrimitive()) {
            docValue = this.manageArrayLoad(docValue);
        } else if (customSerialization) {
            docValue = OObjectEntitySerializer.deserializeFieldValue(this.getField(fieldName, self.getClass()).getType(), docValue);
        }
        OObjectEntitySerializer.setFieldValue(this.getField(fieldName, self.getClass()), self, docValue);
        return docValue;
    }

    protected Object manageArrayLoad(Object value) {
        Object o;
        if (((Object[])value).length > 0 && (o = ((Object[])value)[0]) instanceof OIdentifiable) {
            Object[] newValue = new Object[((Object[])value).length];
            for (int i = 0; i < ((Object[])value).length; ++i) {
                ODocument doc = (ODocument)((OIdentifiable)((Object[])value)[i]).getRecord();
                newValue[i] = OObjectEntitySerializer.getDocument((Proxy)((Object)doc));
            }
            value = newValue;
        }
        return value;
    }

    protected Object manageMapLoad(String fieldName, Object self, Object value, boolean customSerialization) {
        if (value instanceof ORecordLazyMap) {
            value = new OObjectLazyMap(this.doc, (ORecordLazyMap)value);
        } else if (customSerialization) {
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, value);
        }
        return value;
    }

    protected Object manageCollectionLoad(String fieldName, Object self, Object value, boolean customSerialization) {
        if (value instanceof ORecordLazyList) {
            value = new OObjectLazyList(this.doc, (ORecordLazyList)value);
        } else if (value instanceof ORecordLazySet || value instanceof OMVRBTreeRIDSet) {
            value = new OObjectLazySet(this.doc, (Set)value);
        } else if (customSerialization) {
            value = value instanceof List ? new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, (List<Object>)value) : new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, (Set)value);
        }
        return this.manageArrayFieldObject(fieldName, self, value);
    }

    protected Object manageArrayFieldObject(String fieldName, Object self, Object value) {
        Field field = this.getField(fieldName, self.getClass());
        if (field.getType().isArray()) {
            Collection collectionValue = (Collection)value;
            Object newArray = Array.newInstance(field.getType().getComponentType(), collectionValue.size());
            int i = 0;
            for (Object collectionItem : collectionValue) {
                Array.set(newArray, i, collectionItem);
                ++i;
            }
            return newArray;
        }
        return value;
    }

    protected Object convertDocumentToObject(ODocument value) {
        return OObjectEntityEnhancer.getInstance().getProxiedInstance(value.getClassName(), this.getDatabase().getEntityManager(), value, new Object[0]);
    }

    protected Object manageSetMethod(Object self, Method m, Method proceed, Object[] args) throws IllegalAccessException, InvocationTargetException {
        String fieldName = this.getFieldName(m);
        Object valueToSet = args[0];
        if (valueToSet == null) {
            this.doc.field(fieldName, valueToSet);
        } else if (valueToSet instanceof Proxy) {
            this.doc.field(fieldName, OObjectEntitySerializer.getDocument((Proxy)valueToSet));
        } else if (valueToSet instanceof Collection || valueToSet instanceof Map || valueToSet.getClass().isArray()) {
            Class<?> genericMultiValueType = OReflectionHelper.getGenericMultivalueType(this.getField(fieldName, self.getClass()));
            if (genericMultiValueType != null && !OReflectionHelper.isJavaType(genericMultiValueType)) {
                if (!(valueToSet instanceof OLazyObjectMultivalueElement)) {
                    if (valueToSet instanceof Collection) {
                        valueToSet = this.manageCollectionSave(fieldName, (Collection)valueToSet);
                    } else if (valueToSet instanceof Map) {
                        valueToSet = this.manageMapSave(fieldName, (Map)valueToSet);
                    } else if (valueToSet.getClass().isArray()) {
                        valueToSet = this.manageArraySave(fieldName, (Object[])valueToSet);
                    }
                }
            } else if (OObjectEntitySerializer.isToSerialize(valueToSet.getClass())) {
                this.doc.field(fieldName, OObjectEntitySerializer.serializeFieldValue(this.getField(fieldName, self.getClass()).getType(), valueToSet));
            } else if (valueToSet.getClass().isArray()) {
                OClass schemaClass = this.doc.getSchemaClass();
                OProperty schemaProperty = null;
                if (schemaClass != null) {
                    schemaProperty = schemaClass.getProperty(fieldName);
                }
                this.doc.field(fieldName, OObjectEntitySerializer.typeToStream(valueToSet, schemaProperty != null ? schemaProperty.getType() : null, this.getDatabase(), this.doc));
            } else {
                this.doc.field(fieldName, valueToSet);
            }
        } else if (OObjectEntitySerializer.isToSerialize(valueToSet.getClass())) {
            this.doc.field(fieldName, OObjectEntitySerializer.serializeFieldValue(this.getField(fieldName, self.getClass()).getType(), valueToSet));
        } else {
            this.doc.field(fieldName, valueToSet);
        }
        args[0] = valueToSet;
        this.loadedFields.put(fieldName, this.doc.getVersion());
        return proceed.invoke(self, args);
    }

    protected boolean isSetterMethod(String fieldName, Method m) {
        if (!fieldName.startsWith("set") || !this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "set")) {
            return false;
        }
        return m.getParameterTypes() == null || m.getParameterTypes().length == 1;
    }

    protected boolean isGetterMethod(String fieldName, Method m) {
        int prefixLength;
        if (fieldName.startsWith("get") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "get")) {
            prefixLength = "get".length();
        } else if (fieldName.startsWith("is") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "is")) {
            prefixLength = "is".length();
        } else {
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
            return false;
        }
        return fieldName.length() > prefixLength;
    }

    protected boolean checkIfFirstCharAfterPrefixIsUpperCase(String methodName, String prefix) {
        return methodName.length() > prefix.length() ? Character.isUpperCase(methodName.charAt(prefix.length())) : false;
    }

    protected String getFieldName(Method m) {
        if (m.getName().startsWith("get")) {
            return this.getFieldName(m.getName(), "get");
        }
        if (m.getName().startsWith("set")) {
            return this.getFieldName(m.getName(), "set");
        }
        return this.getFieldName(m.getName(), "is");
    }

    protected String getFieldName(String methodName, String prefix) {
        StringBuffer fieldName = new StringBuffer();
        fieldName.append(Character.toLowerCase(methodName.charAt(prefix.length())));
        for (int i = prefix.length() + 1; i < methodName.length(); ++i) {
            fieldName.append(methodName.charAt(i));
        }
        return fieldName.toString();
    }

    protected String getSetterFieldName(String fieldName) {
        StringBuffer methodName = new StringBuffer("set");
        methodName.append(Character.toUpperCase(fieldName.charAt(0)));
        for (int i = 1; i < fieldName.length(); ++i) {
            methodName.append(fieldName.charAt(i));
        }
        return methodName.toString();
    }

    protected Method getSetMethod(Class<?> iClass, String fieldName, Object value) throws NoSuchMethodException {
        for (Method m : iClass.getDeclaredMethods()) {
            if (!m.getName().equals(fieldName) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(value.getClass())) continue;
            return m;
        }
        if (iClass.getSuperclass().equals(Object.class)) {
            return null;
        }
        return this.getSetMethod(iClass.getSuperclass(), fieldName, value);
    }

    protected Field getField(String fieldName, Class<?> iClass) {
        for (Field f : iClass.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        if (iClass.getSuperclass().equals(Object.class)) {
            return null;
        }
        return this.getField(fieldName, iClass.getSuperclass());
    }

    private ODatabaseObject getDatabase() {
        return (ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner();
    }
}

