/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa;

import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.object.db.ODatabaseObjectTx;
import com.orientechnologies.orient.object.jpa.OJPAEntityTransaction;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OJPAEntityManager
implements EntityManager {
    private ODatabaseObjectTx database;
    private FlushModeType flushMode = FlushModeType.AUTO;
    private EntityTransaction transaction;

    public OJPAEntityManager(Map<?, ?> map) {
        String url = (String)map.get("url");
        this.database = new ODatabaseObjectTx(url);
        this.transaction = new OJPAEntityTransaction(this.database);
    }

    @Override
    public void persist(Object entity) {
        this.database.save(entity);
    }

    @Override
    public <T> T merge(T entity) {
        throw new UnsupportedOperationException("merge");
    }

    @Override
    public void remove(Object entity) {
        this.database.delete(entity);
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        ORecordId rid;
        if (primaryKey instanceof ORecordId) {
            rid = (ORecordId)primaryKey;
        } else if (primaryKey instanceof String) {
            rid = new ORecordId((String)primaryKey);
        } else if (primaryKey instanceof Number) {
            OClass cls = this.database.getMetadata().getSchema().getClass(entityClass);
            if (cls == null) {
                throw new IllegalArgumentException("Class '" + entityClass + "' is not configured in the database");
            }
            rid = new ORecordId(cls.getDefaultClusterId(), ((Number)primaryKey).longValue());
        } else {
            throw new IllegalArgumentException("PrimaryKey '" + primaryKey + "' type (" + primaryKey.getClass() + ") is not supported");
        }
        return (T)this.database.load(rid);
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        throw new UnsupportedOperationException("merge");
    }

    @Override
    public void flush() {
        if (this.flushMode == FlushModeType.COMMIT) {
            this.database.commit();
        }
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        throw new UnsupportedOperationException("lock");
    }

    @Override
    public void refresh(Object entity) {
        this.database.load(entity);
    }

    @Override
    public void clear() {
        if (this.flushMode == FlushModeType.COMMIT) {
            this.database.rollback();
        }
    }

    @Override
    public boolean contains(Object entity) {
        return this.database.isManaged(entity);
    }

    @Override
    public Query createQuery(String qlString) {
        throw new UnsupportedOperationException("createQuery");
    }

    @Override
    public Query createNamedQuery(String name) {
        throw new UnsupportedOperationException("createNamedQuery");
    }

    @Override
    public Query createNativeQuery(String sqlString) {
        throw new UnsupportedOperationException("createNativeQuery");
    }

    @Override
    public Query createNativeQuery(String sqlString, Class resultClass) {
        throw new UnsupportedOperationException("createNativeQuery");
    }

    @Override
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        throw new UnsupportedOperationException("createNativeQuery");
    }

    @Override
    public void joinTransaction() {
        throw new UnsupportedOperationException("joinTransaction");
    }

    @Override
    public Object getDelegate() {
        return this.database;
    }

    @Override
    public EntityTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void close() {
        this.database.close();
    }

    @Override
    public boolean isOpen() {
        return !this.database.isClosed();
    }
}

