/*
 * Decompiled with CFR 0.152.
 */
package net.lisanza.CliArgs;

import net.lisanza.CliArgs.ArgsException;
import net.lisanza.CliArgs.ArgsHandlerInterface;
import net.lisanza.CliArgs.ArgsReader;

public class ArgsExample
extends ArgsReader {
    public ArgsExample() throws ArgsException {
        this.addHandler(new BoolValue());
        this.addHandler(new MultiValues());
    }

    public static void main(String[] args) {
        try {
            ArgsExample reader = new ArgsExample();
            reader.parse(args);
            System.out.println("arguments parsed succesfully");
        }
        catch (ArgsException e) {
            System.out.println(e.getMessage());
        }
    }

    private class TestError
    implements ArgsHandlerInterface {
        @Override
        public int parse(String[] args, int idx) throws ArgsException {
            throw new ArgsException();
        }

        @Override
        public String argument() {
            return "e";
        }

        @Override
        public String usage() {
            return "TestError";
        }
    }

    private class MultiValues
    implements ArgsHandlerInterface {
        @Override
        public int parse(String[] args, int idx) throws ArgsException {
            ++idx;
            while (idx < args.length && args[idx].charAt(0) != '-') {
            }
            return idx;
        }

        @Override
        public String argument() {
            return "-m";
        }

        @Override
        public String usage() {
            return "<..> <..>";
        }
    }

    private class BoolValue
    implements ArgsHandlerInterface {
        @Override
        public int parse(String[] args, int idx) throws ArgsException {
            return ++idx;
        }

        @Override
        public String argument() {
            return "-t";
        }

        @Override
        public String usage() {
            return "bool value";
        }
    }
}

