/*
 * Decompiled with CFR 0.152.
 */
package net.lisanza.CliArgs;

import java.util.Enumeration;
import java.util.Vector;
import net.lisanza.CliArgs.ArgsException;
import net.lisanza.CliArgs.ArgsHandlerInterface;
import net.lisanza.CliArgs.ArgsReaderInterface;

public class ArgsReader
implements ArgsReaderInterface {
    protected Vector<ArgsHandlerInterface> arguments = new Vector();

    public ArgsReader() throws ArgsException {
        this.addHandler(new Help());
    }

    public void addHandler(ArgsHandlerInterface h) throws ArgsException {
        String arg = h.argument();
        if (arg.charAt(0) != '-') {
            ArgsException.invalidRegistration(arg);
        }
        this.arguments.add(h);
    }

    @Override
    public void parse(String[] args) throws ArgsException {
        try {
            this.parse_internal(args, 0);
        }
        catch (ArgsException e) {
            throw new ArgsException(e.getMessage() + this.usage());
        }
    }

    protected int parse_internal(String[] args, int idx) throws ArgsException {
        if (args.length == 0) {
            ArgsException.missingArgs();
        }
        while (idx < args.length) {
            try {
                if (args[idx].charAt(0) == '-') {
                    Enumeration<ArgsHandlerInterface> e = this.arguments.elements();
                    boolean found = false;
                    while (!found && e.hasMoreElements()) {
                        ArgsHandlerInterface h = e.nextElement();
                        if (!h.argument().equals(args[idx])) continue;
                        idx = h.parse(args, idx);
                        found = true;
                    }
                    if (found) continue;
                    if (args[idx].equals("--")) {
                        return ++idx;
                    }
                    ArgsException.unknownArgument(args[idx]);
                    continue;
                }
                ArgsException.badArgument(args[idx]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ArgsException.missingValue(args[idx]);
            }
        }
        if (idx < args.length) {
            ArgsException.notParsed(args, idx);
        }
        return idx;
    }

    public String usage() {
        String msg = "\nUsage:";
        Enumeration<ArgsHandlerInterface> e = this.arguments.elements();
        while (e.hasMoreElements()) {
            ArgsHandlerInterface h = e.nextElement();
            msg = msg + "\n" + h.argument() + "\t: " + h.usage();
        }
        return msg;
    }

    private class Help
    implements ArgsHandlerInterface {
        @Override
        public int parse(String[] args, int idx) throws ArgsException {
            throw new ArgsException(args[idx], "Help information");
        }

        @Override
        public String argument() {
            return "-h";
        }

        @Override
        public String usage() {
            return "Help";
        }
    }
}

