/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.objectmetamodel.DataContainer;
import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;

public class MarshalledObjectForLocalCalls
implements Externalizable {
    private static final long serialVersionUID = 785809358605094514L;
    private static final Logger log = Logger.getLogger(ClassMetaData.class);
    private static final boolean isDebug = log.isDebugEnabled();
    DataContainer container;

    public MarshalledObjectForLocalCalls() {
    }

    public MarshalledObjectForLocalCalls(Object obj) throws IOException {
        this.container = new DataContainer(false);
        ObjectOutput output = this.container.getOutput();
        output.writeObject(obj);
        output.flush();
        this.container.flush();
    }

    public MarshalledObjectForLocalCalls(Object obj, SafeCloningRepository safeToReuse) throws IOException {
        this.container = new DataContainer(null, null, safeToReuse, false, null);
        ObjectOutput output = this.container.getOutput();
        output.writeObject(obj);
        output.flush();
        this.container.flush();
    }

    public Object get() throws IOException, ClassNotFoundException {
        try {
            this.container.getCache().setLoader(Thread.currentThread().getContextClassLoader());
            return this.container.getInput().readObject();
        }
        catch (RuntimeException e) {
            log.error(e, e);
            throw e;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (isDebug) {
            log.debug("writeExternal");
        }
        this.container.saveData(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (isDebug) {
            log.debug("readExternal");
        }
        this.container = new DataContainer(false);
        this.container.loadData(in);
    }
}

