/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.SMIAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;

public class GenericAddress
extends SMIAddress {
    static final long serialVersionUID = -6102594326202231511L;
    public static final String TYPE_UDP = "udp";
    public static final String TYPE_TCP = "tcp";
    public static final String TYPE_IP = "ip";
    public static final String ADDRESS_TYPES_PROPERTIES = "org.snmp4j.addresses";
    private static final String ADDRESS_TYPES_PROPERTIES_DEFAULT = "address.properties";
    private static final LogAdapter logger = LogFactory.getLogger(GenericAddress.class);
    private SMIAddress address;
    private static Map knownAddressTypes = null;

    public GenericAddress() {
    }

    public GenericAddress(SMIAddress address) {
        this.address = address;
    }

    public int getSyntax() {
        return this.address.getSyntax();
    }

    public boolean isValid() {
        if (this.address == null) {
            return false;
        }
        return this.address.isValid();
    }

    public String toString() {
        return this.address.toString();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public int compareTo(Object o) {
        return this.address.compareTo(o);
    }

    public boolean equals(Object o) {
        return this.address.equals(o);
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        this.address.encodeBER(outputStream);
    }

    public int getBERLength() {
        return this.address.getBERLength();
    }

    public void setAddress(SMIAddress address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    private static synchronized void registerAddressTypes() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String addresses;
            InputStream is = Variable.class.getResourceAsStream(addresses = System.getProperty(ADDRESS_TYPES_PROPERTIES, ADDRESS_TYPES_PROPERTIES_DEFAULT));
            if (is == null) {
                throw new InternalError("Could not read '" + addresses + "' from classpath!");
            }
            Properties props = new Properties();
            try {
                props.load(is);
                TreeMap h = new TreeMap();
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String id = (String)en.nextElement();
                    String className = props.getProperty(id);
                    try {
                        Class<?> c = Class.forName(className);
                        h.put(id, c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        logger.error(cnfe);
                    }
                }
                knownAddressTypes = h;
            }
            catch (IOException iox) {
                String txt = "Could not read '" + addresses + "': " + iox.getMessage();
                logger.error(txt);
                throw new InternalError(txt);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    logger.warn(ex);
                }
            }
        }
        TreeMap<String, Class> h = new TreeMap<String, Class>();
        h.put(TYPE_UDP, UdpAddress.class);
        h.put(TYPE_TCP, TcpAddress.class);
        h.put(TYPE_IP, IpAddress.class);
        knownAddressTypes = h;
    }

    public static Address parse(String address) {
        Class c;
        if (knownAddressTypes == null) {
            GenericAddress.registerAddressTypes();
        }
        String type = TYPE_UDP;
        int sep = address.indexOf(58);
        if (sep > 0) {
            type = address.substring(0, sep);
            address = address.substring(sep + 1);
        }
        if ((c = (Class)knownAddressTypes.get(type = type.toLowerCase())) == null) {
            throw new IllegalArgumentException("Address type " + type + " unknown");
        }
        try {
            Address addr = (Address)c.newInstance();
            if (addr.parseAddress(address)) {
                return addr;
            }
            return null;
        }
        catch (Exception ex) {
            logger.warn(ex);
            return null;
        }
    }

    public boolean parseAddress(String address) {
        Address addr = GenericAddress.parse(address);
        if (addr instanceof SMIAddress) {
            this.setAddress((SMIAddress)addr);
            return true;
        }
        return false;
    }

    public Object clone() {
        return new GenericAddress(this.address);
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public OID toSubIndex(boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String value) {
        if (!this.parseAddress(value)) {
            throw new IllegalArgumentException(value + " cannot be parsed by " + this.getClass().getName());
        }
    }
}

