/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import org.snmp4j.SNMP4JSettings;
import org.snmp4j.util.ThreadFactory;
import org.snmp4j.util.WorkerTask;

public class DefaultThreadFactory
implements ThreadFactory {
    private long joinTimeout = SNMP4JSettings.getThreadJoinTimeout();

    public WorkerTask createWorkerThread(String name, WorkerTask task, boolean daemon) {
        WorkerThread wt = new WorkerThread(name, task);
        wt.thread.setDaemon(daemon);
        return wt;
    }

    public void setThreadJoinTimeout(long millis) {
        this.joinTimeout = millis;
    }

    public class WorkerThread
    implements WorkerTask {
        private Thread thread;
        private WorkerTask task;
        private boolean started = false;

        public WorkerThread(String name, WorkerTask task) {
            this.thread = new Thread((Runnable)task, name);
            this.task = task;
        }

        public void terminate() {
            this.task.terminate();
        }

        public void join() throws InterruptedException {
            this.task.join();
            this.thread.join(DefaultThreadFactory.this.joinTimeout);
        }

        public void run() {
            if (!this.started) {
                this.started = true;
                this.thread.start();
            } else {
                this.thread.run();
            }
        }

        public void interrupt() {
            this.task.interrupt();
            this.thread.interrupt();
        }
    }
}

