#!/bin/bash

DIR=`pwd`
JBOSS=/opt/jboss
POWERPRO=$JBOSS/server/powerpro

rel=$(cat /etc/redhat-release |grep 6.)

if [ -z "$rel" ]; then
  echo "This installer is for CentOS 6"
  exit 1;
fi

INSTALL_DB=Y
INSTALL_JBOSS=Y
INSTALL_AGENT=Y
INSTALL_WEB=Y
INSTALL_STREAMER=Y

case "$1" in
  agent)
    INSTALL_DB=N
    INSTALL_JBOSS=N
    INSTALL_WEB=N
	  INSTALL_STREAMER=N
    ;;
  firebird)
    INSTALL_JBOSS=N
    INSTALL_AGENT=N
	  INSTALL_STREAMER=N
    ;;
  jboss)
    INSTALL_AGENT=N
    INSTALL_DB=N
	  INSTALL_STREAMER=N
    ;;
  streamer)
    INSTALL_AGENT=N
    INSTALL_WEB=N
    ;;
  all)
    echo "Full install"
    ;;
  *)
    echo "Possible parameters are agent|firebird|jboss|all"
    exit 0;
    ;;
esac

echo $DIR

if [ -f /etc/sysconfig/powerpro ]; then
 . /etc/sysconfig/powerpro
fi 

if [ $INSTALL_JBOSS = "Y" ]; then
  # Add users
  tryJboss=`grep jboss /etc/passwd`
  if [ -z $tryJboss ]; then 
    echo Creating user jboss
    adduser jboss
  fi
fi

if [ $INSTALL_AGENT = "Y" ]; then 
  tryPowerpro=`grep powerpro /etc/passwd`
  if [ -z $tryPowerpro ]; then 
    echo Creating user powerpro
    adduser powerpro
	# Limit SSH access to ssh group
	groupadd ssh
	usermod -g ssh root
	echo "#AllowGroups ssh" >> /etc/ssh/sshd_config
	echo "You can activate ssh access to group ssh by removing the # from last line in /etc/ssh/sshd_config"
	echo "In order to add user to group ssh use usermod -g ssh <username>"
  fi
fi

echo Press Enter to continue
read

# Install necessary packages
if [ $INSTALL_AGENT = "Y" ]; then 
  UNINSTALL=
  SNMP_PACK='net-snmp-utils net-snmp-devel net-snmp-libs '
  SERVER_PACK='dhcp tftp-server rsh-server ntp mysql-server vsftpd '
  DOCSIS_PACK='bison flex make gcc libtool automake glib2-devel '
fi

if [ $INSTALL_WEB = "Y" ]; then 
  SERVER_PACK=$SERVER_PACK' httpd '
fi

if [ $INSTALL_DB = "Y" ]; then
  yum install https://dl.fedoraproject.org/pub/epel/epel-release-latest-6.noarch.rpm
  FB_PACK=' libtommath icu '
fi
PACKAGES_TO_INSTALL=$PACKAGES_TO_INSTALL$SNMP_PACK$SERVER_PACK$FB_PACK$DOCSIS_PACK'mc unzip zip man man-pages traceroute mailx sudo'
echo $PACKAGES_TO_INSTALL

if [ $INSTALL_AGENT = "Y" ]; then 
  if [ ! -f /etc/rsyslog.conf ]; then
    PACKAGES_TO_INSTALL=$PACKAGES_TO_INSTALL' rsyslog'
    UNINSTALL='sysklogd'
  fi 
fi

yum install $PACKAGES_TO_INSTALL

if [ ! -z $UNINSTALL ]; then 
  yum remove $UNINSTALL
  echo Press Enter to continue
  read
fi

echo Press Enter to continue
read

#Install jdk
if [ $? -ne 0 ]; then
  echo "Installing JDK"
  echo ""

  yum -y install java-1.8.0-openjdk

  echo "JAVAPATH=/usr/lib/jvm/jre" >> /etc/sysconfig/powerpro
fi

if [ -z $JBOSS_BIND_ADDRESS ]; then 
  primary_ip=`hostname -I`
  echo "JBOSS_BIND_ADDRESS=$primary_ip" >> /etc/sysconfig/powerpro
fi

#setup tmp directory
if [ ! -d /tmp/powerpro ]; then 
  mkdir /tmp/powerpro
fi

if [ $INSTALL_DB = "Y" ]; then 
	#install Firebird
	if [ $? -eq 0 ]; then
	  tryFB=`grep firebird /etc/passwd`
	  INSTALL_FB=
	  # Check that there is firebird user
	  if [ -z "$tryFB" ]; then 
		INSTALL_FB=YES
	  fi

	  # Check that firebird directory exists
	  if [ ! -d /opt/firebird ]; then
		if [ -z $INSTALL_FB ]; then
		   INSTALL_FB=YES
		fi
	  fi

	  if [ ! -z $INSTALL_FB ]; then 
		if [ $HOSTTYPE = "x86_64" ]; then  
		  FB_ARCH=amd64
		else 
		  FB_ARCH=i686
		fi

		cd $DIR
		FB_ARCHIVE=`ls FirebirdCS*$FB_ARCH.tar.gz`
		if [ ! -z "$FB_ARCHIVE" ]; then
		  echo "Installing $FB_ARCHIVE"
		  echo ""
		  echo "Press Enter to continue"

		  cd /tmp/powerpro
		  rm -rf *
		  echo $DIR"/"$FB_ARCHIVE

		  tar -xzvf $DIR"/"$FB_ARCHIVE
		  FB_DIR=`ls -d FirebirdCS*`
		  if [ $? -ne 0 ]; then 
			echo ""
			echo "Error while processing Firebird installation archive!"
			exit 1;
		  fi
		  cd $FB_DIR

		  ./install.sh
		else
		  echo ""
		  echo "Unable to find Firebird installation archive!"
		  exit 1;
		fi
	  fi 

	  ALIASES=/opt/firebird/aliases.conf
	  tryDataDir=`grep powerpro $ALIASES`
	  if [ -z $tryDataDir ]; then 
		echo "Append powerpro related aliases to aliases.conf"  
		cd $DIR
		cat aliases.conf >> $ALIASES
	  fi
	  
	  if [ $INSTALL_STREAMER = "Y" ]; then
		tryDataDir=`grep streamer $ALIASES`
		if [ -z $tryDataDir ]; then 
		    echo "Append streamer alieas to aliases.conf"  
		    cd $DIR
		    echo "streamer=/opt/firebird/data/streamer.fdb"	>> $ALIASES	
		fi
	  fi
	  
	  DATA_DIR=/opt/firebird/data
	  if [ ! -d $DATA_DIR ]; then 
		echo "Creating data directory"
		mkdir $DATA_DIR
	  fi
	  
	  chown -R firebird:firebird $DATA_DIR

	  echo '' >> /etc/sysctl.conf
	  echo '# Increase the number of semaphores to 128 ' >> /etc/sysctl.conf
	  echo "kernel.sem=250 32000 100 128" >> /etc/sysctl.conf
	  sysctl -p > /dev/null 2>&1
	  
	  echo 'Now edit /opt/firebird/firebird.conf and uncomment LockSem and change its value to 128'
	  echo "Press Enter to continue"
	  read
	fi
fi

if [ $INSTALL_JBOSS = "Y" ]; then 
	# Install jboss and powerpro configuration
	if [ ! -d $JBOSS ]; then
	  cd /opt || exit

	  unzip "$DIR"/billing/jboss.zip

		cd $JBOSS/bin || exit
		cp -f "$DIR"/run.conf.powerpro run.conf

	  cd $JBOSS/server || exit
	  if [ ! -d "$JOBSS"/server/powerpro ]; then
		  unzip "$DIR"/powerpro.zip
		  cp "$DIR"/*.properties $POWERPRO/conf/props/
		  chown jboss:jboss powerpro
		  chown -R jboss:jboss powerpro/data
	  fi

	  cd "$DIR"/centos6 || exit
	  if [ ! -f /etc/rc.d/init.d/powerpro ]; then 
		  cp powerpro.init.d /etc/rc.d/init.d/powerpro
	  fi

	  if [ ! -d /monitoring ]; then   
		mkdir /jrrd
		mkdir /jrrd/modem
		mkdir /jrrd/lan
		mkdir /jrrd/monitoring
		chown -R jboss:jboss /jrrd
	  fi

	  echo 'Please edit data source files in deploy directory and properties in '$POWERPRO'/conf/props'
	  echo 'You can also change default logging level in '$POWERPRO'/conf/jboss-log4j.xml'

	  read
	fi
fi

if [ $INSTALL_STREAMER = "Y" ]; then 
  echo "Install streamer files"
  cd $DIR/streamer || exit
  cp Streaming.war $POWERPRO/deploy
  cp firebird-streamer-ds.xml $POWERPRO/deploy
  cp Settings.properties $POWERPRO/conf

  if [ ! -d /streamer ]; then 
    mkdir /streamer
    chown jboss:jboss /streamer
  fi
  echo "Press Enter to continue"
  read
fi

if [ $INSTALL_AGENT = "Y" ]; then 
	#Install docsis 
	testForDocsis=`which docsis`
	if [ -z $testForDocsis ]; then 
	  echo "Installing docsis utility"
	  cd /tmp/powerpro
	  tar -xzvf $DIR/docsis-0.9.6.tar.gz
	  cd docsis-0.9.6
	  ./configure
	  make
	  make install
	fi

	#cleanup tmp directory
	rm -rf /tmp/powerpro

	# install modem scripts
	if [ ! -d /usr/local/powerpro ]; then 
	  echo "Install powerpro provisioning scripts"
	  mkdir /usr/local/powerpro
	  cd  /usr/local/powerpro
	  cp $DIR/dhcpcontrol .
	  cp $DIR/mdmconfig .
	  cp $DIR/mdmrestart .
	  
	  chmod a+x /usr/local/powerpro/*
	fi
fi

if [ $INSTALL_DB = "Y" ]; then 
	# Setup Web based backup
	cd $DIR
	if [ ! -f /var/www/cgi-bin/get_backup_zip.cgi ]; then
	  cp get_backup_zip.cgi /var/www/cgi-bin/
	fi

	if [ ! -f /opt/firebird/web_backup ]; then
	  cp web_backup /opt/firebird/
	fi

	echo "Installing atuobackup scripts and cron jobs"
	cd $DIR
	# Setup powerpro database autobackup
	function copyToFB {
	  if [ ! -f /opt/firebird/$1 ]; then 
		cp $1 /opt/firebird
		if [ -z $2 ]; then 
		  chmod u+x /opt/firebird/$1
		fi
	  fi
	}

	copyToFB autobackup
	copyToFB cleanup_backup
	copyToFB cleanup_jboss
	copyToFB cleanup_jboss.sql false

	if [ -d /etc/cron.d ]; then 
	  if [ ! -f /etc/cron.d/autobackup.cron ]; then
		cp autobackup.cron /etc/cron.d/
	  fi
	else 
	  tryauto=`grep autobackup /etc/crontab`
	  if [ -z "$tryauto" ]; then
		cat autobackup.cron >> /etc/crontab
	  fi
	fi
fi

# Register services
echo "Initialize services"
cd $DIR
if [ $INSTALL_WEB = "Y" ]; then 
  chkconfig httpd on 
fi
if [ $INSTALL_AGENT = "Y" ]; then 
  chkconfig dhcpd on
  chkconfig rsyslog on
  chkconfig vsftpd on
fi
if [ $INSTALL_JBOSS = "Y" ]; then 
  chkconfig powerpro on
fi

chkconfig ntpd on
chkconfig mysqld on

service xinetd start
service mysqld start

echo Press Enter to continue
read

if [ $INSTALL_DB = "Y" ]; then 
	echo "Do you want to create databases (Enter for NO)?"
	read -a CREATE_DB
	if [ ! -z $CREATE_DB ]; then 
	  ISQL=/opt/firebird/bin/isql
	  GBAK=/opt/firebird/bin/gbak
	  DATA=/opt/firebird/data
	  RESTORE=$GBAK' -R -V -REP -user sysdba -pas masterkey'
	  BACKUP=$GBAK' -B -V -user sysdba -pas masterkey'
	  cd $DIR
	  if [ ! -e $DATA/powerpro.fdb ]; then 
		# Create databases
		$ISQL < create_databases.sql
	  fi

	  if [ -e $DATA/powerpro.fdb -a ! -b $DATA/powerpro.fdb ]; then 
		echo "Do you want to create powerpro database on raw device (Enter for NO)?"
		read -a CREATE_RAW
		if [ ! -z $CREATE_RAW ]; then 
		  $BACKUP localhost:powerpro /tmp/emptypp.bak 
		  rm -rf $DATA/powerpro.fdb
		  echo ""
		  echo "Please enter raw device path(Example: /dev/sda3):"
		  read -a RAW_DEVICE
		  if [ ! -z $RAW_DEVICE ]; then
			echo ""
		   ls -l $RAW_DEVICE
			echo ""       
		   echo "Now use following commands to create node:"
		   echo "     mknod powerpro.fdb b x y"
		   echo ""
		   echo "Where x and y are the values you see in the above listing"
		   echo ""
		   echo "Example : brw-rw---- 1 root disk x, y Jan 1 2012 /dev/sda3"
		   echo ""
		   echo "Press Ctrl+D when ready"
		   cd $DATA
		   bash
		   if [ -b $DATA/powerpro.fdb ]; then 
			 chown firebird:firebird $DATA/powerpro.fdb
			 chmod 0660 $DATA/powerpro.fdb
			 $RESTORE /tmp/emptypp.bak localhost:powerpro
		   else 
			 echo "Unable to find block node "$DATA"/powerpro.fdb"
			 read
		   fi
		  fi
		fi
	  fi
	  
	  cd $DIR
	  # Create database tables
	  if [ ! -f $DATA/jboss.fdb ]; then 
		$ISQL < create_jboss.sql
	  fi
	  if [ ! -f $DATA/monitoring.fdb ]; then 
		$ISQL < create_monitoring.sql
	  fi
	  if [ ! -f $DATA/logger.fdb ]; then 
		$ISQL < create_logger.sql
	  fi
	  
	  if [ ! -f $DATA/streamer.fdb -a $INSTALL_STREAMER = "Y" ]; then
		$ISQL < create_streamer.sql	  
	  fi
	  
	  echo Press Enter to continue
	  read 

	  echo ""
	  echo "Which powerpro database to restore (full, base, Anything else for NO)?"
	  read -a CREATE_DB
	  # Restore initial powerpro database
	  if [ "$CREATE_DB" == "full" ]; then 
		  BAK=powerpro.full.gbk
	  fi

	  if [ "$CREATE_DB" == "base" ]; then 
		  BAK=powerpro.base.gbk
	  fi

	  if [ ! -z $BAK ]; then
		$RESTORE $BAK localhost:powerpro
	  fi
	  echo Press Enter to continue
	  read 
	fi
fi

  # Create MySql database for server message queue
  mysql -e quit server
  if [ $? -eq 1 ]; then 
    echo "Creating MySQL databases"
    if [ $INSTALL_AGENT = "Y" ]; then 
      mysql -u root < create_mysql_server.sql
    fi
    if [ $INSTALL_DB = "Y" ]; then 
      mysql -u root < create_mysql_counters.sql
    fi
  fi

if [ $INSTALL_AGENT = "Y" ]; then 
	# create dhcp directories
	if [ ! -d /home/powerpro/dhcp ]; then 
	  echo "Creating DHCP support files and directories"
	  mkdir /home/powerpro/dhcp
	  cp -f $DIR/dhcpd.* /home/powerpro/
	fi

	if [ ! -d /etc/dhcp ]; then
	  mkdir /etc/dhcp
	fi

	#Setup monitoring agent
	if [ ! -d /opt/powerpro ]; then 
	  mkdir /opt/powerpro
	fi
	if [ ! -d /opt/powerpro/monitor ]; then 
	  mkdir /opt/powerpro/monitor
	fi
	if [ ! -f /opt/powerpro/startup.sh ]; then 
	  cp -f $DIR/monitoring/* /opt/powerpro
	  chmod a+x /opt/powerpro/startup.sh
	  chmod a+x /opt/powerpro/shutdown.sh
	fi

	trystartup=`grep powerpro /etc/rc.local`
	if [ -z "$trystartup" ]; then
	  echo '' >> /etc/rc.local
	  echo '/opt/powerpro/startup.sh' >> /etc/rc.local
	  echo '' >> /etc/rc.local
	fi

	trysyslog=`grep localhost:5140 /etc/rsyslog.conf`
	if [ ! -f /etc/rsyslog.d/powerpro.conf ]; then
	  echo '*.* @localhost:5140' > /etc/rsyslog.d/powerpro.conf
	fi

	service rsyslog start

	#soders changes
	cd $DIR

	if [ ! -d /etc/sudoers.d ]; then 
	  echo 'Now switch to another terminal and run sudoedit /etc/sudoers'
	  echo 'and append the floowing lines to the end of the file'
	  echo 'powerpro ALL=NOPASSWD: /usr/local/powerpro/dhcpcontrol'
	  echo 'powerpro ALL=NOPASSWD: /usr/local/powerpro/mdmconfig'
	  echo 'powerpro ALL=NOPASSWD: /usr/local/powerpro/mdmrestart'
	  echo 'apache ALL=NOPASSWD: /opt/firebird/web_backup'
	  echo 'apache ALL=NOPASSWD: /usr/bin/zip'
	  echo 
	  echo 'Also look for requiretty and comment that line'
	else 
	  SUDO_POWERPRO=/etc/sudoers.d/powerpro
	  echo 'powerpro ALL=NOPASSWD: /usr/local/powerpro/dhcpcontrol' > $SUDO_POWERPRO
	  echo 'powerpro ALL=NOPASSWD: /usr/local/powerpro/mdmconfig' >> $SUDO_POWERPRO
	  echo 'powerpro ALL=NOPASSWD: /usr/local/powerpro/mdmrestart' >> $SUDO_POWERPRO
	  echo 'apache ALL=NOPASSWD: /opt/firebird/web_backup' >> $SUDO_POWERPRO
	  echo 'apache ALL=NOPASSWD: /usr/bin/zip' >> $SUDO_POWERPRO
	  
	  chmod 0440 $SUDO_POWERPRO

	  echo 'Now switch to another terminal and run sudoedit /etc/sudoers'
	  echo 'Please look for requiretty and comment that line.'
	fi 

	echo Press Enter to continue
	read
fi

if [ $INSTALL_DB = "Y" ]; then 
    cp -f $DIR/firebird.powerpro /etc/xinetd.d/firebird
    chmod go-rwx /etc/xinetd.d/firebird
fi

if [ $INSTALL_AGENT = "Y" ]; then 
	echo 'Now edit /etc/xinet.d/rexec and enable the service'
	echo Press Enter to continue
	read

	echo 'Now edit /etc/xinet.d/tftp and enable the service and add -v to server_args'
	echo Press Enter to continue
	read

#	echo 'Now edit /opt/powerpro/startup.sh to update monitoring agent startup configuration'
#	echo Press Enter to continue
#	read
fi