/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.messaging;

import com.dsoft.powerpro.agent.messaging.MessageDistributor;
import com.dsoft.powerpro.agent.messaging.MessageListener;
import com.dsoft.powerpro.agent.messaging.MessagingAgent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.picocontainer.annotations.Inject;

public class MessageDistributorImpl
implements MessageDistributor,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(MessageDistributorImpl.class.getName());
    private MessagingAgent agent;
    private static HashMap<Class<?>, ArrayList<MessageListener>> messageListenersMap = new HashMap();
    private Thread agentThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageListener(Class<?> messageClass, MessageListener listener) {
        HashMap<Class<?>, ArrayList<MessageListener>> hashMap = messageListenersMap;
        synchronized (hashMap) {
            ArrayList<MessageListener> messageListeners;
            do {
                if ((messageListeners = messageListenersMap.get(messageClass)) != null) continue;
                messageListenersMap.put(messageClass, new ArrayList());
            } while (messageListeners == null);
            messageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void distributeMessages(ArrayList<Object> messagesList) {
        HashMap<Class<?>, ArrayList<MessageListener>> hashMap = messageListenersMap;
        synchronized (hashMap) {
            for (ArrayList<MessageListener> arrayList : messageListenersMap.values()) {
                for (MessageListener messageListener : arrayList) {
                    messageListener.beginProcessing();
                }
            }
            for (Object object : messagesList) {
                for (Class clazz : messageListenersMap.keySet()) {
                    if (!clazz.isAssignableFrom(object.getClass())) continue;
                    ArrayList<MessageListener> messageListeners = messageListenersMap.get(clazz);
                    for (MessageListener listener : messageListeners) {
                        listener.processMessage(object);
                    }
                }
            }
            for (ArrayList arrayList : messageListenersMap.values()) {
                for (MessageListener messageListener : arrayList) {
                    messageListener.endProcessing();
                }
            }
        }
    }

    @Override
    public void run() {
        ArrayList<Object> messagesList = new ArrayList<Object>();
        while (!Thread.currentThread().isInterrupted()) {
            messagesList.clear();
            Object message = null;
            do {
                block8: {
                    if (this.agent.getReaderThread() != null) {
                        try {
                            message = this.agent.getReaderThread().peek(20);
                            break block8;
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                if (message instanceof String || message == null) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Message of type %1$s has been received", message.getClass().getSimpleName()));
                }
                messagesList.add(message);
            } while (message != null && messagesList.size() < 50);
            if (messagesList.isEmpty()) continue;
            this.distributeMessages(messagesList);
        }
    }

    @Inject
    public void setMessagingAgent(MessagingAgent agent) {
        this.agent = agent;
    }

    @Inject
    public void setThreadGroup(ThreadGroup threadGroup) {
        this.agentThread = new Thread(threadGroup, this, "Messge distribution thread");
    }

    @PostConstruct
    public void start() {
        this.agentThread.start();
    }

    @PreDestroy
    public void stop() {
        this.agentThread.interrupt();
    }
}

