/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.messaging;

import com.dsoft.framework.util.client.StringUtil;
import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.messaging.ConnectionListener;
import com.dsoft.powerpro.agent.messaging.MessagingAgent;
import com.dsoft.powerpro.agent.messaging.ReaderThread;
import com.dsoft.powerpro.agent.messaging.WriterThread;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.net.SocketFactory;
import org.picocontainer.annotations.Inject;

public class MonitoringAgent
implements MessagingAgent,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(MonitoringAgent.class.getName());
    private static final int HUNDRED_MS = 100;
    private static final int TEN_SECONDS = 10000;
    private WriterThread writerThread;
    private ReaderThread readerThread;
    @Inject
    private MessageQueue messageQueue;
    private Object readwriteThreadLock = new Object();
    private String serverAddress = "localhost";
    private int port = 29999;
    private String agetnIdentifier = "";
    private Socket socket;
    private Thread agentThread;
    private ArrayList<ConnectionListener> listeners = new ArrayList();
    @Inject
    private BaseServerProperties properties;
    @Inject
    private ThreadGroup threadGroup;

    @PostConstruct
    public void start() {
        try {
            this.agentThread = new Thread(this.threadGroup, this, "Monitoring Agent main thread");
            this.initializeParameters(this.properties);
            this.agentThread.start();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReaderThread getReaderThread() {
        Object object = this.readwriteThreadLock;
        synchronized (object) {
            return this.readerThread;
        }
    }

    private void initializeParameters(BaseServerProperties properties) throws UnknownHostException {
        String lagetnIdentifier = properties.getAgentIdentifier();
        String lserverAddress = properties.getServerAddress();
        if (!StringUtil.isEmpty((String)lagetnIdentifier)) {
            this.setAgetnIdentifier(lagetnIdentifier);
        }
        if (!StringUtil.isEmpty((String)lserverAddress)) {
            this.setServerAddress(lserverAddress);
        }
        this.setPort(properties.getServerPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        i = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                var2_2 = this.readwriteThreadLock;
                synchronized (var2_2) {
                    this.readerThread = null;
                    this.writerThread = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 7] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl15
                }
                do {
                    Thread.sleep(10000L);
lbl15:
                    // 2 sources

                } while (!this.tryConnect());
                Thread.sleep(100L);
                if (i != 0) {
                    for (ConnectionListener listener : this.listeners) {
                        listener.connectionReestablished();
                    }
                }
                ++i;
                while (this.writerThread.isAlive() && this.readerThread.isAlive()) {
                    Thread.sleep(10L);
                }
                if (this.readerThread.isAlive()) {
                    this.readerThread.interrupt();
                }
                if (this.writerThread.isAlive()) {
                    this.writerThread.interrupt();
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (ConnectionListener listener : this.listeners) {
                    listener.connectionLost();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private void setAgetnIdentifier(String agetnIdentifier) {
        this.agetnIdentifier = agetnIdentifier;
    }

    private void setPort(int port) {
        this.port = port;
    }

    private void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    @PreDestroy
    public void stop() {
        this.agentThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryConnect() throws InterruptedException {
        try {
            this.socket = SocketFactory.getDefault().createSocket(this.serverAddress, this.port);
        }
        catch (IOException ce) {
            return false;
        }
        try {
            this.socket.setSoTimeout(10000);
            ReaderThread readerThread = new ReaderThread(this.socket.getInputStream());
            WriterThread writerThread = new WriterThread(this.socket.getOutputStream(), readerThread, this.agetnIdentifier, this.messageQueue);
            Object object = this.readwriteThreadLock;
            synchronized (object) {
                this.readerThread = readerThread;
                this.writerThread = writerThread;
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }
}

