/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.messaging;

import com.dsoft.powerpro.agent.messaging.ReaderThread;
import com.dsoft.powerpro.internet.mserver.queue.BaseThread;
import com.dsoft.powerpro.internet.mserver.queue.MessageQueue;
import com.dsoft.powerpro.internet.mserver.queue.QueueObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriterThread
extends BaseThread {
    private static final Logger LOGGER = Logger.getLogger(WriterThread.class.getName());
    private static final String UTF_8 = "utf-8";
    private static final long TEN_SECONDS = 10000L;
    private MessageQueue messageQueue;

    WriterThread(OutputStream outputStream, ReaderThread readerThread, String agentIdentifier, MessageQueue messageQueue) throws IOException, InterruptedException {
        super("Writer thread");
        this.setOutputStream(outputStream);
        this.messageQueue = messageQueue;
        this.writeObject(agentIdentifier.getBytes(UTF_8), true, false);
        Object response = readerThread.peek(10000);
        if (response != null) {
            if (response instanceof String && ((String)response).equals("OK")) {
                this.start();
            } else {
                this.interrupt();
            }
        } else {
            this.interrupt();
        }
    }

    private void returnMessagesToQueue(Collection<QueueObject> messages) {
        for (QueueObject object : messages) {
            this.messageQueue.returnBackToQueue(object, null);
        }
    }

    public void run() {
        try {
            long lastWrite = System.currentTimeMillis();
            while (!this.isInterrupted()) {
                TreeSet<QueueObject> messages = new TreeSet<QueueObject>(this.messageQueue.popMessages(null));
                if (messages.isEmpty()) {
                    if (System.currentTimeMillis() - lastWrite > 10000L) {
                        this.writeObject("PING".getBytes(UTF_8), true, false);
                        lastWrite = System.currentTimeMillis();
                    }
                    WriterThread.sleep((long)10L);
                    continue;
                }
                this.writeMessages(messages);
                lastWrite = System.currentTimeMillis();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.info("Writer thread has been interrupted! Exiting writer thread.");
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void writeMessages(TreeSet<QueueObject> messages) throws Exception {
        block4: while (!messages.isEmpty()) {
            Iterator<QueueObject> it = messages.iterator();
            while (it.hasNext()) {
                QueueObject object = it.next();
                if ((object.getPriority() == null || object.getPriority() == 0) && this.messageQueue.containsHigPriorityMessages(null)) {
                    TreeSet<QueueObject> newMessages = new TreeSet<QueueObject>(this.messageQueue.popMessages(null));
                    newMessages.addAll(messages);
                    messages = newMessages;
                    continue block4;
                }
                try {
                    this.writeObject(object.getSerializedObject(), false, it.hasNext());
                }
                catch (IOException e) {
                    this.returnMessagesToQueue(messages);
                    throw e;
                }
                try {
                    this.messageQueue.confirmMessage(object.getId());
                    it.remove();
                }
                catch (Exception e) {
                    this.returnMessagesToQueue(messages);
                    throw e;
                }
            }
        }
    }
}

