/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.persistance;

import com.dsoft.framework.client.util.CopyObjectUtil;
import com.dsoft.powerpro.agent.BaseServerProperties;
import com.dsoft.powerpro.agent.persistance.AutoincrementPK;
import com.dsoft.powerpro.agent.persistance.Entity;
import com.dsoft.powerpro.agent.persistance.FinderException;
import com.dsoft.powerpro.agent.persistance.FinderExpression;
import com.dsoft.powerpro.agent.persistance.PersistanceException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePersistance {
    private static final Logger LOGGER = Logger.getLogger(FilePersistance.class.getName());
    private HashMap<Class<? extends Entity>, String> tablesMap = new HashMap();
    private HashMap<Class<? extends Entity>, HashMap<Object, ? extends Entity>> entitiesMap = new HashMap();
    private BaseServerProperties serverProperties;
    int loading = 0;
    private HashMap<Class<? extends Entity>, AutoincrementPK> keyGeneratorsMap = new HashMap();

    public FilePersistance(BaseServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void addEntity(Entity entity) throws PersistanceException {
        this.checkEntity(entity);
        this.registerEntity(entity.getClass(), entity);
        try {
            this.writeEntity(entity);
        }
        catch (IOException ex) {
            throw new PersistanceException("Error while storing entity on persistance storage", ex);
        }
    }

    private void checkEntity(Entity entity) throws PersistanceException {
        if (entity == null) {
            throw new PersistanceException("entity is null!!");
        }
        if (entity.getPrimaryKey() == null) {
            throw new PersistanceException("Entity primary key is null!!");
        }
        if (!this.tablesMap.containsKey(entity.getClass())) {
            throw new PersistanceException("Unsupported entity class");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Entity> Collection<E> findAll(Class<E> entityClass) throws FinderException {
        if (!this.checkForLoading()) {
            return null;
        }
        HashMap<Class<? extends Entity>, HashMap<Object, ? extends Entity>> hashMap = this.entitiesMap;
        synchronized (hashMap) {
            HashMap<Object, ? extends Entity> tableMap = this.entitiesMap.get(entityClass);
            if (tableMap != null) {
                ArrayList<Entity> result = new ArrayList<Entity>();
                try {
                    for (Entity entity : tableMap.values()) {
                        result.add((Entity)CopyObjectUtil.copyObject((Object)entity));
                    }
                }
                catch (Exception exception) {
                    throw new FinderException(exception);
                }
                return result;
            }
        }
        return new ArrayList();
    }

    private boolean checkForLoading() {
        try {
            while (this.loading > 0) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException ex1) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Entity> E findByPrimaryKey(Class<E> entityClass, Object primaryKey) throws FinderException {
        if (!this.checkForLoading()) {
            return null;
        }
        HashMap<Class<? extends Entity>, HashMap<Object, ? extends Entity>> hashMap = this.entitiesMap;
        synchronized (hashMap) {
            HashMap<Object, ? extends Entity> tableMap = this.entitiesMap.get(entityClass);
            if (tableMap == null) {
                throw new FinderException(String.format("Unable to find entity that matches primary key %1$s", primaryKey.toString()));
            }
            try {
                if (tableMap.containsKey(primaryKey) && tableMap.get(primaryKey) != null) {
                    return (E)((Entity)CopyObjectUtil.copyObject((Object)tableMap.get(primaryKey)));
                }
            }
            catch (Exception ex) {
                throw new FinderException(ex);
            }
        }
        throw new FinderException(String.format("Unable to find entity that matches primary key %1$s", primaryKey.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Entity> Collection<E> findEntities(Class<E> entityClass, FinderExpression<E> expression) throws FinderException {
        if (!this.checkForLoading()) {
            return null;
        }
        ArrayList<Entity> result = new ArrayList<Entity>();
        HashMap<Class<? extends Entity>, HashMap<Object, ? extends Entity>> hashMap = this.entitiesMap;
        synchronized (hashMap) {
            HashMap<Object, ? extends Entity> tableMap = this.entitiesMap.get(entityClass);
            if (tableMap == null) {
                return result;
            }
            try {
                for (Entity entity : tableMap.values()) {
                    if (!expression.acceptEntity(entity)) continue;
                    result.add((Entity)CopyObjectUtil.copyObject((Object)entity));
                }
            }
            catch (Exception exception) {
                throw new FinderException(exception);
            }
        }
        return result;
    }

    private String getDatabaseDirectoryName() {
        return String.valueOf(this.serverProperties.getDbDirectory()) + System.getProperty("file.separator") + "database";
    }

    private String getTableFileNamePrefix(String tableName) {
        return String.valueOf(this.getDatabaseDirectoryName()) + System.getProperty("file.separator") + tableName + "_";
    }

    private void loadEntities(final String tableName) throws IOException {
        final File dbDirectory = new File(this.getDatabaseDirectoryName());
        if (dbDirectory.exists()) {
            new Thread(){

                @Override
                public void run() {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, String.format("Loading entities for table %1$s", tableName));
                    }
                    ++FilePersistance.this.loading;
                    try {
                        File[] dbFiles;
                        File[] fileArray = dbFiles = dbDirectory.listFiles();
                        int n = dbFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File leaseFile = fileArray[n2];
                            if (leaseFile.getName().startsWith(tableName) && leaseFile.getName().endsWith(".xml")) {
                                Entity entity = null;
                                try {
                                    BufferedInputStream fis = new BufferedInputStream(new FileInputStream(leaseFile));
                                    try {
                                        XMLDecoder decoder = new XMLDecoder(fis);
                                        try {
                                            entity = (Entity)decoder.readObject();
                                        }
                                        finally {
                                            decoder.close();
                                        }
                                    }
                                    finally {
                                        ((InputStream)fis).close();
                                    }
                                }
                                catch (IOException ex) {
                                    LOGGER.log(Level.SEVERE, String.format("Error while reading entity %1$s", leaseFile.getName()), ex);
                                }
                                if (entity != null) {
                                    if (LOGGER.isLoggable(Level.FINER)) {
                                        LOGGER.log(Level.FINER, String.format("Loading entity for table %1$s and primary key %2$s", tableName, entity.getPrimaryKey().toString()));
                                    }
                                    Class<?> entityClass = entity.getClass();
                                    FilePersistance.this.registerEntity(entityClass, entity);
                                }
                            }
                            ++n2;
                        }
                    }
                    finally {
                        --FilePersistance.this.loading;
                    }
                }
            }.start();
        } else {
            dbDirectory.mkdirs();
        }
    }

    public <T> T nextPrimaryKey(Class<? extends Entity> tableClass) throws PersistanceException {
        if (this.keyGeneratorsMap.get(tableClass) == null) {
            throw new PersistanceException(String.format("There is no generator for table %1$s", tableClass));
        }
        return (T)this.keyGeneratorsMap.get(tableClass).nextPK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Entity> void registerEntity(Class<? extends Entity> entityClass, E entity) {
        HashMap<Object, ? extends Entity> tableMap = null;
        HashMap<Class<? extends Entity>, HashMap<Object, ? extends Entity>> hashMap = this.entitiesMap;
        synchronized (hashMap) {
            while ((tableMap = this.entitiesMap.get(entityClass)) == null) {
                this.entitiesMap.put(entityClass, new HashMap());
            }
            tableMap.put(entity.getPrimaryKey(), entity);
        }
    }

    public void registerTable(String tableName, Class<? extends Entity> tableClass) throws PersistanceException {
        this.tablesMap.put(tableClass, tableName);
        try {
            this.loadEntities(tableName);
        }
        catch (IOException ex) {
            throw new PersistanceException("Error while loading data from persistance storage", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTable(String tableName, Class<? extends Entity> tableClass, AutoincrementPK autoPK) throws PersistanceException {
        this.registerTable(tableName, tableClass);
        HashMap<Class<? extends Entity>, HashMap<Object, ? extends Entity>> hashMap = this.entitiesMap;
        synchronized (hashMap) {
            if (this.entitiesMap.get(tableClass) != null) {
                autoPK.initializePKGenerator(this.entitiesMap.get(tableClass).keySet().toArray());
            }
        }
        this.keyGeneratorsMap.put(tableClass, autoPK);
    }

    public void removeEntity(Entity entity) throws PersistanceException {
        this.checkEntity(entity);
        this.removeEntityFromMap(entity);
        String fileName = String.valueOf(this.getTableFileNamePrefix(this.tablesMap.get(entity.getClass()))) + entity.getPrimaryKey().toString().toUpperCase() + ".xml";
        File entityFile = new File(fileName);
        entityFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntityFromMap(Entity entity) {
        HashMap<Class<? extends Entity>, HashMap<Object, ? extends Entity>> hashMap = this.entitiesMap;
        synchronized (hashMap) {
            HashMap<Object, ? extends Entity> tableMap = this.entitiesMap.get(entity.getClass());
            if (tableMap != null) {
                tableMap.remove(entity.getPrimaryKey());
            }
        }
    }

    public void updateEntity(Entity entity) throws PersistanceException {
        this.checkEntity(entity);
        this.registerEntity(entity.getClass(), entity);
        try {
            this.writeEntity(entity);
        }
        catch (IOException ex) {
            throw new PersistanceException("Error while updating entity on persistance storage", ex);
        }
    }

    private void writeEntity(Entity entity) throws IOException {
        String fileName = String.valueOf(this.getTableFileNamePrefix(this.tablesMap.get(entity.getClass()))) + entity.getPrimaryKey().toString().toUpperCase() + ".xml";
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            XMLEncoder xmlEncoder = new XMLEncoder(fos);
            try {
                xmlEncoder.writeObject(entity);
                xmlEncoder.flush();
            }
            finally {
                xmlEncoder.close();
                fos.flush();
            }
        }
        finally {
            fos.close();
        }
    }
}

