/*
 * Decompiled with CFR 0.152.
 */
package com.dsoft.powerpro.agent.pool;

import com.dsoft.powerpro.agent.pool.PoolTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool
extends ThreadGroup {
    private static final Logger LOGGER = Logger.getLogger(ThreadPool.class.getName());
    private static int threadPoolID;
    private boolean isAlive;
    private LinkedList<PoolTask> taskQueue;
    private HashMap<String, PoolTask> threadMap;
    private HashSet<String> taskSet;
    int threadID = 0;
    private final Timer timer = new Timer(false);

    protected ThreadPool(int numThreads, String threadGroupname) {
        super(String.valueOf(threadGroupname) + "-" + threadPoolID++);
        this.setDaemon(true);
        this.isAlive = true;
        this.taskQueue = new LinkedList();
        this.threadMap = new HashMap();
        this.taskSet = new HashSet();
        int i = 0;
        while (i < numThreads) {
            new PooledThread().start();
            ++i;
        }
    }

    public synchronized void close() {
        if (this.isAlive) {
            this.isAlive = false;
            this.taskQueue.clear();
            this.interrupt();
        }
    }

    protected synchronized PoolTask getTask() throws InterruptedException {
        while (this.taskQueue.size() == 0) {
            if (!this.isAlive) {
                return null;
            }
            this.wait();
        }
        PoolTask task = this.taskQueue.removeFirst();
        this.taskSet.remove(task.getThreadId());
        return task;
    }

    public synchronized PoolTask getTaskById(String id) {
        return this.threadMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.isAlive = false;
            this.notifyAll();
        }
        Thread[] threads = new Thread[this.activeCount()];
        int count = this.enumerate(threads);
        int i = 0;
        while (i < count) {
            try {
                threads[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    public synchronized void removeTask(String threadId) {
        PoolTask thread = this.threadMap.get(threadId);
        if (thread != null) {
            thread.stopThread();
            this.threadMap.remove(threadId);
        }
    }

    public synchronized void runTask(PoolTask task, boolean priorityTask) {
        if (!this.isAlive) {
            throw new IllegalStateException();
        }
        if (task != null) {
            if (!this.taskSet.contains(task.getThreadId())) {
                if (priorityTask) {
                    this.taskQueue.addFirst(task);
                } else {
                    this.taskQueue.add(task);
                }
                this.taskSet.add(task.getThreadId());
            }
            if (!this.taskQueue.isEmpty()) {
                this.notify();
            }
        }
    }

    class ControlTimerTask
    extends TimerTask {
        PooledThread thread;
        private boolean compleated;

        public ControlTimerTask(PooledThread thread) {
            this.thread = thread;
            this.compleated = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ControlTimerTask controlTimerTask = this;
            synchronized (controlTimerTask) {
                if (!this.compleated) {
                    this.thread.compleated = true;
                    LOGGER.fine(String.format("Thread %1$s did not complete in 10 seconds so creating new thread!", this.thread.thrId));
                }
            }
        }
    }

    public class PooledThread
    extends Thread {
        String thrId;
        private boolean compleated;

        public PooledThread() {
            super((ThreadGroup)ThreadPool.this, String.valueOf(ThreadPool.this.getName()) + ThreadPool.this.threadID++);
            this.compleated = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block27: {
                    block26: {
                        if (!true) break block26;
                        if (this.isInterrupted()) return;
                        if (this.compleated) break block27;
                    }
                    do {
                        block25: {
                            ControlTimerTask controlTimerTask;
                            PoolTask task = null;
                            try {
                                task = ThreadPool.this.getTask();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.SEVERE, "Errro while wating for task", ex);
                            }
                            if (task == null) {
                                return;
                            }
                            ControlTimerTask timerTask = new ControlTimerTask(this);
                            try {
                                try {
                                    ThreadPool.this.threadMap.put(task.getThreadId(), task);
                                    this.thrId = task.getThreadId();
                                    task.setExecutionThread(this);
                                    ThreadPool.this.timer.schedule((TimerTask)timerTask, 10000L);
                                    task.run();
                                }
                                catch (Throwable t) {
                                    LOGGER.log(Level.WARNING, "Errro in pooled thread", t);
                                    ThreadPool.this.uncaughtException(this, t);
                                    controlTimerTask = timerTask;
                                    synchronized (controlTimerTask) {
                                        timerTask.compleated = true;
                                    }
                                    ThreadPool.this.threadMap.remove(this.thrId);
                                    break block25;
                                }
                            }
                            catch (Throwable throwable) {
                                controlTimerTask = timerTask;
                                synchronized (controlTimerTask) {
                                    timerTask.compleated = true;
                                }
                                ThreadPool.this.threadMap.remove(this.thrId);
                                throw throwable;
                            }
                            controlTimerTask = timerTask;
                            synchronized (controlTimerTask) {
                                timerTask.compleated = true;
                            }
                            ThreadPool.this.threadMap.remove(this.thrId);
                        }
                        if (this.isInterrupted()) return;
                    } while (!this.compleated);
                }
                return;
            }
            finally {
                if (ThreadPool.this.isAlive) {
                    new PooledThread().start();
                }
                LOGGER.fine("Exiting pooled thread");
            }
        }
    }
}

